########################################
######    Select unstables genes  ######
######         2018.02.05         ######
########################################

setwd("~/RMI2/Projet_TDD/20200114_Normalisation")
library(ggplot2)
theme_set(theme_bw())
library(reshape2)
library(DESeq2)
library(stringr)
library(dplyr)

load(file = "results/01_dbNormCountsAll_exon.RData")
stability_of_genes = list()
#

# 1. Lympho R -------------------------------------------------------------

## Pre processing data
pre_data = dball[dball$cell=="Lympho"&dball$`Activated/Resting`=="Resting",]

data = cbind(pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep1"&pre_data$time=="0h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep2"&pre_data$time=="0h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep3"&pre_data$time=="0h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep1"&pre_data$time=="3h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep2"&pre_data$time=="3h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep3"&pre_data$time=="3h","normReadsCounts"])
colnames(data) = c("Trip0hrep1","Trip0hrep2","Trip0hrep3","Trip3hrep1","Trip3hrep2","Trip3hrep3")
data = data * 100
data = apply(data, 2, as.integer)
rownames(data) = pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep1"&pre_data$time=="3h","ensemblID"]

avg_data<-cbind(rowSums(data[,1:3])/3, rowSums(data[,4:6])/3)
data = data[avg_data[,1]>50&avg_data[,2]>50,]

## Define conditions for each library
conds <- c("Trip0h","Trip0h","Trip0h","Trip3h","Trip3h","Trip3h")
colData = as.data.frame((colnames(data)));
colData<-cbind(colData, conds)
colnames(colData) = c("treatment","group");
groups = factor(colData[,2]);

##. Create DESeq data set using prepared table. 
dds = DESeqDataSetFromMatrix(countData=data, colData=colData, design = ~ group)

## Normalizing with sizeFactors = no normalizing because data are already norm
sizeFactors(dds) <- c(1,1,1,1,1,1)

## Run DESeq analysis
dds <- DESeq(dds)
res <- results(dds)

stability_of_genes[["LymphoR"]] = res


# 2. Lympho A -------------------------------------------------------------

## Pre processing data
pre_data = dball[dball$cell=="Lympho"&dball$`Activated/Resting`=="Activated",]

data = cbind(pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep1"&pre_data$time=="0h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep2"&pre_data$time=="0h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep3"&pre_data$time=="0h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep1"&pre_data$time=="3h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep2"&pre_data$time=="3h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep3"&pre_data$time=="3h","normReadsCounts"])
colnames(data) = c("Trip0hrep1","Trip0hrep2","Trip0hrep3","Trip3hrep1","Trip3hrep2","Trip3hrep3")
data = data * 100
data = apply(data, 2, as.integer)
rownames(data) = pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep1"&pre_data$time=="3h","ensemblID"]

avg_data<-cbind(rowSums(data[,1:3])/3, rowSums(data[,4:6])/3)
data = data[avg_data[,1]>50&avg_data[,2]>50,]

## Define conditions for each library
conds <- c("Trip0h","Trip0h","Trip0h","Trip3h","Trip3h","Trip3h")
colData = as.data.frame((colnames(data)));
colData<-cbind(colData, conds)
colnames(colData) = c("treatment","group");
groups = factor(colData[,2]);

##. Create DESeq data set using prepared table. 
dds = DESeqDataSetFromMatrix(countData=data, colData=colData, design = ~ group)

## Normalizing with sizeFactors = no normalizing because data are already norm
sizeFactors(dds) <- c(1,1,1,1,1,1)

## Run DESeq analysis
dds <- DESeq(dds)
res <- results(dds)

stability_of_genes[["LymphoA"]] = res


# 3. MacroR ---------------------------------------------------------------

## Pre processing data
pre_data = dball[dball$cell=="macro"&dball$`Activated/Resting`=="Resting",]

data = cbind(pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep1"&pre_data$time=="0h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep2"&pre_data$time=="0h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep3"&pre_data$time=="0h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep1"&pre_data$time=="3h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep2"&pre_data$time=="3h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep3"&pre_data$time=="3h","normReadsCounts"])
colnames(data) = c("Trip0hrep1","Trip0hrep2","Trip0hrep3","Trip3hrep1","Trip3hrep2","Trip3hrep3")
data = data * 100
data = apply(data, 2, as.integer)
rownames(data) = pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep1"&pre_data$time=="3h","ensemblID"]

avg_data<-cbind(rowSums(data[,1:3])/3, rowSums(data[,4:6])/3)
data = data[avg_data[,1]>50&avg_data[,2]>50,]

## Define conditions for each library
conds <- c("Trip0h","Trip0h","Trip0h","Trip3h","Trip3h","Trip3h")
colData = as.data.frame((colnames(data)));
colData<-cbind(colData, conds)
colnames(colData) = c("treatment","group");
groups = factor(colData[,2]);

##. Create DESeq data set using prepared table. 
dds = DESeqDataSetFromMatrix(countData=data, colData=colData, design = ~ group)

## Normalizing with sizeFactors = no normalizing because data are already norm
sizeFactors(dds) <- c(1,1,1,1,1,1)

## Run DESeq analysis
dds <- DESeq(dds)
res <- results(dds)

stability_of_genes[["MacroR"]] = res


# 4. MacroA ---------------------------------------------------------------

## Pre processing data
pre_data = dball[dball$cell=="macro"&dball$`Activated/Resting`=="Activated",]

data = cbind(pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep1"&pre_data$time=="0h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep2"&pre_data$time=="0h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep3"&pre_data$time=="0h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep1"&pre_data$time=="3h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep2"&pre_data$time=="3h","normReadsCounts"],
             pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep3"&pre_data$time=="3h","normReadsCounts"])
colnames(data) = c("Trip0hrep1","Trip0hrep2","Trip0hrep3","Trip3hrep1","Trip3hrep2","Trip3hrep3")
data = data * 100
data = apply(data, 2, as.integer)
rownames(data) = pre_data[pre_data$treatment=="Trip"&pre_data$replicate=="rep1"&pre_data$time=="3h","ensemblID"]

avg_data<-cbind(rowSums(data[,1:3])/3, rowSums(data[,4:6])/3)
data = data[avg_data[,1]>50&avg_data[,2]>50,]

## Define conditions for each library
conds <- c("Trip0h","Trip0h","Trip0h","Trip3h","Trip3h","Trip3h")
colData = as.data.frame((colnames(data)));
colData<-cbind(colData, conds)
colnames(colData) = c("treatment","group");
groups = factor(colData[,2]);

##. Create DESeq data set using prepared table. 
dds = DESeqDataSetFromMatrix(countData=data, colData=colData, design = ~ group)

## Normalizing with sizeFactors = no normalizing because data are already norm
sizeFactors(dds) <- c(1,1,1,1,1,1)

## Run DESeq analysis
dds <- DESeq(dds)
res <- results(dds)

stability_of_genes[["MacroA"]] = res


# 5. Save results ---------------------------------------------------------

save(stability_of_genes, file = "results/02_stability_of_genes.RData")
