library(ggplot2)
library(tidyverse)
library(reshape2)
theme_set(theme_bw())
library(gridExtra)

# setwd("~/RMI2/Projet_TDD/20200114_Normalisation")
table <- read.csv("data/databases/2020-03-26_07-39-50_Subset_Data_processed.csv")

color_resting = "#69b3a2"
color_activated = "#404080"
color_1h = "deepskyblue"
color_3h = "darkmagenta"

expressedGenes <- list(Lympho_Resting = unlist(read.csv(file = "results/filtred_genes_Lympho_Resting.csv")),
                       Lympho_Activated = unlist(read.csv(file = "results/filtred_genes_Lympho_Activated.csv")),
                       Macro_Resting = unlist(read.csv(file = "results/filtred_genes_Macro_Resting.csv")),
                       Macro_Activated = unlist(read.csv(file = "results/filtred_genes_Macro_Activated.csv")))

genes_RiboDens_Inf_1.5 <- table %>% filter(RiboDens.Lympho_Resting < 1.5 & RiboDens.Lympho_Activated < 1.5) %>% 
  select(gene_id) %>% 
  unlist() %>% 
  as.character()
genes_RiboDens_Inf_1.5 <- genes_RiboDens_Inf_1.5[genes_RiboDens_Inf_1.5 %in% expressedGenes[["Lympho_Resting"]] & genes_RiboDens_Inf_1.5 %in% expressedGenes[["Lympho_Activated"]]]

genes_RiboDens_Sup_1.5 <- table %>% filter(RiboDens.Lympho_Resting > 1.5 & RiboDens.Lympho_Activated > 1.5) %>% 
  select(gene_id) %>% 
  unlist() %>% 
  as.character()
genes_RiboDens_Sup_1.5 <- genes_RiboDens_Sup_1.5[genes_RiboDens_Sup_1.5 %in% expressedGenes[["Lympho_Resting"]] & genes_RiboDens_Sup_1.5 %in% expressedGenes[["Lympho_Activated"]]]


# Load protein database ---------------------------------------------------

library("openxlsx")
protein <- read.xlsx(xlsxFile = "data/databases/41467_2018_3106_MOESM5_ESM.xlsx")

data <- table %>% select(gene_name, 
                         Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h,
                         Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h,
                         Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
                         Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
                         RiboDens.Lympho_Resting,
                         RiboDens.Lympho_Activated)

data$gene_name <- toupper(data$gene_name)
protein$gene_name <- toupper(protein$gene_name)
data <- merge(data, protein, by = "gene_name")
# data <- na.exclude(data)


# plots -------------------------------------------------------------------
ggplot(data = data, aes(x = Bcells.replicate.1.half_life,
                        y = Bcells.replicate.2.half_life)) + 
  geom_point() + 
  geom_density_2d() + 
  geom_smooth(method = "lm", size = 1.5)

ggplot(data = data, aes(x = Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
                        y = Bcells.replicate.1.half_life)) + 
  geom_point() + 
  geom_density_2d() + 
  xlim(-1.5,1.5)+
  geom_smooth(method = "lm", size = 1.5)

ggplot(data = data, aes(x = Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
                        y = Bcells.replicate.2.half_life)) + 
  geom_point() + 
  xlim(-1.5,1.5)+
  geom_density_2d() + 
  geom_smooth(method = "lm", size = 1.5)

ggplot(data = data, aes(x = Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
                        y = Bcells.replicate.1.half_life)) + 
  geom_point() + 
  geom_density_2d() + 
  xlim(-1.5,1.5)+
  geom_smooth(method = "lm", size = 1.5)

ggplot(data = data, aes(x = Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
                        y = Bcells.replicate.2.half_life)) + 
  geom_point() + 
  xlim(-1.5,1.5)+
  geom_density_2d() + 
  geom_smooth(method = "lm", size = 1.5)

ggplot(data = data, aes(x = RiboDens.Lympho_Resting,
                        y = Bcells.replicate.1.half_life)) + 
  geom_point() + 
  geom_density_2d() + 
  # xlim(-1.5,1.5)+
  geom_smooth(method = "lm", size = 1.5)

ggplot(data = data, aes(x = RiboDens.Lympho_Resting,
                        y = Bcells.replicate.2.half_life)) + 
  geom_point() + 
  # xlim(-1.5,1.5)+
  geom_density_2d() + 
  geom_smooth(method = "lm", size = 1.5)

# Activated cells ---------------------------------------------------------

ggplot(data = data, aes(x = Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h,
                        y = Bcells.replicate.1.half_life)) + 
  geom_point() + 
  geom_density_2d() + 
  xlim(-1.5,1.5)+
  geom_smooth(method = "lm", size = 1.5)

ggplot(data = data, aes(x = Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h,
                        y = Bcells.replicate.2.half_life)) + 
  geom_point() + 
  xlim(-1.5,1.5)+
  geom_density_2d() + 
  geom_smooth(method = "lm", size = 1.5)

ggplot(data = data, aes(x = Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h,
                        y = Bcells.replicate.1.half_life)) + 
  geom_point() + 
  geom_density_2d() + 
  xlim(-1.5,1.5)+
  geom_smooth(method = "lm", size = 1.5)

ggplot(data = data, aes(x = Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h,
                        y = Bcells.replicate.2.half_life)) + 
  geom_point() + 
  xlim(-1.5,1.5)+
  geom_density_2d() + 
  geom_smooth(method = "lm", size = 1.5)

ggplot(data = data, aes(x = RiboDens.Lympho_Activated,
                        y = Bcells.replicate.1.half_life)) + 
  geom_point() + 
  geom_density_2d() + 
  # xlim(-1.5,1.5)+
  geom_smooth(method = "lm", size = 1.5)

ggplot(data = data, aes(x = RiboDens.Lympho_Activated,
                        y = Bcells.replicate.2.half_life)) + 
  geom_point() + 
  # xlim(-1.5,1.5)+
  geom_density_2d() + 
  geom_smooth(method = "lm", size = 1.5)

