library(tibble)
library(tidyr)
library(dplyr)
library(ggplot2)
library(gridExtra)
theme_set(theme_bw())


# PARAMETERS --------------------------------------------------------------
## minmal low expression
filter = TRUE

#path to the database
db <- "data/databases/2020-03-26_07-39-50_Subset_Data_processed.csv"

#color point
color_resting = "#69b3a2"
color_activated = "#404080"

# 1. prepare datas --------------------------------------------------------
table <- as_tibble(read.csv(db))
table$deltaTDD_Lympho <- table$Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h - table$Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h
table$deltaNonTDD_Lympho <- table$Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h - table$Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h

# 2. configure indexes --------------------------------------------------------------
index <- c("Length.utr5", 
           "UTR5_length", 
           "UTR5_GC", 
           "Length.cds", 
           "CDS_length", 
           "CDS_GC", 
           "Length.utr3", 
           "UTR3_length", 
           "UTR3_GC", 
           "trans_length",
           "n_m6ASeq_Peaks", 
           "total_m6ASeq_score",
           "CDS_DG", 
           "UTR5_DG", 
           "UTR3_DG", 
           "X47UTR5.30CDS_DG", 
           "X31CDS.End_DG", 
           "Kozack_score_frequency", 
           "Kozack_score_efficiency", 
           "Kozack_score_dinucleotide", 
           "n_introns_in_UTR5", 
           "n_CDS_fragments", 
           "n_introns_in_UTR3", 
           "n_exon", 
           "n_intron", 
           "Total_AUUUA", 
           "N_AUUUA_UTR5", 
           "N_AUUUA_CDS", 
           "N_AUUUA_UTR3", 
           "Total_UUAUUUAUU", 
           "N_UUAUUUAUU_UTR5", 
           "N_UUAUUUAUU_CDS", 
           "N_UUAUUUAUU_UTR3",
           "n4G_UTR5", 
           "n4G_CDS", 
           "n4G_UTR3", 
           "n4G_total", 
           "Stretches_AAA_AAG_score", 
           "Stretches_AAA_AAG_pondarated_score", 
           "Stretches_GAC_GAT_score", 
           "Stretches_GAC_GAT_pondarated_score", 
           "Stretches_GAA_GAG_score", 
           "Stretches_GAA_GAG_pondarated_score", 
           "Stretches_AAA_AAG_GAC_GAT_GAA_GAG_score", 
           "Stretches_AAA_AAG_GAC_GAT_GAA_GAG_pondarated_score", 
           "percent_ALA_A", 
           "percent_ARG_R", 
           "percent_ASN_N", 
           "percent_ASP_D", 
           "percent_CYS_C", 
           "percent_GLU_E", 
           "percent_GLN_Q", 
           "percent_GLY_G", 
           "percent_HIS_H", 
           "percent_ILE_I", 
           "percent_LEU_L", 
           "percent_LYS_K", 
           "percent_MET_M", 
           "percent_PHE_F", 
           "percent_PRO_P", 
           "percent_SER_S", 
           "percent_THR_T", 
           "percent_TRP_W", 
           "percent_TYR_Y", 
           "percent_VAL_V",
           "Hwang.transcript_half.life",
           "number_uORF",
           "sumKozakuOFR"
           )

index_lympho <- c("RiboDens.Lympho_Resting", 
                  "Exp_UTR3_Lympho_Resting_Mean",
                  "Hwang.Lympho_Resting.polyA_length")

index_macro <- c("RiboDens.Macro_Resting", 
                  "Exp_UTR3_Macro_Resting_Mean")

RiboDens_resting <- c("RiboDens.Lympho_Resting", 
                      "RiboDens.Macro_Resting")

RiboDens_activated <- c("RiboDens.Lympho_Activated", 
                      "RiboDens.Macro_Activated")

PasSeq_resting <- c("Exp_UTR3_Lympho_Resting_Mean", 
                    "Exp_UTR3_Macro_Resting_Mean")

PasSeq_activated <- c("Exp_UTR3_Lympho_Activated_Mean", 
                    "Exp_UTR3_Macro_Activated_Mean")

tddindex_resting <- c("Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h", 
                      # "Abs.TDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.3h", 
                      # "Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.1h", 
                      # "Abs.TDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.1h", 
                      "Abs.TDD..Lympho_Resting.Trip_Harr.Ref_Trip_0h.3h", 
                      # "Abs.TDD..Lympho_Resting.Trip_Harr.Ref_untreated_0h.3h", 
                      # "Abs.TDD..Lympho_Resting.Trip_Harr.Ref_Trip_0h.1h", 
                      # "Abs.TDD..Lympho_Resting.Trip_Harr.Ref_untreated_0h.1h",
                      "Abs.TDD..Macro_Resting.Trip_CHX.Ref_Trip_0h.3h", 
                      "Abs.TDD..Macro_Resting.Trip_Harr.Ref_Trip_0h.3h", 
                      "Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h", 
                      # "Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.3h", 
                      # "Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.1h", 
                      # "Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.1h", 
                      "Abs.NonTDD..Lympho_Resting.Trip_Harr.Ref_Trip_0h.3h", 
                      # "Abs.NonTDD..Lympho_Resting.Trip_Harr.Ref_untreated_0h.3h", 
                      # "Abs.NonTDD..Lympho_Resting.Trip_Harr.Ref_Trip_0h.1h", 
                      # "Abs.NonTDD..Lympho_Resting.Trip_Harr.Ref_untreated_0h.1h", 
                      "Abs.NonTDD..Macro_Resting.Trip_CHX.Ref_Trip_0h.3h", 
                      "Abs.NonTDD..Macro_Resting.Trip_Harr.Ref_Trip_0h.3h", 
                      "Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h", 
                      # "Rel.TDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.3h", 
                      # "Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.1h", 
                      # "Rel.TDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.1h", 
                      "Rel.TDD..Lympho_Resting.Trip_Harr.Ref_Trip_0h.3h", 
                      # "Rel.TDD..Lympho_Resting.Trip_Harr.Ref_untreated_0h.3h", 
                      # "Rel.TDD..Lympho_Resting.Trip_Harr.Ref_Trip_0h.1h", 
                      # "Rel.TDD..Lympho_Resting.Trip_Harr.Ref_untreated_0h.1h", 
                      "Rel.TDD..Macro_Resting.Trip_CHX.Ref_Trip_0h.3h", 
                      "Rel.TDD..Macro_Resting.Trip_Harr.Ref_Trip_0h.3h", 
                      "Rel.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h",
                      # "Rel.NonTDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.3h", 
                      # "Rel.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.1h", 
                      # "Rel.NonTDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.1h", 
                      "Rel.NonTDD..Lympho_Resting.Trip_Harr.Ref_Trip_0h.3h", 
                      # "Rel.NonTDD..Lympho_Resting.Trip_Harr.Ref_untreated_0h.3h", 
                      # "Rel.NonTDD..Lympho_Resting.Trip_Harr.Ref_Trip_0h.1h", 
                      # "Rel.NonTDD..Lympho_Resting.Trip_Harr.Ref_untreated_0h.1h", 
                      "Rel.NonTDD..Macro_Resting.Trip_CHX.Ref_Trip_0h.3h", 
                      "Rel.NonTDD..Macro_Resting.Trip_Harr.Ref_Trip_0h.3h",
                      "DegFold.Lympho_Resting.Trip.Ref_Trip_0h.3h", 
                      # "DegFold.Lympho_Resting.Trip.Ref_untreated_0h.3h", 
                      # "DegFold.Lympho_Resting.Trip.Ref_Trip_0h.1h", 
                      # "DegFold.Lympho_Resting.Trip.Ref_untreated_0h.1h", 
                      "DegFold.Macro_Resting.Trip.Ref_Trip_0h.3h",
                      "Abs.NonDEG..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h", 
                      # "Abs.NonDEG..Lympho_Resting.Trip_CHX.Ref_untreated_0h.3h", 
                      # "Abs.NonDEG..Lympho_Resting.Trip_CHX.Ref_Trip_0h.1h", 
                      # "Abs.NonDEG..Lympho_Resting.Trip_CHX.Ref_untreated_0h.1h", 
                      "Abs.NonDEG..Lympho_Resting.Trip_Harr.Ref_Trip_0h.3h", 
                      # "Abs.NonDEG..Lympho_Resting.Trip_Harr.Ref_untreated_0h.3h", 
                      # "Abs.NonDEG..Lympho_Resting.Trip_Harr.Ref_Trip_0h.1h", 
                      # "Abs.NonDEG..Lympho_Resting.Trip_Harr.Ref_untreated_0h.1h", 
                      "Abs.NonDEG..Macro_Resting.Trip_CHX.Ref_Trip_0h.3h", 
                      "Abs.NonDEG..Macro_Resting.Trip_Harr.Ref_Trip_0h.3h"
                      )

tddindex_activated <- c("Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h", 
                      # "Abs.TDD..Lympho_Activated.Trip_CHX.Ref_untreated_0h.3h", 
                      # "Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.1h", 
                      # "Abs.TDD..Lympho_Activated.Trip_CHX.Ref_untreated_0h.1h", 
                      "Abs.TDD..Lympho_Activated.Trip_Harr.Ref_Trip_0h.3h", 
                      # "Abs.TDD..Lympho_Activated.Trip_Harr.Ref_untreated_0h.3h", 
                      # "Abs.TDD..Lympho_Activated.Trip_Harr.Ref_Trip_0h.1h", 
                      # "Abs.TDD..Lympho_Activated.Trip_Harr.Ref_untreated_0h.1h", 
                      "Abs.TDD..Macro_Activated.Trip_CHX.Ref_Trip_0h.3h", 
                      "Abs.TDD..Macro_Activated.Trip_Harr.Ref_Trip_0h.3h", 
                      "Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h",
                      # "Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_untreated_0h.3h", 
                      # "Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.1h", 
                      # "Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_untreated_0h.1h", 
                      "Abs.NonTDD..Lympho_Activated.Trip_Harr.Ref_Trip_0h.3h", 
                      # "Abs.NonTDD..Lympho_Activated.Trip_Harr.Ref_untreated_0h.3h", 
                      # "Abs.NonTDD..Lympho_Activated.Trip_Harr.Ref_Trip_0h.1h", 
                      # "Abs.NonTDD..Lympho_Activated.Trip_Harr.Ref_untreated_0h.1h", 
                      "Abs.NonTDD..Macro_Activated.Trip_CHX.Ref_Trip_0h.3h", 
                      "Abs.NonTDD..Macro_Activated.Trip_Harr.Ref_Trip_0h.3h", 
                      "Rel.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h", 
                      # "Rel.TDD..Lympho_Activated.Trip_CHX.Ref_untreated_0h.3h", 
                      # "Rel.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.1h", 
                      # "Rel.TDD..Lympho_Activated.Trip_CHX.Ref_untreated_0h.1h", 
                      "Rel.TDD..Lympho_Activated.Trip_Harr.Ref_Trip_0h.3h", 
                      # "Rel.TDD..Lympho_Activated.Trip_Harr.Ref_untreated_0h.3h", 
                      # "Rel.TDD..Lympho_Activated.Trip_Harr.Ref_Trip_0h.1h", 
                      # "Rel.TDD..Lympho_Activated.Trip_Harr.Ref_untreated_0h.1h", 
                      "Rel.TDD..Macro_Activated.Trip_CHX.Ref_Trip_0h.3h", 
                      "Rel.TDD..Macro_Activated.Trip_Harr.Ref_Trip_0h.3h", 
                      "Rel.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h", 
                      # "Rel.NonTDD..Lympho_Activated.Trip_CHX.Ref_untreated_0h.3h", 
                      # "Rel.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.1h", 
                      # "Rel.NonTDD..Lympho_Activated.Trip_CHX.Ref_untreated_0h.1h", 
                      "Rel.NonTDD..Lympho_Activated.Trip_Harr.Ref_Trip_0h.3h", 
                      # "Rel.NonTDD..Lympho_Activated.Trip_Harr.Ref_untreated_0h.3h", 
                      # "Rel.NonTDD..Lympho_Activated.Trip_Harr.Ref_Trip_0h.1h",
                      # "Rel.NonTDD..Lympho_Activated.Trip_Harr.Ref_untreated_0h.1h", 
                      "Rel.NonTDD..Macro_Activated.Trip_CHX.Ref_Trip_0h.3h", 
                      "Rel.NonTDD..Macro_Activated.Trip_Harr.Ref_Trip_0h.3h",
                      "DegFold.Lympho_Activated.Trip.Ref_Trip_0h.3h", 
                      # "DegFold.Lympho_Activated.Trip.Ref_untreated_0h.3h", 
                      # "DegFold.Lympho_Activated.Trip.Ref_Trip_0h.1h", 
                      # "DegFold.Lympho_Activated.Trip.Ref_untreated_0h.1h",
                      "DegFold.Macro_Activated.Trip.Ref_Trip_0h.3h",
                      "Abs.NonDEG..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h", 
                      # "Abs.NonDEG..Lympho_Activated.Trip_CHX.Ref_untreated_0h.3h", 
                      # "Abs.NonDEG..Lympho_Activated.Trip_CHX.Ref_Trip_0h.1h", 
                      # "Abs.NonDEG..Lympho_Activated.Trip_CHX.Ref_untreated_0h.1h", 
                      "Abs.NonDEG..Lympho_Activated.Trip_Harr.Ref_Trip_0h.3h", 
                      # "Abs.NonDEG..Lympho_Activated.Trip_Harr.Ref_untreated_0h.3h", 
                      # "Abs.NonDEG..Lympho_Activated.Trip_Harr.Ref_Trip_0h.1h", 
                      # "Abs.NonDEG..Lympho_Activated.Trip_Harr.Ref_untreated_0h.1h", 
                      "Abs.NonDEG..Macro_Activated.Trip_CHX.Ref_Trip_0h.3h", 
                      "Abs.NonDEG..Macro_Activated.Trip_Harr.Ref_Trip_0h.3h"
                      )

tddindex_DRB <- c("Abs.TDD..Lympho_Activated.DRB_CHX.Ref_DRB_0h.3h", 
                  # "Abs.TDD..Lympho_Activated.DRB_CHX.Ref_DRB_0h.1h", 
                  "Abs.TDD..Lympho_Activated.DRB_Harr.Ref_DRB_0h.3h", 
                  # "Abs.TDD..Lympho_Activated.DRB_Harr.Ref_DRB_0h.1h", 
                  "Abs.NonTDD..Lympho_Activated.DRB_CHX.Ref_DRB_0h.3h", 
                  # "Abs.NonTDD..Lympho_Activated.DRB_CHX.Ref_DRB_0h.1h", 
                  "Abs.NonTDD..Lympho_Activated.DRB_Harr.Ref_DRB_0h.3h", 
                  # "Abs.NonTDD..Lympho_Activated.DRB_Harr.Ref_DRB_0h.1h", 
                  "Abs.NonDEG..Lympho_Activated.DRB_CHX.Ref_DRB_0h.3h", 
                  # "Abs.NonDEG..Lympho_Activated.DRB_CHX.Ref_DRB_0h.1h", 
                  "Abs.NonDEG..Lympho_Activated.DRB_Harr.Ref_DRB_0h.3h", 
                  # "Abs.NonDEG..Lympho_Activated.DRB_Harr.Ref_DRB_0h.1h", 
                  "Rel.TDD..Lympho_Activated.DRB_CHX.Ref_DRB_0h.3h", 
                  # "Rel.TDD..Lympho_Activated.DRB_CHX.Ref_DRB_0h.1h", 
                  "Rel.TDD..Lympho_Activated.DRB_Harr.Ref_DRB_0h.3h", 
                  # "Rel.TDD..Lympho_Activated.DRB_Harr.Ref_DRB_0h.1h", 
                  "Rel.NonTDD..Lympho_Activated.DRB_CHX.Ref_DRB_0h.3h", 
                  # "Rel.NonTDD..Lympho_Activated.DRB_CHX.Ref_DRB_0h.1h", 
                  "Rel.NonTDD..Lympho_Activated.DRB_Harr.Ref_DRB_0h.3h"
                  # "Rel.NonTDD..Lympho_Activated.DRB_Harr.Ref_DRB_0h.1h"
                  )
tddindex_delta <- c("deltaTDD_Lympho",
                    "deltaNonTDD_Lympho")


# functions ---------------------------------------------------------------
cap <- function(x){
  x[x < -1] <- -1
  x[x > 1.5] <- 1.5
  return(x)
}

plot_RA <- function(variable_resting, 
                    variable_activated,
                    resting_genes,
                    activated_genes,
                    cell = cell,
                    table = table, 
                    tddindex_resting = tddindex_resting, 
                    tddindex = tddindex) {

  sub_data_resting <- table %>% filter(gene_id %in% resting_genes) %>%
                                 dplyr::select(tddindex_resting[tddindex], 
                                               variable_resting)
  sub_data_resting <- na.exclude(sub_data_resting)
  sub_data_resting[,tddindex_resting[tddindex]] <- cap(sub_data_resting[,tddindex_resting[tddindex]])

  sub_data_activated <- table %>% filter(gene_id %in% activated_genes) %>% 
                                  dplyr::select(tddindex_activated[tddindex],
                                                variable_activated)
  sub_data_activated <- na.exclude(sub_data_activated)
  sub_data_activated[,tddindex_activated[tddindex]] <- cap(sub_data_activated[,tddindex_activated[tddindex]])
  
  # for resting
  bin <- round(nrow(sub_data_resting) / 300)
  tpm <- data.frame(matrix(nrow = nrow(sub_data_resting) %% bin, ncol = 2))
  sub_data_resting <- sub_data_resting[order(c(unlist(sub_data_resting[,variable_resting]))), ]
  
  # loop for calculate bin values
  c = 1
  for (j in 1:nrow(sub_data_resting)) {
    if (j %% bin == 0) {
      m1 = colMeans(sub_data_resting[((j - bin) + 1):j,variable_resting])
      m2 = colMeans(sub_data_resting[((j - bin) + 1):j,tddindex_resting[tddindex]])
      
      tpm[c, 1] = m1
      tpm[c, 2] = m2
      c = c + 1
    }
  }
  
  # rename dataframe and plot 
  colnames(tpm) <- c(variable_resting, tddindex_resting[tddindex])
  stats <- boxplot(tpm, plot = FALSE)[["stats"]]
  if (variable_resting == "Exp_UTR3_Lympho_Resting_Mean") {
    xmin <- 0
    xmax <- stats[5,1] + stats[5,1] * 0.05
    
    ymin <- stats[1,2] - stats[1,2] * 0.05
    ymax <- stats[5,2] + stats[5,2] * 0.05
  } else {
    xmin <- stats[1,1] - stats[1,1] * 0.05
    xmax <- stats[5,1] + stats[5,1] * 0.05
    
    ymin <- stats[1,2] - stats[1,2] * 0.05
    ymax <- stats[5,2] + stats[5,2] * 0.05
  }
  p1 <- ggplot(tpm, aes_string(x =variable_resting, y = tddindex_resting[tddindex])) + 
        ggtitle(paste("\t\t\tResting")) + 
        xlab(variable_resting) + 
        theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
              panel.background = element_blank(), axis.line = element_line(colour = "black")) +
        geom_point(color = color_resting) + ylim(ymin,ymax) + xlim(xmin,xmax) + 
    geom_smooth(method = "loess", size = 1.5)
  
  # for activated
  bin <- round(nrow(sub_data_activated) / 300)
  tpm <- data.frame(matrix(nrow = nrow(sub_data_activated) %% bin, ncol = 2))
  sub_data_activated <- sub_data_activated[order(c(unlist(sub_data_activated[,variable_activated]))), ]
  
  # loop for calculate bin values
  c = 1
  for (j in 1:nrow(sub_data_activated)) {
    if (j %% bin == 0) {
      m1 = colMeans(sub_data_activated[((j - bin) + 1):j,variable_activated])
      m2 = colMeans(sub_data_activated[((j - bin) + 1):j,tddindex_activated[tddindex]])
      
      tpm[c, 1] = m1
      tpm[c, 2] = m2
      c = c + 1
    }
  }
  
  # rename dataframe and plot 
  colnames(tpm) <- c(variable_activated, tddindex_activated[tddindex])
  
  stats <- boxplot(tpm, plot = FALSE)[["stats"]]
  if (variable_activated == "Exp_UTR3_Lympho_Activated_Mean") {
    xmin <- 0
    xmax <- stats[5,1] + stats[5,1] * 0.05
    
    ymin <- stats[1,2] - stats[1,2] * 0.05
    ymax <- stats[5,2] + stats[5,2] * 0.05
  } else {
    xmin <- stats[1,1] - stats[1,1] * 0.05
    xmax <- stats[5,1] + stats[5,1] * 0.05
    
    ymin <- stats[1,2] - stats[1,2] * 0.05
    ymax <- stats[5,2] + stats[5,2] * 0.05
  }
  
  p2 <- ggplot(tpm, aes_string(x = variable_activated, y = tddindex_activated[tddindex])) + 
        ggtitle(paste("\t\t\tactivated")) + 
        xlab(variable_activated) + 
        theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
          panel.background = element_blank(), axis.line = element_line(colour = "black")) +
        geom_point(color = color_activated) + ylim(ymin,ymax) + xlim(xmin,xmax) +
        geom_smooth(method = "loess", size = 1.5)
  
  p3 <- list(p1, p2)
  return(p3)
}

plot_A <- function(variable_activated,
                   activated_genes,
                   cell = cell,
                   table = table,
                   tddindex = tddindex) {
  
  sub_data_activated <- table %>% filter(gene_id %in% activated_genes) %>% 
    dplyr::select(tddindex_DRB[tddindex],
                  variable_activated)
  sub_data_activated <- na.exclude(sub_data_activated)
  
  # for activated
  bin <- round(nrow(sub_data_activated) / 300)
  tpm <- data.frame(matrix(nrow = nrow(sub_data_activated) %% bin, ncol = 2))
  sub_data_activated <- sub_data_activated[order(c(unlist(sub_data_activated[,variable_activated]))), ]
  
  # loop for calculate bin values
  c = 1
  for (j in 1:nrow(sub_data_activated)) {
    if (j %% bin == 0) {
      m1 = colMeans(sub_data_activated[((j - bin) + 1):j,variable_activated])
      m2 = colMeans(sub_data_activated[((j - bin) + 1):j,tddindex_DRB[tddindex]])
      
      tpm[c, 1] = m1
      tpm[c, 2] = m2
      c = c + 1
    }
  }
  
  # rename dataframe and plot 
  colnames(tpm) <- c(variable_activated, tddindex_DRB[tddindex])
  
  stats <- boxplot(tpm, plot = FALSE)[["stats"]]
  xmin <- stats[1,1] - stats[1,1] * 0.05
  xmax <- stats[5,1] + stats[5,1] * 0.05
  
  ymin <- stats[1,2] - stats[1,2] * 0.05
  ymax <- stats[5,2] + stats[5,2] * 0.05
  
  p2 <- ggplot(tpm, aes_string(x = variable_activated, y = tddindex_DRB[tddindex])) + 
    ggtitle(paste("\t\t\tactivated")) + 
    xlab(variable_activated) + 
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
          panel.background = element_blank(), axis.line = element_line(colour = "black")) +
    geom_point(color = color_activated) + ylim(ymin,ymax) + xlim(xmin,xmax) +
    geom_smooth(method = "loess", size = 1.5)

  return(p2)
}

plot_delta <- function(variable_activated,
                   activated_genes,
                   cell = cell,
                   table = table,
                   tddindex = tddindex) {
  
  sub_data_activated <- table %>% filter(gene_id %in% activated_genes) %>% 
    dplyr::select(tddindex_delta[tddindex],
                  variable_activated)
  sub_data_activated <- na.exclude(sub_data_activated)
  
  # for activated
  bin <- round(nrow(sub_data_activated) / 300)
  tpm <- data.frame(matrix(nrow = nrow(sub_data_activated) %% bin, ncol = 2))
  sub_data_activated <- sub_data_activated[order(c(unlist(sub_data_activated[,variable_activated]))), ]
  
  # loop for calculate bin values
  c = 1
  for (j in 1:nrow(sub_data_activated)) {
    if (j %% bin == 0) {
      m1 = colMeans(sub_data_activated[((j - bin) + 1):j,variable_activated])
      m2 = colMeans(sub_data_activated[((j - bin) + 1):j,tddindex_delta[tddindex]])
      
      tpm[c, 1] = m1
      tpm[c, 2] = m2
      c = c + 1
    }
  }
  
  # rename dataframe and plot 
  colnames(tpm) <- c(variable_activated, tddindex_delta[tddindex])
  
  stats <- boxplot(tpm, plot = FALSE)[["stats"]]
  xmin <- stats[1,1] - stats[1,1] * 0.05
  xmax <- stats[5,1] + stats[5,1] * 0.05
  
  ymin <- stats[1,2] - stats[1,2] * 0.05
  ymax <- stats[5,2] + stats[5,2] * 0.05
  
  p2 <- ggplot(tpm, aes_string(x = variable_activated, y = tddindex_delta[tddindex])) + 
    ggtitle(tddindex_delta[tddindex]) + 
    xlab(variable_activated) + 
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
          panel.background = element_blank(), axis.line = element_line(colour = "black")) +
    geom_point(color = color_activated) + ylim(ymin,ymax) + xlim(xmin,xmax) +
    geom_smooth(method = "loess", size = 1.5)
  
  return(p2)
}


filter_genes <- function(cutoff) {
  
  # lymphoResting
  keep_LR <- unlist(read.csv(file = "results/filtred_genes_Lympho_Resting.csv"))
  
  # lymphoActivated
  keep_LA <- unlist(read.csv(file = "results/filtred_genes_Lympho_Activated.csv"))
  
  # macroResting
  keep_MR <- unlist(read.csv(file = "results/filtred_genes_Macro_Resting.csv"))
  
  # macroActivated
  keep_MA <- unlist(read.csv(file = "results/filtred_genes_Macro_Activated.csv"))
  
  
  
  expressedGenes <- list(keep_LR, keep_LA, keep_MR, keep_MA)
  names(expressedGenes) <- c("Lympho_Resting", "Lympho_Activated", "Macro_Resting", "Macro_Activated")
  return(expressedGenes)
}

# Main -------------------------------------------------------------------

if (filter) {
  expressedGenes <- filter_genes(cutoff)
} else {
  expressedGenes <- list(table$gene_id, table$gene_id, table$gene_id, table$gene_id)
  names(expressedGenes) <- c("Lympho_Resting", "Lympho_Activated", "Macro_Resting", "Macro_Activated")
}

for (tddindex in 1:length(tddindex_resting)) {
  
  # Determine in the cell type
  if (length(grep("Lympho", tddindex_activated[tddindex], value = TRUE)) == 1 ) {
    cell <- "Lympho"
  }  else if (length(grep("Macro", tddindex_activated[tddindex], value = TRUE)) == 1 ) {
    cell <- "Macro"
  }
  
  # Determine in the state type
  if (length(grep("Activated", tddindex_activated[tddindex], value = TRUE)) == 1 ) {
    state <- "Activated"
  }  else if (length(grep("Resting", tddindex_activated[tddindex], value = TRUE)) == 1 ) {
    state <- "Resting"
  }
  
  if (filter) {
    filename <- paste0("results/binning/corr_binned_",
                       gsub("_Activated", "", tddindex_activated[tddindex]),
                       "_expressed_genes.pdf")
  } else {
    filename <- paste0("results/binning/corr_binned_",
                       gsub("_Activated", "", tddindex_activated[tddindex]),
                       ".pdf")
  }
  
  message(paste(Sys.time(), ": recording", filename))
  pdf(file = filename,
      width = 20,
      height = 10)
  
  # plot the TDD index activated vs resting
  suppressWarnings(print(ggplot(table %>% filter(gene_id %in% expressedGenes[[paste(cell,"Resting", sep ="_")]] &&
                                                gene_id %in% expressedGenes[[paste(cell,"Activated", sep ="_")]]), 
                             aes_string(x = tddindex_activated[tddindex], y = tddindex_resting[tddindex])) + 
                        theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
                              panel.background = element_blank(), axis.line = element_line(colour = "black")) +
                        geom_point(alpha = 0.5, color = "#383333") + 
                        ylab("resting") + xlab("activated") +  ylim(-0.5,1.5) + xlim(-0.5,1.5) +
                        ggtitle(gsub("_Activated", "", tddindex_activated[tddindex]))
  )
    )
  
  # loop inside index 
  for (i in index) {
    
    p3 <- plot_RA(variable_resting = i, 
                  variable_activated = i,
                  resting_genes = expressedGenes[[paste(cell,"Resting", sep = "_")]],
                  activated_genes = expressedGenes[[paste(cell,"Activated", sep = "_")]],
                  cell = cell,
                  table = table, 
                  tddindex_resting = tddindex_resting, 
                  tddindex = tddindex)
    suppressWarnings(print(grid.arrange(p3[[1]], p3[[2]], ncol = 2)))

  }
  
  if (cell == "Lympho") {
    for (i in index_lympho) {
      
      p3 <- plot_RA(variable_resting = i, 
                    variable_activated = gsub("Resting","Activated", i),
                    resting_genes = expressedGenes[[paste(cell,"Resting", sep = "_")]],
                    activated_genes = expressedGenes[[paste(cell,"Activated", sep = "_")]],
                    cell = cell,
                    table = table, 
                    tddindex_resting = tddindex_resting, 
                    tddindex = tddindex)
      suppressWarnings(print(grid.arrange(p3[[1]], p3[[2]], ncol = 2)))
      
    }
  } else if (cell == "Macro") {
    for (i in index_macro) {
      
      p3 <- plot_RA(variable_resting = i, 
                    variable_activated = gsub("Resting","Activated", i),
                    resting_genes = expressedGenes[[paste(cell,"Resting", sep = "_")]],
                    activated_genes = expressedGenes[[paste(cell,"Activated", sep = "_")]],
                    cell = cell,
                    table = table, 
                    tddindex_resting = tddindex_resting, 
                    tddindex = tddindex)
      suppressWarnings(print(grid.arrange(p3[[1]], p3[[2]], ncol = 2)))
    }
  }
  dev.off()
}

# Index with DRB for Lympho Activated only --------------------------------

for (tddindex in 1:length(tddindex_DRB)) {
  
  # Determine in the cell type
  if (length(grep("Lympho", tddindex_DRB[tddindex], value = TRUE)) == 1 ) {
    cell <- "Lympho"
  }  else if (length(grep("Macro", tddindex_DRB[tddindex], value = TRUE)) == 1 ) {
    cell <- "Macro"
  }
  
  # Determine in the state type
  if (length(grep("Activated", tddindex_DRB[tddindex], value = TRUE)) == 1 ) {
    state <- "Activated"
  }  else if (length(grep("Resting", tddindex_DRB[tddindex], value = TRUE)) == 1 ) {
    state <- "Resting"
  }
  
  if (filter) {
    filename <- paste0("results/binning/corr_binned_",
                       gsub("_Activated", "", tddindex_DRB[tddindex]),
                       "_expressed_genes.pdf")
  } else {
    filename <- paste0("results/binning/corr_binned_",
                       gsub("_Activated", "", tddindex_DRB[tddindex]),
                       ".pdf")
  }
  
  message(paste("recording ", filename))
  pdf(file = filename,
      width = 10,
      height = 10)
  for (i in index) {
    
    p3 <- plot_A(variable_activated = i,
                 activated_genes = expressedGenes[[paste(cell,"Activated", sep = "_")]],
                 cell = cell,
                 table = table, 
                 tddindex = tddindex)
    suppressWarnings(print(p3))
    
  }
  
  for (i in index_lympho) {
    
    p3 <- plot_A(variable_activated = gsub("Resting","Activated", i),
                 activated_genes = expressedGenes[[paste(cell,"Activated", sep = "_")]],
                 cell = cell,
                 table = table, 
                 tddindex = tddindex)
    suppressWarnings(print(p3))
    
  }
  dev.off()
}

# deltaTDD ----------------------------------------------------------------

for (tddindex in 1:length(tddindex_delta)) {
  
  # Determine in the cell type
  if (length(grep("Lympho", tddindex_delta[tddindex], value = TRUE)) == 1 ) {
    cell <- "Lympho"
  }  else if (length(grep("Macro", tddindex_delta[tddindex], value = TRUE)) == 1 ) {
    cell <- "Macro"
  }
  
  if (filter) {
    filename <- paste0("results/binning/corr_binned_",
                       tddindex_delta[tddindex],
                       "_expressed_genes.pdf")
  } else {
    filename <- paste0("results/binning/corr_binned_",
                       gsub("_Activated", "", tddindex_DRB[tddindex]),
                       ".pdf")
  }
  
  message(paste("recording ", filename))
  pdf(file = filename,
      width = 10,
      height = 10)
  for (i in index) {
    
    p3 <- plot_delta(variable_activated = i,
                 activated_genes = intersect(expressedGenes[[paste(cell,"Activated", sep = "_")]], expressedGenes[[paste(cell,"Resting", sep = "_")]]),
                 cell = cell,
                 table = table, 
                 tddindex = tddindex)
    suppressWarnings(print(p3))
    
  }
  
  for (i in index_lympho) {
    
    p3 <- plot_delta(variable_activated = gsub("Resting","Activated", i),
                 activated_genes = expressedGenes[[paste(cell,"Activated", sep = "_")]],
                 cell = cell,
                 table = table, 
                 tddindex = tddindex)
    suppressWarnings(print(p3))
    
  }
  dev.off()
}
