## correlation of TDD index 

db <- read.csv("../data/databases/current_subset.csv")
db <- dplyr::as_tibble(db)

TDDindexes <- dplyr::select(
  db,
  "Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h",
  "Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h",
  "Abs.TDD..Lympho_Activated.Trip_Harr.Ref_Trip_0h.3h",
  "Abs.TDD..Lympho_Resting.Trip_Harr.Ref_Trip_0h.3h",
  "Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.1h",
  "Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.1h",
  "Abs.TDD..Lympho_Activated.Trip_Harr.Ref_Trip_0h.1h",
  "Abs.TDD..Lympho_Resting.Trip_Harr.Ref_Trip_0h.1h",
  "Abs.TDD..Lympho_Activated.Trip_CHX.Ref_untreated_0h.3h",
  "Abs.TDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.3h",
  "Abs.TDD..Lympho_Activated.Trip_Harr.Ref_untreated_0h.3h",
  "Abs.TDD..Lympho_Resting.Trip_Harr.Ref_untreated_0h.3h",
  "Abs.TDD..Lympho_Activated.Trip_CHX.Ref_untreated_0h.1h",
  "Abs.TDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.1h",
  "Abs.TDD..Lympho_Activated.Trip_Harr.Ref_untreated_0h.1h",
  "Abs.TDD..Lympho_Resting.Trip_Harr.Ref_untreated_0h.1h",
  "Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h",
  "Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h",
  "Abs.NonTDD..Lympho_Activated.Trip_Harr.Ref_Trip_0h.3h",
  "Abs.NonTDD..Lympho_Resting.Trip_Harr.Ref_Trip_0h.3h",
  "Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.1h",
  "Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.1h",
  "Abs.NonTDD..Lympho_Activated.Trip_Harr.Ref_Trip_0h.1h",
  "Abs.NonTDD..Lympho_Resting.Trip_Harr.Ref_Trip_0h.1h",
  "Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_untreated_0h.3h",
  "Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.3h",
  "Abs.NonTDD..Lympho_Activated.Trip_Harr.Ref_untreated_0h.3h",
  "Abs.NonTDD..Lympho_Resting.Trip_Harr.Ref_untreated_0h.3h",
  "Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_untreated_0h.1h",
  "Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.1h",
  "Abs.NonTDD..Lympho_Activated.Trip_Harr.Ref_untreated_0h.1h",
  "Abs.NonTDD..Lympho_Resting.Trip_Harr.Ref_untreated_0h.1h"
)

TDDindexes <- na.exclude(TDDindexes)
library(corrplot)
M <- cor(TDDindexes)
corrplot(M, method = "circle", type="upper")

ggplot(data = TDDindexes, aes(x = Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
                              y = Abs.TDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.3h)) + 
  geom_point()

ggplot(data = TDDindexes, aes(x = Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h,
                              y = Abs.TDD..Lympho_Activated.Trip_CHX.Ref_untreated_0h.3h)) + 
  geom_point()

ggplot(data = TDDindexes, aes(x = Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
                              y = Abs.TDD..Lympho_Resting.Trip_Harr.Ref_Trip_0h.3h)) + 
  geom_point()


ggplot(data = TDDindexes, aes(x = Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
                              y = Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_untreated_0h.3h)) + 
  geom_point()
