# amino acid association script

library(gridExtra)
source(file = "~/RMI2/gitlab/tdd/src/CSC_functions.R")

color_resting = "#69b3a2"
color_activated = "#404080"

names_aa <- c("Ala", "Arg", "Asn", "Asp", "Cys", "Gln", "Glu", "Gly", "His", "Ile", "Leu", "Lys", "Met", "Phe", "Pro", "Ser", "Thr", "Trp", "Tyr", "Val")

fastaFile <- readDNAStringSet("~/RMI2/gitlab/tdd/data/cds_seq_mm10.txt")
aa_freq <- freq_AA(fastaFile)
df_aa_freq <- list_to_df(aa_freq, codon = FALSE)

pdf(file = "final_fig/rCSC_plots_aminoAcid",
    width = 8.3,
    height = 7)
# rCSC in R&A Lymphocytes 3h Trip -----------------------------------------

index_resting <- "Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h"
index_activated <- "Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h"

load("~/RMI2/gitlab/tdd/results/pvalCSC_amnioAcid_Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h.RData")
load("~/RMI2/gitlab/tdd/results/pvalCSC_aminoAcid_Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h.RData")

suppressWarnings(rCSC_resting <- get_rCSC(df_codon_freq = df_aa_freq, index = index_resting))
suppressWarnings(rCSC_activated <- get_rCSC(df_codon_freq = df_aa_freq, index = index_activated))


## With pval
barplot_resting <- barplot_rCSC(rCSC_resting, pval_resting$FDR)
barplot_resting <- barplot_resting + ggtitle(index_resting)

barplot_activated <- barplot_rCSC(rCSC_activated, pval_activated$FDR)
barplot_activated <- barplot_activated + ggtitle(index_activated)

grid.arrange(barplot_resting, barplot_activated, ncol = 1)

data <- cbind(as.data.frame(rCSC_resting),as.data.frame(rCSC_activated))
data$Name <- rownames(data)
data <- cbind(data, pval_resting$FDR, pval_activated$FDR)
data$sign <- "n.s"
data <- na.exclude(data)
data[data$`pval_resting$FDR` < 0.05 & data$`pval_activated$FDR` > 0.05, "sign"] <- "resting"
data[data$`pval_resting$FDR` > 0.05 & data$`pval_activated$FDR` < 0.05, "sign"] <- "activated"
data[data$`pval_resting$FDR` < 0.05 & data$`pval_activated$FDR` < 0.05, "sign"] <- "resting & activated"

ggplot(data = data, aes(x = rCSC_resting, y = rCSC_activated, color = sign)) +
 geom_point() +
 geom_abline(slope = 1, intercept = 0) +
 geom_vline(xintercept = 0, linetype = "dotted") +
 geom_hline(yintercept = 0, linetype = "dotted") +
 geom_text(aes(label=Name),hjust=0, vjust=0) +
 scale_color_manual("FDR", values = c("n.s" = "grey", "resting" = color_resting, "activated" = color_activated, "resting & activated" = "red" )) + 
  ggtitle("Absolute TDD index")


# Deg Fold ----------------------------------------------------------------

degfold_resting <- "DegFold.Lympho_Resting.Trip.Ref_Trip_0h.3h"
degfold_activated <- "DegFold.Lympho_Activated.Trip.Ref_Trip_0h.3h"

load("~/RMI2/gitlab/tdd/results/pvalCSC_amnioAcid_DegFold.Lympho_Resting.Trip.Ref_Trip_0h.3h.RData")
load("~/RMI2/gitlab/tdd/results/pvalCSC_aminoAcid_DegFold.Lympho_Activated.Trip.Ref_Trip_0h.3h.RData")

suppressWarnings(rCSC_degFold_resting <- get_rCSC(df_codon_freq = df_aa_freq, index = degfold_resting))
suppressWarnings(rCSC_degFold_activated <- get_rCSC(df_codon_freq = df_aa_freq, index = degfold_activated))

barplot_resting <- barplot_rCSC(rCSC_degFold_resting, pval_resting$FDR)
barplot_resting <- barplot_resting + ggtitle(degfold_resting)

barplot_activated <- barplot_rCSC(rCSC_degFold_activated, pval_activated$FDR)
barplot_activated <- barplot_activated + ggtitle(degfold_activated)

grid.arrange(barplot_resting, barplot_activated, ncol = 1)


data <- cbind(as.data.frame(rCSC_degFold_resting),as.data.frame(rCSC_degFold_activated))
data$Name <- rownames(data)
data <- cbind(data, pval_resting$FDR, pval_activated$FDR)
data$sign <- "n.s"
data <- na.exclude(data)
data[data$`pval_resting$FDR` < 0.05 & data$`pval_activated$FDR` > 0.05, "sign"] <- "resting"
data[data$`pval_resting$FDR` > 0.05 & data$`pval_activated$FDR` < 0.05, "sign"] <- "activated"
data[data$`pval_resting$FDR` < 0.05 & data$`pval_activated$FDR` < 0.05, "sign"] <- "resting & activated"

ggplot(data = data, aes(x = rCSC_degFold_resting, y = rCSC_degFold_activated, color = sign)) + 
  geom_point() + 
  geom_abline(slope = 1, intercept = 0) + 
  geom_text(aes(label=Name),hjust=0, vjust=0) + 
  geom_vline(xintercept = 0, linetype = "dotted") + 
  geom_hline(yintercept = 0, linetype = "dotted") +
  scale_color_manual("Sign", values = c("n.s" = "grey", "resting" = color_resting, "activated" = color_activated, "resting & activated" = "red" )) + 
  ggtitle("Degradation rate")


# Absolute Non TDD index --------------------------------------------------

index_resting <- "Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h"
index_activated <- "Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h"

load("~/RMI2/gitlab/tdd/results/pvalCSC_amnioAcid_Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h.RData")
load("~/RMI2/gitlab/tdd/results/pvalCSC_aminoAcid_Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h.RData")

suppressWarnings(rCSC_resting <- get_rCSC(df_codon_freq = df_aa_freq, index = index_resting))
suppressWarnings(rCSC_activated <- get_rCSC(df_codon_freq = df_aa_freq, index = index_activated))

barplot_resting <- barplot_rCSC(rCSC_resting, pval_resting$FDR)
barplot_resting <- barplot_resting + ggtitle(index_resting)

barplot_activated <- barplot_rCSC(rCSC_activated, pval_activated$FDR)
barplot_activated <- barplot_activated + ggtitle(index_activated)

grid.arrange(barplot_resting, barplot_activated, ncol = 1)

data <- cbind(as.data.frame(rCSC_resting),as.data.frame(rCSC_activated))
data$Name <- rownames(data)
data <- cbind(data, pval_resting$FDR, pval_activated$FDR)
data$sign <- "n.s"
data <- na.exclude(data)
data[data$`pval_resting$FDR` < 0.05 & data$`pval_activated$FDR` > 0.05, "sign"] <- "resting"
data[data$`pval_resting$FDR` > 0.05 & data$`pval_activated$FDR` < 0.05, "sign"] <- "activated"
data[data$`pval_resting$FDR` < 0.05 & data$`pval_activated$FDR` < 0.05, "sign"] <- "resting & activated"

ggplot(data = data, aes(x = rCSC_resting, y = rCSC_activated, color = sign)) +
  geom_point() +
  geom_abline(slope = 1, intercept = 0) +
  geom_vline(xintercept = 0, linetype = "dotted") +
  geom_hline(yintercept = 0, linetype = "dotted") +
  geom_text(aes(label=Name),hjust=0, vjust=0) +
  scale_color_manual("FDR", values = c("n.s" = "grey", "resting" = color_resting, "activated" = color_activated, "resting & activated" = "red" )) + 
  ggtitle("Absolute Non TDD index")

dev.off()