## Add lincRNA to the old count table


# load the old table 
old <- read.csv("data/HTSeq_count_stats_all_libraries.csv", row.names = 1)
new <- read.csv("/media/adminmanu/Stockage/projets/Projet_TDD/HTseq_for_lincRNA/results/quantification/all.count", sep = "\t", row.names = 1)

rownames(old) <- gsub("(^[^.]*)(.*$)", "\\1",  rownames(old))
rownames(new) <- gsub("(^[^.]*)(.*$)", "\\1",  rownames(new))

# keep the same columns in the tables 

colnames(new) <- gsub("noLPS","LPSno",x = colnames(new))

for (i in 1:length(colnames(new))){
  colnames(new)[i] <- paste0(colnames(new)[i], "_exon")
}

old <- old[,colnames(old)%in%colnames(new)]

# which column are not in the old dataframe ?
colnames(new)[!colnames(new)%in%colnames(old)]

# OK, let delete them
new <- new[,colnames(new)%in%colnames(old)]

# Are the column in the same order ?
col_new <- colnames(new)[order(colnames(new))]
col_old <- colnames(old)[order(colnames(old))]
col_new == col_old

  # select gene to add
# genetype <- read.csv("data/martquery_0330094042_479.txt", sep = "\t")
# 
# lncRNA <- as.character(genetype[genetype$Gene.type=="lncRNA","Gene.stable.ID"])
# unprocessed_pseudogenes <-  as.character(genetype[genetype$Gene.type=="unprocessed_pseudogene","Gene.stable.ID"])
# pseudogenes <- as.character(genetype[genetype$Gene.type=="pseudogene","Gene.stable.ID"])

lincRNA <- unlist(read.csv(file = "data/lincRNA.txt"))

# new <- new[rownames(new)%in%lncRNA |
#            rownames(new)%in%pseudogenes |
#            rownames(new)%in%unprocessed_pseudogenes ,]

new <- new[rownames(new)%in%lincRNA, ] 
old_and_new <- rbind(old, new)

write.csv(old_and_new, file = "data/exon_count_with_lncRNA.csv")

