# Ragnase I 
library(tidyverse)
library(ggplot2)

data <- read.csv(file = "data/Ragnase_paper/ko_wt_fold_change.csv")
table <- read.csv("data/databases/2020-03-26_07-39-50_Subset_Data_processed.csv")

str(data)

up <- data %>% filter(KO.WT.fold > 5) %>% select(gene_symbol) %>% unlist
down <- data %>% filter(KO.WT.fold < 0.2) %>% select(gene_symbol) %>% unlist

expressedGenes <- unlist(read.csv(file = "results/filtred_genes_Lympho_Resting.csv"))

gdat <- table %>% filter(gene_id %in% expressedGenes) %>%
  select(gene_id,
         gene_name, 
         Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
         Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h,
         Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
         Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h, 
         DegFold.Lympho_Resting.Trip.Ref_Trip_0h.3h,
         Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h)


gdat[gdat$Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h > 1.5, "Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h"] <- 1.5
gdat[gdat$Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h < -0.5, "Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h"] <- -0.5

gdat$legend <- "population"
gdat[gdat$gene_name %in% up, "legend"] <- "FC > 5"
gdat[gdat$gene_name %in% down, "legend"] <- "FC < 0.2"
gdat$legend <- factor(gdat$legend, levels = c("population", "FC > 5", "FC < 0.2"))
summary(gdat$legend)

ggplot(data = gdat, aes(x = legend, y = Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h)) + 
  geom_boxplot() + 
  theme_bw() + 
  ggtitle("Lympho Resting - genes Ragnase regulated")

ggplot(data = gdat, aes(x = legend, y = Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h)) + 
  geom_boxplot() + theme_bw() +
  ggtitle("Lympho Activated - genes Ragnase regulated")


ggplot(data = gdat, aes(x = legend, y = Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h)) + 
  geom_boxplot() + 
  theme_bw() + 
  ggtitle("Lympho Resting - genes Ragnase regulated")

ggplot(data = gdat, aes(x = legend, y = Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h)) + 
  geom_boxplot() + theme_bw() +
  ggtitle("Lympho Activated - genes Ragnase regulated")

ggplot(data = gdat, aes(x = legend, y = DegFold.Lympho_Resting.Trip.Ref_Trip_0h.3h)) + 
  geom_boxplot() + theme_bw() +
  ggtitle("Lympho Resting - genes Ragnase regulated")

ggplot(data = gdat, aes(x = legend, y = Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h)) + 
  geom_boxplot() + theme_bw() +
  ggtitle("Lympho Resting - genes Ragnase regulated")

# microarray data ---------------------------------------------------------

data <- read.csv(file = "data/Ragnase_paper/microarray_ko_wt_fold_change.csv")
table <- read.csv("data/databases/2020-03-26_07-39-50_Subset_Data_processed.csv")

str(data)

up <- data %>% filter(Naive.KO.WT > 2) %>% select(Gene.Symbol) %>% unlist
down <- data %>% filter(Naive.KO.WT < -2) %>% select(Gene.Symbol) %>% unlist

expressedGenes <- unlist(read.csv(file = "results/filtred_genes_Lympho_Resting.csv"))

gdat <- table %>% filter(gene_id %in% expressedGenes) %>%
  select(gene_id,
         gene_name, 
         Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
         Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h,
         Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
         Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h, 
         DegFold.Lympho_Resting.Trip.Ref_Trip_0h.3h,
         Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h)


gdat[gdat$Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h > 1.5, "Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h"] <- 1.5
gdat[gdat$Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h < -0.5, "Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h"] <- -0.5

gdat$legend <- "population"
gdat[gdat$gene_name %in% up, "legend"] <- "FC > 2"
gdat[gdat$gene_name %in% down, "legend"] <- "FC < -2"
gdat$legend <- factor(gdat$legend, levels = c("population", "FC > 2", "FC < -2"))
summary(gdat$legend)

ggplot(data = gdat, aes(x = legend, y = Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h)) + 
  geom_boxplot() + 
  theme_bw() + 
  ggtitle("Lympho Resting - genes Ragnase regulated")

ggplot(data = gdat, aes(x = legend, y = Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h)) + 
  geom_boxplot() + 
  theme_bw() + 
  ggtitle("Lympho Resting - genes Ragnase regulated")

ggplot(data = gdat, aes(x = legend, y = DegFold.Lympho_Resting.Trip.Ref_Trip_0h.3h)) + 
  geom_boxplot() + theme_bw() +
  ggtitle("Lympho Resting - genes Ragnase regulated")

ggplot(data = gdat, aes(x = legend, y = Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h)) + 
  geom_boxplot() + theme_bw() +
  ggtitle("Lympho Resting - genes Ragnase regulated")


# Paper IP -----------------------------------------------------------------

data <- read.csv(file = "data/Ragnase_paper/Regnase_IP.csv")
table <- read.csv("data/databases/2020-03-26_07-39-50_Subset_Data_processed.csv")

str(data)
data$enrichment.0h <- as.numeric(gsub(",","\\.", data$enrichment.0h))
data$enrichment.2h <- as.numeric(gsub(",","\\.", data$enrichment.2h))
str(data)

up <- data %>% filter(enrichment.0h > 3) %>% select(Symbol) %>% unlist

expressedGenes <- unlist(read.csv(file = "results/filtred_genes_Lympho_Resting.csv"))

gdat <- table %>% filter(gene_id %in% expressedGenes) %>%
  select(gene_id,
         gene_name, 
         Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
         Abs.TDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h,
         Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h,
         Abs.NonTDD..Lympho_Activated.Trip_CHX.Ref_Trip_0h.3h, 
         DegFold.Lympho_Resting.Trip.Ref_Trip_0h.3h,
         Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h)


gdat[gdat$Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h > 1.5, "Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h"] <- 1.5
gdat[gdat$Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h < -0.5, "Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h"] <- -0.5

gdat$legend <- "population"
gdat[toupper(gdat$gene_name) %in% up, "legend"] <- "Enrichement > 3"
gdat$legend <- factor(gdat$legend, levels = c("population", "Enrichement > 3"))
summary(gdat$legend)

ggplot(data = gdat, aes(x = legend, y = Abs.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h)) + 
  geom_boxplot() + 
  theme_bw() + 
  ggtitle("Lympho Resting - genes Ragnase regulated")

ggplot(data = gdat, aes(x = legend, y = Abs.NonTDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h)) + 
  geom_boxplot() + 
  theme_bw() + 
  ggtitle("Lympho Resting - genes Ragnase regulated")

ggplot(data = gdat, aes(x = legend, y = DegFold.Lympho_Resting.Trip.Ref_Trip_0h.3h)) + 
  geom_boxplot() + theme_bw() +
  ggtitle("Lympho Resting - genes Ragnase regulated")

ggplot(data = gdat, aes(x = legend, y = Rel.TDD..Lympho_Resting.Trip_CHX.Ref_Trip_0h.3h)) + 
  geom_boxplot() + theme_bw() +
  ggtitle("Lympho Resting - genes Ragnase regulated")
