

# A plotting R script produced by the REVIGO server at http://revigo.irb.hr/
# If you found REVIGO useful in your work, please cite the following reference:
# Supek F et al. "REVIGO summarizes and visualizes long lists of Gene Ontology
# terms" PLoS ONE 2011. doi:10.1371/journal.pone.0021800


# --------------------------------------------------------------------------
# If you don't have the ggplot2 package installed, uncomment the following line:
# install.packages( "ggplot2" );
library( ggplot2 );
# --------------------------------------------------------------------------
# If you don't have the scales package installed, uncomment the following line:
# install.packages( "scales" );
library( scales );


# --------------------------------------------------------------------------
# Here is your data from REVIGO. Scroll down for plot configuration options.

revigo.names <- c("term_ID","description","frequency_%","plot_X","plot_Y","plot_size","log10_p_value","uniqueness","dispensability");
revigo.data <- rbind(c("GO:0009987","cellular process",63.780, 4.883,-1.798, 6.913,-2.6344,0.983,0.000),
                     c("GO:0015031","protein transport", 2.251, 4.316,-4.408, 5.461,-3.4025,0.921,0.000),
                     c("GO:0016567","protein ubiquitination", 0.523,-6.240, 2.300, 4.827,-6.8204,0.719,0.000),
                     c("GO:0007040","lysosome organization", 0.019,-4.826, 5.992, 3.389,-2.7461,0.827,0.024),
                     c("GO:0007049","cell cycle", 1.885, 1.605, 4.590, 5.384,-3.4844,0.833,0.035),
                     c("GO:0006457","protein folding", 0.903, 6.827,-2.194, 5.064,-2.0439,0.905,0.038),
                     c("GO:0032088","negative regulation of NF-kappaB transcription factor activity", 0.014,-5.361,-3.649, 3.256,-3.9370,0.779,0.100),
                     c("GO:0030217","T cell differentiation", 0.044, 4.214, 3.226, 3.751,-3.2530,0.807,0.160),
                     c("GO:0006665","sphingolipid metabolic process", 0.093,-1.224, 4.756, 4.077,-2.9856,0.791,0.171),
                     c("GO:0007264","small GTPase mediated signal transduction", 0.485,-2.134,-5.316, 4.794,-3.0713,0.721,0.191),
                     c("GO:0006915","apoptotic process", 0.406, 1.560, 5.743, 4.717,-2.2108,0.792,0.197),
                     c("GO:0007017","microtubule-based process", 0.658, 1.210, 6.455, 4.927,-2.0088,0.843,0.208),
                     c("GO:0034616","response to laminar fluid shear stress", 0.002, 0.645,-6.797, 2.362,-2.2132,0.836,0.227),
                     c("GO:0002181","cytoplasmic translation", 0.064,-6.510, 0.259, 3.915,-2.4732,0.763,0.265),
                     c("GO:0030334","regulation of cell migration", 0.144, 0.061,-0.866, 4.267,-2.2481,0.780,0.266),
                     c("GO:0071364","cellular response to epidermal growth factor stimulus", 0.005,-1.497,-7.287, 2.842,-2.3273,0.845,0.280),
                     c("GO:0006511","ubiquitin-dependent protein catabolic process", 0.584,-7.257, 1.397, 4.874,-3.9365,0.731,0.321),
                     c("GO:0034976","response to endoplasmic reticulum stress", 0.100,-0.225,-6.824, 4.106,-2.7778,0.791,0.347),
                     c("GO:0016569","covalent chromatin modification", 0.424,-5.464, 4.066, 4.736,-3.5758,0.698,0.391),
                     c("GO:0001934","positive regulation of protein phosphorylation", 0.227,-4.290,-0.098, 4.465,-2.5046,0.662,0.417),
                     c("GO:0006364","rRNA processing", 0.952,-6.760,-0.784, 5.087,-2.4855,0.641,0.444),
                     c("GO:0006355","regulation of transcription, DNA-templated", 9.917,-4.777,-1.668, 6.105,-4.0717,0.650,0.452),
                     c("GO:0061154","endothelial tube morphogenesis", 0.004, 5.571, 2.016, 2.667,-2.4367,0.864,0.456),
                     c("GO:0032367","intracellular cholesterol transport", 0.005, 4.674,-4.767, 2.819,-2.4367,0.895,0.496),
                     c("GO:0006412","translation", 5.686,-5.899, 0.367, 5.863,-14.4833,0.678,0.526),
                     c("GO:0046854","phosphatidylinositol phosphorylation", 0.173,-0.572, 5.138, 4.347,-2.5373,0.808,0.527),
                     c("GO:0043484","regulation of RNA splicing", 0.040,-5.244,-2.839, 3.705,-2.1969,0.758,0.533),
                     c("GO:0001701","in utero embryonic development", 0.056, 5.605, 2.406, 3.860,-2.1781,0.860,0.539),
                     c("GO:0060742","epithelial cell differentiation involved in prostate gland development", 0.002, 4.915, 2.842, 2.470,-2.4367,0.820,0.554),
                     c("GO:0035556","intracellular signal transduction", 4.000,-1.945,-4.961, 5.710,-2.0467,0.677,0.593),
                     c("GO:0006974","cellular response to DNA damage stimulus", 2.360,-0.574,-6.762, 5.481,-2.6462,0.749,0.640));

one.data <- data.frame(revigo.data);
names(one.data) <- revigo.names;
one.data <- one.data [(one.data$plot_X != "null" & one.data$plot_Y != "null"), ];
one.data$plot_X <- as.numeric( as.character(one.data$plot_X) );
one.data$plot_Y <- as.numeric( as.character(one.data$plot_Y) );
one.data$plot_size <- as.numeric( as.character(one.data$plot_size) );
one.data$log10_p_value <- as.numeric( as.character(one.data$log10_p_value) );
one.data$frequency <- as.numeric( as.character(one.data$frequency) );
one.data$uniqueness <- as.numeric( as.character(one.data$uniqueness) );
one.data$dispensability <- as.numeric( as.character(one.data$dispensability) );
#head(one.data);


# --------------------------------------------------------------------------
# Names of the axes, sizes of the numbers and letters, names of the columns,
# etc. can be changed below

library(tidyverse)
one.x_range = max(one.data$plot_X) - min(one.data$plot_X);
one.y_range = max(one.data$plot_Y) - min(one.data$plot_Y);
ex <- one.data %>% filter (term_ID %in% c("GO:0016567",
                                          "GO:0006457",
                                          "GO:0006412",
                                          "GO:0043484",
                                          "GO:0007049",
                                          "GO:0030217",
                                          "GO:0007040")) 

require("ggrepel")
set.seed(42)
ggplot( data = one.data ) + 
  geom_point( aes( plot_X, plot_Y, colour = log10_p_value, size = plot_size), alpha = I(0.7) ) +
  scale_colour_gradientn( colours = c("red", "blue", "#69b3a2"), limits = c( min(one.data$log10_p_value), 0) ) + 
  # geom_point( aes(plot_X, plot_Y, size = plot_size), shape = 21, fill = "transparent", colour = I (alpha ("black", 0.6) )) + 
  scale_size( range=c(1, 20)) + 
  theme_bw() +
  labs (x = "semantic space x", y = "semantic space y") +
  # xlim(min(one.data$plot_X)-one.x_range/10,max(one.data$plot_X)+one.x_range/10) + 
  # ylim(min(one.data$plot_Y)-one.y_range/10,max(one.data$plot_Y)+one.y_range/10) +
  geom_text_repel( data = ex, aes(plot_X, plot_Y, label = description), colour = "black", size = 5,
                   box.padding = unit(0.5, "lines"),
                   point.padding = unit(0.5, "lines"), 
                   segment.size = 1) + 
  ggtitle("Differential gene expression - downregulated with the activation ")



# --------------------------------------------------------------------------
# Output the plot to screen

p1;

# Uncomment the line below to also save the plot to a file.
# The file type depends on the extension (default=pdf).

# ggsave("C:/Users/path_to_your_file/revigo-plot.pdf");




# A treemap R script produced by the REVIGO server at http://revigo.irb.hr/
# If you found REVIGO useful in your work, please cite the following reference:
# Supek F et al. "REVIGO summarizes and visualizes long lists of Gene Ontology
# terms" PLoS ONE 2011. doi:10.1371/journal.pone.0021800

# author: Anton Kratz <anton.kratz@gmail.com>, RIKEN Omics Science Center, Functional Genomics Technology Team, Japan
# created: Fri, Nov 02, 2012  7:25:52 PM
# last change: Fri, Nov 09, 2012  3:20:01 PM

# -----------------------------------------------------------------------------
# If you don't have the treemap package installed, uncomment the following line:
# install.packages( "treemap" );
library(treemap) 								# treemap package by Martijn Tennekes

# Set the working directory if necessary
# setwd("C:/Users/username/workingdir");

# --------------------------------------------------------------------------
# Here is your data from REVIGO. Scroll down for plot configuration options.

revigo.names <- c("term_ID","description","freqInDbPercent","abslog10pvalue","uniqueness","dispensability","representative");
revigo.data <- rbind(c("GO:0016567","protein ubiquitination",0.523,3.5751,0.247,0.000,"protein ubiquitination"),
                     c("GO:0006511","ubiquitin-dependent protein catabolic process",0.584,1.1066,0.245,0.321,"protein ubiquitination"),
                     c("GO:0006412","translation",5.686,10.9318,0.139,0.416,"protein ubiquitination"),
                     c("GO:0006355","regulation of transcription, DNA-templated",9.917,1.0238,0.212,0.513,"protein ubiquitination"),
                     c("GO:0032088","negative regulation of NF-kappaB transcription factor activity",0.014,1.0145,0.303,0.100,"negative regulation of NF-kappaB transcription factor activity"));

stuff <- data.frame(revigo.data);
names(stuff) <- revigo.names;

stuff$abslog10pvalue <- as.numeric( as.character(stuff$abslog10pvalue) );
stuff$freqInDbPercent <- as.numeric( as.character(stuff$freqInDbPercent) );
stuff$uniqueness <- as.numeric( as.character(stuff$uniqueness) );
stuff$dispensability <- as.numeric( as.character(stuff$dispensability) );

# by default, outputs to a PDF file
pdf( file="revigo_treemap.pdf", width=16, height=9 ) # width and height are in inches

# check the tmPlot command documentation for all possible parameters - there are a lot more
tmPlot(
  stuff,
  index = c("representative","description"),
  vSize = "abslog10pvalue",
  type = "categorical",
  vColor = "representative",
  title = "REVIGO Gene Ontology treemap",
  inflate.labels = FALSE,      # set this to TRUE for space-filling group labels - good for posters
  lowerbound.cex.labels = 0,   # try to draw as many labels as possible (still, some small squares may not get a label)
  bg.labels = "#CCCCCCAA",     # define background color of group labels
  # "#CCCCCC00" is fully transparent, "#CCCCCCAA" is semi-transparent grey, NA is opaque
  position.legend = "none"
)

dev.off()
