#! /bin/R

library(tidyverse)
load("results/dbNormCountsAll_exon.RData")

expressedGenes <- list(Lympho_Resting = unlist(read.csv(file = "~/RMI2/gitlab/tdd/results/filtred_genes_Lympho_Resting.csv")),
                       Lympho_Activated = unlist(read.csv(file = "~/RMI2/gitlab/tdd/results/filtred_genes_Lympho_Activated.csv")),
                       Macro_Resting = unlist(read.csv(file = "~/RMI2/gitlab/tdd/results/filtred_genes_Macro_Resting.csv")),
                       Macro_Activated = unlist(read.csv(file = "~/RMI2/gitlab/tdd/results/filtred_genes_Macro_Activated.csv")))

# calculate TDD index for each replicate ----------------------------------

db_Lympho_Resting_3hCHX <- dball %>% filter(cell == "Lympho"&
                                            `Activated/Resting` == "Resting" &
                                            (time == "0h" | time == "3h") &
                                            (treatment == "Trip" | treatment == "TripCHX")) %>%
                                     select(ensemblID, normReadsCounts, treatment, time, replicate)

db_Lympho_Resting_3hCHX$ensemblID <- gsub("(^[^.]*)(.*$)", "\\1",  db_Lympho_Resting_3hCHX$ensemblID)


test <- db_Lympho_Resting_3hCHX %>% filter(ensemblID == "ENSMUSG00000000078")

calcul_TDD_index <- function(gene) {
  x <- db_Lympho_Resting_3hCHX %>% 
  x <- x[order(x$replicate),]
  T0 <- x %>% filter(time == "0h") %>% select(normReadsCounts) %>% unlist
  T3 <- x %>% filter(time == "3h" & treatment == "Trip") %>% select(normReadsCounts) %>% unlist
  T3CHX <- x %>% filter(time == "3h" & treatment == "TripCHX") %>% select(normReadsCounts) %>% unlist
  
  tdd_index <- (T3CHX - T3) / T0
    names(tdd_index) <- paste(x$ensemblID[1], unique(x$replicate), sep = "_")
  return(tdd_index)
}

results <- list()
for (gene in expressedGenes[["Lympho_Resting"]]) {
  x <- db_Lympho_Resting_3hCHX %>% filter(ensemblID == gene)
  
}
calcul_TDD_index(test)





