# DESseq RNAseq

pks <- list('ggplot2',
            'tidyverse',
            'DESeq2',
            'reshape2',
            'stringr',
            'gridExtra',
            'RColorBrewer',
            'gplots')

lapply(pks , library , character.only = T, quietly = FALSE)

theme_set(theme_bw())

RNAseqFile = "rnaseq_count_forDESeq.csv"

data <- read.delim(file = RNAseqFile,
                          header = TRUE,
                          sep = ",",
                          row.names = 1,
                          stringsAsFactors = TRUE)
data <- data[,grep("Mock|HIV1", colnames(data))]

# Formatting colData
colData = as.data.frame((colnames(data)))
colData$`(colnames(data))` <- gsub("1h", "01h", colData$`(colnames(data))`)

conds = factor(substr(colData$`(colnames(data))`, 7,10))
time = factor(substr(colData$`(colnames(data))`,12,14))
replicate = factor(substr(colData$`(colnames(data))`,16,19))


colData <- cbind(colData, conds, time, replicate)
colnames(colData) <- c("library", "condition", "time", "replicate")

# Performing DESeq 
dds = DESeqDataSetFromMatrix(
  countData = as.matrix(data),
  colData = colData,
  design = ~ condition + time + replicate + time:condition
)

dds <- DESeq(dds)

# Checking DESeq model
plotDispEsts(dds)

rld <- rlogTransformation(dds, blind = TRUE)
vsd <- varianceStabilizingTransformation(dds, blind = TRUE)

plotPCA(rld)
plotPCA(rld, intgroup = c("condition", "time"))
plotPCA(rld, intgroup = c("time"))
plotPCA(rld, intgroup = c("condition"))
plotPCA(rld, intgroup = c("replicate"))


plotMA(res, alpha = 0.05)
summary(res)
table(res$padj < 0.05)
write.csv(res, file = "results/DESeqresults_lympho_activation_untreated.csv")