########################################################################
######    Functional Analysis from TDD genes (IndexTDD > 0.75)    ######
######                       2018.02.13                           ######
########################################################################

# 0. Set env --------------------------------------------------------------

setwd("~/RMI2/Projet_TDD/20200114_Normalisation/05_functionalAnalysis")

library(clusterProfiler)
library(openxlsx)
library("biomaRt")
load("../04_correlations/database.RData")

# 1. Transform Ensembl ID into Entrez ID ----------------------------------

mart <- useDataset("mmusculus_gene_ensembl", useMart("ensembl"))
list.biomart <- function (data)
{
  result <- getBM(attributes=c("ensembl_gene_id"), filters="ensembl_gene_id", values=data, mart = mart)
  return (result)
  
}

data_entrez <- lapply(as.list(table$EnsemblID), list.biomart) # each elements of the list is a data.frame
for (i in 1:11)  # loop to transform the data.frame in vector
{
  data_entrez[[i]] = data_entrez[[i]][,1]
}


# 2. enrichGO  ------------------------------------------------------------

# I don't know why the loop doesn't save the pdf... need to do the loop manually
for (i in 1:length(data_entrez))
{
  ego <- enrichGO(gene = data_entrez[[i]], 
                  keytype = "ENTREZID", 
                  OrgDb = 'org.Mm.eg.db', 
                  ont = "BP", 
                  pAdjustMethod = "BH", 
                  qvalueCutoff = 0.05, 
                  readable = TRUE)
  
  pdf(paste0("05_enrichGO_",names(data_entrez[i]),".pdf"), width = 10, height = 15)
  dotplot(ego, showCategory=50, x = "count", title = names(data_entrez[i]), font.size = 10)
  dev.off()
  
}


# 3. enrichKEGG -----------------------------------------------------------

kegg <- enrichKEGG(data_entrez$LymphoR[["entrezgene"]] ,organism = "mmu")
dotplot(kegg, showCategory=50)


# 4. compareCluster -------------------------------------------------------

compGO <- compareCluster(geneCluster = data_entrez, 
                           fun = "enrichGO",
                           keytype = "ENTREZID", 
                           OrgDb = 'org.Mm.eg.db', 
                           ont = "BP", 
                           pAdjustMethod = "BH", 
                           qvalueCutoff = 0.05,
                           readable = TRUE)
pdf(paste0("05_compareClusterGO.pdf"), width = 30, height = 30)
plot(compGO, showCategory = 50, title = "GO Enrichment Analysis", font.size = 10)
dev.off()


compKEGG <- compareCluster(geneCluster = data_entrez, 
                           fun = "enrichKEGG",
                           organism = 'mmu', 
                           pAdjustMethod = "BH", 
                           qvalueCutoff = 0.05)

pdf(paste0("05_compareClusterKEGG.pdf"), width = 30, height = 15)
plot(compKEGG, showCategory = 20, title = "KEGG Enrichment Analysis")
dev.off()


compKEGG@compareClusterResult %>% head()
compKEGG@compareClusterResult <- cbind(compKEGG@compareClusterResult, compKEGG@compareClusterResult[,"Count"]/sum(compKEGG@compareClusterResult[,"Count"]))
colnames(compKEGG@compareClusterResult) <- c(colnames(compKEGG@compareClusterResult)[1:(ncol(compKEGG@compareClusterResult)-1)],"p")

