use strict;

my $sample=shift;

open OUT,">","$sample.20kb.LBS" or die;

my @lines;
open IN,"<","lines_20kb_bins.txt" or die;
while(<IN>){
	chomp;
	push @lines,$_;
}
close IN;

foreach my $chr(1..18){
	my $i=0;
	my $row_num=$lines[$chr-1];
	my %tmp=();
	open IN,"gunzip -c matrix_$chr.$chr\_20000.$sample.comp.txt.gz |" or die;
	while(<IN>){
		chomp;
		my @a=split /\t/,$_;
		foreach my $j($i..$#a){
			$tmp{$i+1}{$j+1}=$a[$j];
		}
		$i++;
	}
	close IN;

	foreach my $bin(16..($row_num-16)){
		####  A1
		my $A1_start=$bin-15;
		my $A1_end=$A1_start+14;
		my $A1_CF=0;
		foreach my $n1($A1_start..$A1_end){
			foreach my $m1($n1..$A1_end){
				$A1_CF+=$tmp{$n1}{$m1};
			}
		}

		####  A2
		my $A2_start=$bin+1;
		my $A2_end=$A2_start+14;
		my $A2_CF=0;
		foreach my $n2($A2_start..$A2_end){
                        foreach my $m2($n2..$A2_end){
                                $A2_CF+=$tmp{$n2}{$m2};
                        }
                }

		####  B
		my $B_CF=0;
		foreach my $n3($A1_start..$A1_end){
			foreach my $m3($A2_start..$A2_end){
				$B_CF+=$tmp{$n3}{$m3};	
			}
		}

		#####  LBS
		next unless ($A1_CF+$A2_CF) > 0;
		next if ($B_CF == 0);
		my $LBS=log((($A1_CF+$A2_CF)/$B_CF))/log(2);
		my $pos=$bin*20000;
		my $pos_end=$pos+20000;
		print OUT "$chr\t$pos\t$pos_end\t$LBS\n";

	}
}


close OUT;
