use strict;

my $prefix='Liver_TB1';


my $bin=3;

open OUT,">","$prefix.20kb.HPS" or die;

for(my $chr1=1;$chr1<36;$chr1+=2){
	my $chr2=$chr1+1;
	my $real_chr=$chr2/2;
	my $file="matrix_$chr1\_$chr2\_20000.$prefix.comp.txt.gz.cpm.gz";
	my $row=0;
	my %hash=();
	open IN,"gunzip -c $file |" or die;
	while(<IN>){
		chomp;
		my @a=split /\t/,$_;
		foreach my $n(0..$#a){
			$hash{$row}{$n}=$a[$n];
		}
		$row++;
	}
	close IN;

	
	foreach my $i(($bin+1)..($row-$bin)){
		my $si=$i-($bin+1);
		my $se=$i+($bin-1);
		my $sum=0;
		foreach my $m1($si..$se){
			foreach my $m2($si..$se){
				$sum+=$hash{$m1}{$m2};
			}
		}
		if($sum > 0){
			my $PS=log($sum/(($bin*2+1)*($bin*2+1)))/log(2);
			my $start=($i-1)*20000;
			my $end=$start+20000;
			print OUT "$real_chr\t$start\t$end\t$PS\n";
		}
	}
	
	
}

close OUT;
