#!/bin/sh

###############################################
##    Variant Calling Using GATK4 Mutect2    ##
###############################################

## **Software required**
# gatk v4.2.0.0 (https://github.com/broadinstitute/gatk)
# gatk was executed using the NIG Supercomputer system (https://sc.ddbj.nig.ac.jp)
gatk="singularity exec /usr/local/biotools/g/gatk4:4.2.0.0--0 gatk" # path to gatk (in NIG Supercomputer)

## **Reference genome**
reference_genome="path_to_reference_genome/mm10.fa" # for mm10
# reference_genome="path_to_reference_genome/mm39.fa" # for mm39.fa

list=("RY1114 T6 T7" "RY1115 T2 T6")
for item in "${list[@]}"; do
    arr=($item)
    name=${arr[0]}
    normal="H"
    tumors=("${arr[@]:1}")  # Collect all tumor samples in an array
    mkdir -p $name/results/Mutect2
    
    for tumor in "${tumors[@]}"; do
        # Variant call by Mutect2 (tumor with matched normal mode)
        $gatk --java-options "-Xmx16g" Mutect2 \
        -R $reference_genome \
        -I $name/results/bam/${name}_${tumor}.bam \
        -I $name/results/bam/${name}_${normal}.bam \
        -normal $normal\
        -O $name/results/Mutect2/${name}${tumor}_${normal}.m2.vcf \
        -bamout $name/results/Mutect2/${name}${tumor}_${normal}.m2.bam
        
        # Label false positives with a list of failed filters and true positives with PASS
        $gatk FilterMutectCalls \
        --variant $name/results/Mutect2/${name}${tumor}_${normal}.m2.vcf \
        --output $name/results/Mutect2/${name}${tumor}_${normal}.m2.filt.vcf \
        --reference $reference_genome
    done
done
