#!/bin/sh

######################################################
##   Alignment of Fastq Files to Reference Genome   ##
######################################################

## **Software required**
# bwa v0.7.17 (https://github.com/lh3/bwa)
# bwa was executed using the NIG Supercomputer system (https://sc.ddbj.nig.ac.jp)
bwa="singularity exec /usr/local/biotools/b/bwa:0.7.17--h84994c4_5 bwa" # path to bwa (in the container of the NIG Supercomputer system)

## **Reference genome**
reference_genome="path_to_reference_genome/mm10.fa" # for mm10
# reference_genome="path_to_reference_genome/mm39.fa" # for mm39

threads=12 # number of threads
RAM=32

list=("RY1114 H T6 T7" "RY1115 H T2 T6")
for item in "${list[@]}"; do
    arr=($item)
    name=${arr[0]}
    tissues=("${arr[@]:1}")  # Collect all tissues in an array

    mkdir -p $name/temp
    
    for tissue in "${tissues[@]}"; do
        $bwa mem -t "$threads" -Y -K 10000000 -v 1 \
        $reference_genome \
        $name/fastq/${name}_${tissue}_1.fastq.gz \
        $name/fastq/${name}_${tissue}_2.fastq.gz \
        > $name/temp/${name}_${tissue}.sam
    done
done
