#!/bin/sh

#######################################
##   Quality Control of Fastq Files  ##
#######################################

## **Software required**
# FastQC v0.11.9 (https://anaconda.org/bioconda/fastqc)

## **Sample information**
# RY1114, RY1115: mouse IDs
# H: heart tissue, used as a normal control
# T2, T6, T7: tumor samples developed in the small intestine

sample_list=("RY1114 H SI-T6 SI-T7" "RY1115 H SI-T2 SI-T6")  # List of sample names and tissues
rawdata_dir="/path/to/rawdata"   # Path to the directory of original Fastq files
threads=4  # Number of FastQC threads

for item in "${sample_list[@]}"; do
  arr=($item)
  name=${arr[0]}
  tissues=("${arr[@]:1}")  # Collect tissue information for each sample in an array

  # Create output directories
  mkdir -p $name/fastq
  mkdir -p $name/results/QC

  for tissue in "${tissues[@]}"; do
    # Remove 'SI-' prefix if it exists
    new_tissue="${tissue#SI-}"

    # Copy Fastq files
    cp $rawdata_dir/${name}${tissue}_1.fastq.gz $name/fastq/${name}_${new_tissue}_1.fastq.gz
    cp $rawdata_dir/${name}${tissue}_2.fastq.gz $name/fastq/${name}_${new_tissue}_2.fastq.gz

    # Execute FastQC
    fastqc -t "$threads" $name/fastq/${name}_${new_tissue}_1.fastq.gz $name/fastq/${name}_${new_tissue}_2.fastq.gz \
    --outdir="$name/results/QC"
  done
done

