**LD-CHASE** - _A tool for mapping meiotic crossovers using low-coverage sequencing data from multiple sibling embryos._

![LD-CHASE_scheme](https://github.com/mccoy-lab/LD-CHASE/blob/main/illustrations/LD_CHASE.png)

Meiotic recombination is a fundamental source of human genetic diversity and is also critical for ensuring the accuracy of chromosome segregation. Understanding the landscape of meiotic recombination, its variation across individuals, and the processes by which it goes awry are long-standing goals in human genetics. Current approaches for inferring the landscape of recombination either rely on population genetic patterns of linkage disequilibrium (LD)—capturing a time-averaged view—or direct detection of crossovers in gametes or multi-generation pedigrees, limiting the scale and availability of relevant datasets. Here, we introduce an approach for inferring sex-specific landscapes of recombination from retrospective analysis of data from preimplantation genetic testing for aneuploidy (PGT-A), which is based on low-coverage (<0.05x) whole-genome sequencing of biopsies from in vitro fertilized (IVF) embryos. To overcome the sparsity of these data, our method exploits its inherent relatedness structure, knowledge of haplotypes from external population reference panels, as well as the frequent occurrence of chromosome loss in embryos, whereby the remaining chromosome is phased by default. LD-CHASE is a generalizable tool for mapping crossovers in low-coverage sequencing data from multiple siblings, toward a better understanding of the factors that modulate the meiotic crossover landscape and the role of recombination in the origins of aneuploidies.

**You can find an extensive tutorial containing usage instructions at this [Wiki page](https://github.com/mccoy-lab/LD-CHASE/wiki).**
