library(ggplot2)
library(reshape2)

args <- commandArgs(trailingOnly=TRUE)

if(length(args) == 0) {
    stop("A simulation result file needs to be specified");
}

data <- melt(read.table(args[1], header=T));
outfile <- gsub(".tsv$", ".pdf", args[1]);

gplot <- ggplot(data, aes(x=variable, y=value)) +
    geom_boxplot(outlier.colour="red") +
    coord_cartesian(ylim = c(0, 100))

ggsave(outfile, gplot)

