require(reshape);
require(ggplot2);

plotQualityHeatmap=function(assignment, cells, minlim=5, maxlim=150) {
  if(sum(assignment$QUAL>150)>0) {
    assignment[assignment$QUAL>150,]$QUAL = 150
  }
  qual=melt(assignment[assignment$Barcode %in% cells,][,c(1,3)],id.vars="Barcode")
  qual$value=as.numeric(qual$value)
  qual=qual[order(qual$value,decreasing=T),]
  qual_reorder=qual
  qual_reorder$Barcode = c(1:nrow(qual_reorder))
  p = ggplot(qual_reorder, aes(x = Barcode,y=variable)) +
    geom_raster(aes(fill = value), interpolate=TRUE) +
    #scale_fill_gradient2(low="grey26", mid="grey85", high="red", 
    #                     midpoint=10, limits=c(minlim, maxlim)) +
    scale_fill_gradientn(colours = c("#CEEBFA","#EEDCC5","#F4A473","#E67A56","#CD473E","#AE1D3E"), limits=c(minlim, maxlim))+
    theme_classic();
  print(p);
}

convertCellVariantMatrixSortCellByQual = function(data,cells,variant_range=NA,assignment){
  qual=assignment[assignment$Barcode %in% cells,][,c(1,3)]
  order = order(qual$QUAL,decreasing=T)
  
  if (!is.na(variant_range)) {
    matrix = data[variant_range,][,colnames(data) %in% cells]
    matrix = cbind(data[variant_range,]$variant,matrix[,order])
  } else {
    matrix = data[,colnames(data) %in% cells]
    matrix = cbind(data$variant,matrix[,order])
  }
  #print(head(matrix[,c(1:5)]))
  colnames(matrix) = c("variant", 1:(ncol(matrix)-1))
  matrix$variant = c(1:nrow(matrix))
  #print(head(matrix[,c(1:5)]))
  df_heatmap=melt(matrix,id.vars="variant")
  #print(head(df_heatmap))
  df_heatmap$variant = as.numeric(df_heatmap$variant)
  df_heatmap$variable = as.numeric(df_heatmap$variable)
  df_heatmap$value=as.numeric(df_heatmap$value)
  #print(head(df_heatmap))
  return(df_heatmap)
}
convertCellVariantMatrix = function(data,cells,variant_range=NA){
  if (!is.na(variant_range)) {
    matrix = data[variant_range,][,colnames(data) %in% cells]
    matrix = cbind(data[variant_range,]$variant,matrix)
  } else {
    matrix = data[,colnames(data) %in% cells]
    matrix = cbind(data$variant,matrix)
  }
  #print(head(matrix[,c(1:5)]))
  colnames(matrix) = c("variant", 1:(ncol(matrix)-1))
  matrix$variant = c(1:nrow(matrix))
  #print(head(matrix[,c(1:5)]))
  df_heatmap=melt(matrix,id.vars="variant")
  #print(head(df_heatmap))
  df_heatmap$variant = as.numeric(df_heatmap$variant)
  df_heatmap$variable = as.numeric(df_heatmap$variable)
  df_heatmap$value=as.numeric(df_heatmap$value)
  #print(head(df_heatmap))
  return(df_heatmap)
}

sample="pt1"
data = read.table(paste("../",sample,".bcell.scaf.tsv",sep=""), header=T)
assignment = read.table(paste("../expected_results/",sample,".assign_results.tsv",sep=""),header = T)

assignment$Barcode = gsub("-",".",assignment$Barcode)
rownames(assignment) = assignment$Barcode
assignment$QUAL[assignment$ASIG=="UNASSIGN"] = NA
assignment$QUAL=as.numeric(as.character(assignment$QUAL))
assignment$QUAL[is.na(assignment$QUAL)] = 0

assignment[assignment$QUAL == Inf,]$QUAL = max(assignment[assignment$QUAL!=Inf,]$QUAL)

## genotyping assigned cells ##
cells = rownames(assignment[assignment$ASIG == "pt1",])
print(head(cells));

print("B cells assigned to pt1")
print(length(cells))

df1 = convertCellVariantMatrixSortCellByQual(data,cells,assignment=assignment)
pdf(paste(sample,"_assigntopt1_cell_qual_sort.pdf",sep=""),width=4,height=2)
plotQualityHeatmap(assignment, cells)
dev.off()

cells = rownames(assignment[assignment$ASIG == "pt2",])
print("B cells assigned to pt2")
print(length(cells)) #0

cells = rownames(assignment[assignment$ASIG == "pt3",])
print("B cells assigned to pt3")
print(length(cells)) #0

cells = rownames(assignment[assignment$ASIG == "normal",])
print("B cells assigned to normal")
print(length(cells)) #0

cells = rownames(assignment[assignment$ASIG == "UNASSIGN",])
print("B cells assigned to unassign")
print(length(cells)) #0

pdf(paste(sample,"_genotype_Bcell_sortbyquality.pdf",sep=""),width=8,height=4)
par(mfrow=c(1,1))
df_combined_1 = df1
b = df_combined_1[df_combined_1$value==0,]
c = df_combined_1[df_combined_1$value>0,]
plot(b$variable, b$variant,pch=16, cex=0.3,col="#00FF0050",ylim=c(1,max(df_combined_1$variant)),xlim=c(1,max(df_combined_1$variable)),
     xlab="Cell index",ylab="Variant index", main="Genotype of B cells")
points(c$variable, c$variant,pch=16, cex=0.3,col="#0000FF50",ylim=c(1,max(df_combined_1$variant)),xlim=c(1,max(df_combined_1$variable)))
abline(h = 44.5)
abline(h = 53.5)
dev.off()
