#!/bin/bash

project_root=$(readlink -f ../../../)
SC_ASSIGN="docker run -t -v$(pwd):/tmp -w/tmp --rm qiaoy/scbayes scAssign"

# sometimes docker output is in Windows newline style \0d\0a
# this removes the \0d to make the result comparable to linux outputs
NEWLINE_FIX="sed -e s/\r//g"

echo "Performing pre-treatment cells assignment ..."
$SC_ASSIGN pre.assign.yml pre.genotype | $NEWLINE_FIX > pre.assign_results.tsv
echo "Done. Results written to pre.assign_results.tsv"
echo ""

echo "Performing post-treatment cells assignment ..."
$SC_ASSIGN post.assign.yml post.genotype | $NEWLINE_FIX > post.assign_results.tsv
echo "Done. Results written to post.assign_results.tsv"
echo ""
