### Read the file with mRNA counts.
P2_L3<-read.csv(file="P2_L3.csv")
exon<-read.csv(file="exon.csv")
### Read the file which included genes with high site density (top 15%).
target<-read.csv(file="target_15.csv")
L3ribo_1<-read.table(file="L3-1_counts.txt")
L3ribo_2<-read.table(file="L3-2_counts.txt")
L3ribo_3<-read.table(file="L3-3_counts.txt")
P1ribo_1<-read.table(file="P1-1_counts.txt")
P1ribo_2<-read.table(file="P1-2_counts.txt")
P2ribo_1<-read.table(file="P2-1_counts.txt")
P2ribo_2<-read.table(file="P2-2_counts.txt")
ribo<-merge(L3ribo_1,L3ribo_2,by="V1")
ribo<-merge(ribo,L3ribo_3,by="V1")
ribo<-merge(ribo,P1ribo_1,by="V1")
ribo<-merge(ribo,P1ribo_2,by="V1")
ribo<-merge(ribo,P2ribo_1,by="V1")
ribo<-merge(ribo,P2ribo_2,by="V1")
colnames(ribo)<-c("Geneid","L3ribo_1","L3ribo_2","L3ribo_3","P1ribo_1","P1ribo_2","P2ribo_1","P2ribo_2")
mfuzz_TE<-P2_L3[,c("Geneid","L3_1","L3_2","L3_3","P2_1","P2_2")]
mfuzz_TE<-merge(mfuzz_TE,P1_mRNA,by="Geneid")
mfuzz_TE<-merge(mfuzz_TE,exon,by="Geneid")
mfuzz_TE<-merge(mfuzz_TE,ribo,by="Geneid")
mfuzz_TE$L3_1<-(mfuzz_TE$L3_1/sum(mfuzz_TE$L3_1)*1000000)/mfuzz_TE$exon*1000
mfuzz_TE$L3_2<-(mfuzz_TE$L3_2/sum(mfuzz_TE$L3_2)*1000000)/mfuzz_TE$exon*1000
mfuzz_TE$L3_3<-(mfuzz_TE$L3_3/sum(mfuzz_TE$L3_3)*1000000)/mfuzz_TE$exon*1000
mfuzz_TE$P1_2<-(mfuzz_TE$P1_2/sum(mfuzz_TE$P1_2)*1000000)/mfuzz_TE$exon*1000
mfuzz_TE$P1_1<-(mfuzz_TE$P1_1/sum(mfuzz_TE$P1_1)*1000000)/mfuzz_TE$exon*1000
mfuzz_TE$P2_2<-(mfuzz_TE$P2_2/sum(mfuzz_TE$P2_2)*1000000)/mfuzz_TE$exon*1000
mfuzz_TE$P2_1<-(mfuzz_TE$P2_1/sum(mfuzz_TE$P2_1)*1000000)/mfuzz_TE$exon*1000
mfuzz_TE$P2_mRNA<-(mfuzz_TE$P2_1+mfuzz_TE$P2_2)/2
mfuzz_TE$P1_mRNA<-(mfuzz_TE$P1_1+mfuzz_TE$P1_2)/2
mfuzz_TE$L3_mRNA<-(mfuzz_TE$L3_1+mfuzz_TE$L3_2+mfuzz_TE$L3_3)/3
mfuzz_TE$L3ribo_1<-(mfuzz_TE$L3ribo_1/sum(mfuzz_TE$L3ribo_1)*1000000)
mfuzz_TE$L3ribo_2<-(mfuzz_TE$L3ribo_2/sum(mfuzz_TE$L3ribo_2)*1000000)
mfuzz_TE$L3ribo_3<-(mfuzz_TE$L3ribo_3/sum(mfuzz_TE$L3ribo_3)*1000000)
mfuzz_TE$P1ribo_2<-(mfuzz_TE$P1ribo_2/sum(mfuzz_TE$P1ribo_2)*1000000)
mfuzz_TE$P1ribo_1<-(mfuzz_TE$P1ribo_1/sum(mfuzz_TE$P1ribo_1)*1000000)
mfuzz_TE$P2ribo_2<-(mfuzz_TE$P2ribo_2/sum(mfuzz_TE$P2ribo_2)*1000000)
mfuzz_TE$P2ribo_1<-(mfuzz_TE$P2ribo_1/sum(mfuzz_TE$P2ribo_1)*1000000)
mfuzz_TE$P2_ribo<-(mfuzz_TE$P2ribo_1+mfuzz_TE$P2ribo_2)/2
mfuzz_TE$P1_ribo<-(mfuzz_TE$P1ribo_1+mfuzz_TE$P1ribo_2)/2
mfuzz_TE$L3_ribo<-(mfuzz_TE$L3ribo_1+mfuzz_TE$L3ribo_2+mfuzz_TE$L3ribo_3)/3
mfuzz_TE$P2_TE<-mfuzz_TE$P2_ribo/mfuzz_TE$P2_mRNA
mfuzz_TE$P1_TE<-mfuzz_TE$P1_ribo/mfuzz_TE$P1_mRNA
mfuzz_TE$L3_TE<-mfuzz_TE$L3_ribo/mfuzz_TE$L3_mRNA

library(Mfuzz)
tt<-subset(mfuzz_TE,L3_mRNA>5 & P1_mRNA >5 & P2_mRNA >5)
tt<-subset(tt,abs(log(P1_L3_FC,2))>1 | abs(log(P2_P1_FC,2))>1)
cc<-tt[,c("Geneid","L3_TE","P1_TE","P2_TE")]
row.names(cc)<-cc$Geneid
cc<-cc[,-1]
cc<-as.matrix(cc)
aa<-new('ExpressionSet',exprs=cc)
aa<-filter.NA(aa,thres=0.25)
aa<-fill.NA(aa,mode='mean')
aa<-filter.std(aa,min.std = 0)
aa<-filter.std(aa,min.std = 0)
aa<-standardise(aa)
c<-4
cl<-mfuzz(aa,c=c,m=m)
color.2 <- colorRampPalette(rev(c("#949494", "#a9a9a9", "#bdbebd")))(10000)
mfuzz.plot(aa,cl=cl,mfrow = c(1,4),colo = color.2)
gene_cluster <- cl$cluster
cl$size
gene_standard <- aa@assayData$exprs
gene_standard_cluster <- cbind(gene_standard[names(gene_cluster), ], gene_cluster)
gene_standard_cluster<-as.data.frame(gene_standard_cluster)
gene_standard_cluster$Geneid<-rownames(gene_standard_cluster)
gene_standard_cluster<-merge(gene_standard_cluster,target_15,by="Geneid")
meta_TE1<-subset(gene_standard_cluster,gene_cluster=="1" & type=="meta")
meta_mRNA1<-meta_mRNA1[,c("Geneid","L3","P1","P2")]
meta_mRNA1<-melt(meta_mRNA1)
library(ggplot2)
ggplot(meta_mRNA1,aes(variable,value,group=Geneid))+geom_point()+geom_line()+theme_bw()