library(AnnotationDbi)
library( org.Dm.eg.db)
library(clusterProfiler)                                

### DEGs were considered with a significant change when FDR-adjusted p-value < 0.05 and |log2(foldchange)| > 1 in a DESeq2 analysis.
count<-diff$Geneid
gene <-  mapIds(org.Dm.eg.db, count, 'ENTREZID', 'FLYBASE')
BP.params <- enrichGO(   gene   = gene,    
                         OrgDb  = org.Dm.eg.db,    
                         ont   = "BP"  ,    
                         pAdjustMethod = "BH",    
                         pvalueCutoff  = 0.01,    
                         qvalueCutoff  = 0.05) 
BP.list <- setReadable(BP.params, org.Dm.eg.db, keyType = "ENTREZID")