/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.flow;

import java.util.List;
import org.jfree.chart.util.Args;
import org.jfree.data.flow.FlowDataset;
import org.jfree.data.flow.FlowKey;
import org.jfree.data.flow.NodeKey;

public class FlowDatasetUtils {
    private FlowDatasetUtils() {
    }

    public static <K extends Comparable<K>> double calculateInflow(FlowDataset<K> dataset, K node, int stage) {
        Args.nullNotPermitted(dataset, "dataset");
        Args.nullNotPermitted(node, "node");
        Args.requireInRange(stage, "stage", 0, dataset.getStageCount());
        if (stage == 0) {
            return 0.0;
        }
        double inflow = 0.0;
        List<K> sourceKeys = dataset.getSources(stage - 1);
        for (Comparable key : sourceKeys) {
            Number n = dataset.getFlow(stage - 1, key, node);
            if (n == null) continue;
            inflow += n.doubleValue();
        }
        return inflow;
    }

    public static <K extends Comparable<K>> double calculateOutflow(FlowDataset<K> dataset, K source, int stage) {
        Args.nullNotPermitted(dataset, "dataset");
        Args.nullNotPermitted(source, "source");
        Args.requireInRange(stage, "stage", 0, dataset.getStageCount());
        if (stage == dataset.getStageCount()) {
            return 0.0;
        }
        double outflow = 0.0;
        List<K> destinationKeys = dataset.getDestinations(stage);
        for (Comparable key : destinationKeys) {
            Number n = dataset.getFlow(stage, source, key);
            if (n == null) continue;
            outflow += n.doubleValue();
        }
        return outflow;
    }

    public static <K extends Comparable<K>> double calculateTotalFlow(FlowDataset<K> dataset, int stage) {
        Args.nullNotPermitted(dataset, "dataset");
        double total = 0.0;
        for (Comparable source : dataset.getSources(stage)) {
            for (Comparable destination : dataset.getDestinations(stage)) {
                Number flow = dataset.getFlow(stage, source, destination);
                if (flow == null) continue;
                total += flow.doubleValue();
            }
        }
        return total;
    }

    public static <K extends Comparable<K>> boolean hasNodeSelections(FlowDataset<K> dataset) {
        Args.nullNotPermitted(dataset, "dataset");
        for (int stage = 0; stage < dataset.getStageCount() + 1; ++stage) {
            for (Comparable source : dataset.getSources(stage)) {
                NodeKey<Comparable> nodeKey = new NodeKey<Comparable>(stage, source);
                if (!Boolean.TRUE.equals(dataset.getNodeProperty(nodeKey, "selected"))) continue;
                return true;
            }
        }
        return false;
    }

    public static <K extends Comparable<K>> int selectedNodeCount(FlowDataset<K> dataset) {
        Args.nullNotPermitted(dataset, "dataset");
        int result = 0;
        for (int stage = 0; stage < dataset.getStageCount() + 1; ++stage) {
            for (Comparable source : dataset.getSources(stage)) {
                NodeKey<Comparable> nodeKey = new NodeKey<Comparable>(stage, source);
                if (!Boolean.TRUE.equals(dataset.getNodeProperty(nodeKey, "selected"))) continue;
                ++result;
            }
        }
        return result;
    }

    public static <K extends Comparable<K>> boolean hasFlowSelections(FlowDataset<K> dataset) {
        Args.nullNotPermitted(dataset, "dataset");
        for (int s2 = 0; s2 < dataset.getStageCount(); ++s2) {
            for (Comparable source : dataset.getSources(s2)) {
                for (Comparable destination : dataset.getDestinations(s2)) {
                    FlowKey<Comparable> flowKey = new FlowKey<Comparable>(s2, source, destination);
                    if (!Boolean.TRUE.equals(dataset.getFlowProperty(flowKey, "selected"))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

