/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.jexl2.internal.AbstractExecutor;
import org.apache.commons.jexl2.internal.Introspector;
import org.apache.commons.jexl2.internal.PropertyGetExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BooleanGetExecutor
extends AbstractExecutor.Get {
    private final String property;

    public BooleanGetExecutor(Introspector is, Class<?> clazz, String key) {
        super(clazz, BooleanGetExecutor.discover(is, clazz, key));
        this.property = key;
    }

    @Override
    public Object getTargetProperty() {
        return this.property;
    }

    @Override
    public Object execute(Object obj) throws IllegalAccessException, InvocationTargetException {
        return this.method == null ? null : this.method.invoke(obj, (Object[])null);
    }

    @Override
    public Object tryExecute(Object obj, Object key) {
        if (obj != null && this.method != null && this.property.equals(key) && this.objectClass.equals(obj.getClass())) {
            try {
                return this.method.invoke(obj, (Object[])null);
            }
            catch (InvocationTargetException xinvoke) {
                return TRY_FAILED;
            }
            catch (IllegalAccessException xill) {
                return TRY_FAILED;
            }
        }
        return TRY_FAILED;
    }

    static Method discover(Introspector is, Class<?> clazz, String property) {
        Method m3 = PropertyGetExecutor.discoverGet(is, "is", clazz, property);
        return m3 != null && m3.getReturnType() == Boolean.TYPE ? m3 : null;
    }
}

