/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.variant.variantcontext.Genotype;
import java.util.HashMap;

public class IntGenotypeFieldAccessors {
    private final HashMap<String, Accessor> intGenotypeFieldEncoders = new HashMap();

    public IntGenotypeFieldAccessors() {
        this.intGenotypeFieldEncoders.put("DP", new DPAccessor());
        this.intGenotypeFieldEncoders.put("AD", new ADAccessor());
        this.intGenotypeFieldEncoders.put("PL", new PLAccessor());
        this.intGenotypeFieldEncoders.put("GQ", new GQAccessor());
    }

    public Accessor getAccessor(String field) {
        return this.intGenotypeFieldEncoders.get(field);
    }

    public static class PLAccessor
    extends Accessor {
        @Override
        public int[] getValues(Genotype g2) {
            return g2.getPL();
        }
    }

    public static class ADAccessor
    extends Accessor {
        @Override
        public int[] getValues(Genotype g2) {
            return g2.getAD();
        }
    }

    public static class DPAccessor
    extends AtomicAccessor {
        @Override
        public int getValue(Genotype g2) {
            return g2.getDP();
        }
    }

    public static class GQAccessor
    extends AtomicAccessor {
        @Override
        public int getValue(Genotype g2) {
            return Math.min(g2.getGQ(), 99);
        }
    }

    private static abstract class AtomicAccessor
    extends Accessor {
        private final int[] singleton = new int[1];

        private AtomicAccessor() {
        }

        @Override
        public int[] getValues(Genotype g2) {
            this.singleton[0] = this.getValue(g2);
            return this.singleton[0] == -1 ? null : this.singleton;
        }

        public abstract int getValue(Genotype var1);
    }

    public static abstract class Accessor {
        public abstract int[] getValues(Genotype var1);

        public final int getSize(Genotype g2) {
            int[] v = this.getValues(g2);
            return v == null ? 0 : v.length;
        }
    }
}

