/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class GenotypesContext
implements List<Genotype>,
Serializable {
    public static final long serialVersionUID = 1L;
    public static final GenotypesContext NO_GENOTYPES = new GenotypesContext(new ArrayList<Genotype>(0), new HashMap<String, Integer>(0), Collections.emptyList()).immutable();
    protected List<String> sampleNamesInOrder = null;
    protected Map<String, Integer> sampleNameToOffset = null;
    protected ArrayList<Genotype> notToBeDirectlyAccessedGenotypes;
    private int maxPloidy = -1;
    private boolean immutable = false;

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.getClass() == LazyGenotypesContext.class) {
            ((LazyGenotypesContext)this).decode();
        }
        out.defaultWriteObject();
    }

    protected GenotypesContext() {
        this(10);
    }

    protected GenotypesContext(int n) {
        this(new ArrayList<Genotype>(n));
    }

    protected GenotypesContext(ArrayList<Genotype> genotypes) {
        this.notToBeDirectlyAccessedGenotypes = genotypes;
        this.sampleNameToOffset = null;
    }

    protected GenotypesContext(ArrayList<Genotype> genotypes, Map<String, Integer> sampleNameToOffset, List<String> sampleNamesInOrder) {
        this.notToBeDirectlyAccessedGenotypes = genotypes;
        this.sampleNameToOffset = sampleNameToOffset;
        this.sampleNamesInOrder = sampleNamesInOrder;
    }

    public static final GenotypesContext create() {
        return new GenotypesContext();
    }

    public static final GenotypesContext create(int nGenotypes) {
        return new GenotypesContext(nGenotypes);
    }

    public static final GenotypesContext create(ArrayList<Genotype> genotypes, Map<String, Integer> sampleNameToOffset, List<String> sampleNamesInOrder) {
        return new GenotypesContext(genotypes, sampleNameToOffset, sampleNamesInOrder);
    }

    public static final GenotypesContext create(ArrayList<Genotype> genotypes) {
        return genotypes == null ? NO_GENOTYPES : new GenotypesContext(genotypes);
    }

    public static final GenotypesContext create(Genotype ... genotypes) {
        return GenotypesContext.create(new ArrayList<Genotype>(Arrays.asList(genotypes)));
    }

    public static final GenotypesContext copy(GenotypesContext toCopy) {
        return GenotypesContext.create(new ArrayList<Genotype>(toCopy.getGenotypes()));
    }

    public static final GenotypesContext copy(Collection<Genotype> toCopy) {
        return toCopy == null ? NO_GENOTYPES : GenotypesContext.create(new ArrayList<Genotype>(toCopy));
    }

    public final GenotypesContext immutable() {
        this.immutable = true;
        return this;
    }

    public boolean isMutable() {
        return !this.immutable;
    }

    public final void checkImmutability() throws UnsupportedOperationException {
        if (this.immutable) {
            throw new UnsupportedOperationException("GenotypeMap is currently immutable, but a mutator method was invoked on it");
        }
    }

    protected void invalidateSampleNameMap() {
        this.sampleNameToOffset = null;
    }

    protected void invalidateSampleOrdering() {
        this.sampleNamesInOrder = null;
    }

    protected void ensureSampleOrdering() {
        if (this.sampleNamesInOrder == null) {
            this.sampleNamesInOrder = new ArrayList<String>(this.size());
            for (int i = 0; i < this.size(); ++i) {
                this.sampleNamesInOrder.add(this.getGenotypes().get(i).getSampleName());
            }
            Collections.sort(this.sampleNamesInOrder);
        }
    }

    protected void ensureSampleNameMap() {
        if (this.sampleNameToOffset == null) {
            this.sampleNameToOffset = new HashMap<String, Integer>(this.size());
            for (int i = 0; i < this.size(); ++i) {
                this.sampleNameToOffset.put(this.getGenotypes().get(i).getSampleName(), i);
            }
        }
    }

    public boolean isLazyWithData() {
        return this instanceof LazyGenotypesContext && ((LazyGenotypesContext)this).getUnparsedGenotypeData() != null;
    }

    protected ArrayList<Genotype> getGenotypes() {
        return this.notToBeDirectlyAccessedGenotypes;
    }

    @Override
    public void clear() {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        this.getGenotypes().clear();
    }

    @Override
    public int size() {
        return this.getGenotypes().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getGenotypes().isEmpty();
    }

    @Override
    public boolean add(Genotype genotype) throws UnsupportedOperationException {
        this.checkImmutability();
        this.invalidateSampleOrdering();
        if (this.sampleNameToOffset != null) {
            this.sampleNameToOffset.put(genotype.getSampleName(), this.size());
        }
        return this.getGenotypes().add(genotype);
    }

    @Override
    public void add(int i, Genotype genotype) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Genotype> genotypes) {
        this.checkImmutability();
        this.invalidateSampleOrdering();
        if (this.sampleNameToOffset != null) {
            int pos = this.size();
            for (Genotype genotype : genotypes) {
                this.sampleNameToOffset.put(genotype.getSampleName(), pos++);
            }
        }
        return this.getGenotypes().addAll(genotypes);
    }

    @Override
    public boolean addAll(int i, Collection<? extends Genotype> genotypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.getGenotypes().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.getGenotypes().containsAll(objects);
    }

    private boolean containsAny(Collection<? extends Genotype> genotypes) {
        for (Genotype genotype : genotypes) {
            if (!this.contains(genotype)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Genotype get(int i) {
        return this.getGenotypes().get(i);
    }

    public int getMaxPloidy(int defaultPloidy) {
        if (defaultPloidy < 0) {
            throw new IllegalArgumentException("defaultPloidy must be greater than or equal to 0");
        }
        if (this.maxPloidy == -1) {
            this.maxPloidy = 0;
            for (Genotype g2 : this.getGenotypes()) {
                this.maxPloidy = Math.max(g2.getPloidy(), this.maxPloidy);
            }
            if (this.maxPloidy == 0) {
                this.maxPloidy = defaultPloidy;
            }
        }
        return this.maxPloidy;
    }

    public Genotype get(String sampleName) {
        Integer offset = this.getSampleI(sampleName);
        return offset == null ? null : this.getGenotypes().get(offset);
    }

    private Integer getSampleI(String sampleName) {
        this.ensureSampleNameMap();
        return this.sampleNameToOffset.get(sampleName);
    }

    @Override
    public int indexOf(Object o) {
        return this.getGenotypes().indexOf(o);
    }

    @Override
    public Iterator<Genotype> iterator() {
        return this.getGenotypes().iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getGenotypes().lastIndexOf(o);
    }

    @Override
    public ListIterator<Genotype> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Genotype> listIterator(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Genotype remove(int i) {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        return this.getGenotypes().remove(i);
    }

    @Override
    public boolean remove(Object o) {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        return this.getGenotypes().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        return this.getGenotypes().removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        return this.getGenotypes().retainAll(objects);
    }

    @Override
    public Genotype set(int i, Genotype genotype) {
        this.checkImmutability();
        Genotype prev = this.getGenotypes().set(i, genotype);
        this.invalidateSampleOrdering();
        if (this.sampleNameToOffset != null) {
            this.sampleNameToOffset.remove(prev.getSampleName());
            this.sampleNameToOffset.put(genotype.getSampleName(), i);
        }
        return prev;
    }

    public Genotype replace(Genotype genotype) {
        this.checkImmutability();
        Integer offset = this.getSampleI(genotype.getSampleName());
        if (offset == null) {
            return null;
        }
        return this.set((int)offset, genotype);
    }

    @Override
    public List<Genotype> subList(int i, int i1) {
        return this.getGenotypes().subList(i, i1);
    }

    @Override
    public Object[] toArray() {
        return this.getGenotypes().toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.getGenotypes().toArray(ts);
    }

    public Iterable<Genotype> iterateInSampleNameOrder(final Iterable<String> sampleNamesInOrder) {
        return new Iterable<Genotype>(){

            @Override
            public Iterator<Genotype> iterator() {
                return new InOrderIterator(sampleNamesInOrder.iterator());
            }
        };
    }

    public Iterable<Genotype> iterateInSampleNameOrder() {
        return this.iterateInSampleNameOrder(this.getSampleNamesOrderedByName());
    }

    public Set<String> getSampleNames() {
        this.ensureSampleNameMap();
        return this.sampleNameToOffset.keySet();
    }

    public List<String> getSampleNamesOrderedByName() {
        this.ensureSampleOrdering();
        return this.sampleNamesInOrder;
    }

    public boolean containsSample(String sample) {
        this.ensureSampleNameMap();
        return this.sampleNameToOffset.containsKey(sample);
    }

    public boolean containsSamples(Collection<String> samples) {
        return this.getSampleNames().containsAll(samples);
    }

    public GenotypesContext subsetToSamples(Set<String> samples) {
        int nSamples = samples.size();
        if (nSamples == 0) {
            return NO_GENOTYPES;
        }
        GenotypesContext subset = GenotypesContext.create(samples.size());
        for (String sample : samples) {
            Genotype g2 = this.get(sample);
            if (g2 == null) continue;
            subset.add(g2);
        }
        return subset;
    }

    public String toString() {
        ArrayList<String> gS = new ArrayList<String>();
        for (Genotype g2 : this.iterateInSampleNameOrder()) {
            gS.add(g2.toString());
        }
        return "[" + GenotypesContext.join(",", gS) + "]";
    }

    private static <T> String join(String separator, Collection<T> objects) {
        if (objects.isEmpty()) {
            return "";
        }
        Iterator<T> iter = objects.iterator();
        T first = iter.next();
        if (!iter.hasNext()) {
            return first.toString();
        }
        StringBuilder ret = new StringBuilder(first.toString());
        while (iter.hasNext()) {
            ret.append(separator);
            ret.append(iter.next().toString());
        }
        return ret.toString();
    }

    private final class InOrderIterator
    implements Iterator<Genotype> {
        final Iterator<String> sampleNamesInOrder;

        private InOrderIterator(Iterator<String> sampleNamesInOrder) {
            this.sampleNamesInOrder = sampleNamesInOrder;
        }

        @Override
        public boolean hasNext() {
            return this.sampleNamesInOrder.hasNext();
        }

        @Override
        public Genotype next() {
            return GenotypesContext.this.get(this.sampleNamesInOrder.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

