/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.CustomGzipOutputStream;
import htsjdk.samtools.util.FileExtensions;
import htsjdk.samtools.util.IterableOnceIterator;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.nio.DeleteOnExitPathHook;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;

public class IOUtil {
    @Deprecated
    public static final int STANDARD_BUFFER_SIZE = Defaults.NON_ZERO_BUFFER_SIZE;
    public static final long ONE_GB = 0x40000000L;
    public static final long TWO_GBS = 0x80000000L;
    public static final long FIVE_GBS = 0x140000000L;
    @Deprecated
    public static final String VCF_FILE_EXTENSION = ".vcf";
    @Deprecated
    public static final String VCF_INDEX_EXTENSION = ".idx";
    @Deprecated
    public static final String BCF_FILE_EXTENSION = ".bcf";
    @Deprecated
    public static final String COMPRESSED_VCF_FILE_EXTENSION = ".vcf.gz";
    @Deprecated
    public static final String COMPRESSED_VCF_INDEX_EXTENSION = ".tbi";
    @Deprecated
    public static final List<String> VCF_EXTENSIONS_LIST = FileExtensions.VCF_LIST;
    @Deprecated
    public static final String[] VCF_EXTENSIONS = FileExtensions.VCF_LIST.toArray(new String[0]);
    @Deprecated
    public static final String INTERVAL_LIST_FILE_EXTENSION = ".interval_list";
    @Deprecated
    public static final String SAM_FILE_EXTENSION = ".sam";
    @Deprecated
    public static final String DICT_FILE_EXTENSION = ".dict";
    @Deprecated
    public static final Set<String> BLOCK_COMPRESSED_EXTENSIONS = FileExtensions.BLOCK_COMPRESSED;
    public static final int GZIP_HEADER_READ_LENGTH = 8000;
    private static final OpenOption[] EMPTY_OPEN_OPTIONS = new OpenOption[0];
    private static int compressionLevel = Defaults.COMPRESSION_LEVEL;

    public static void setCompressionLevel(int compressionLevel) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + compressionLevel);
        }
        IOUtil.compressionLevel = compressionLevel;
    }

    public static int getCompressionLevel() {
        return compressionLevel;
    }

    public static BufferedInputStream toBufferedStream(InputStream stream) {
        if (stream instanceof BufferedInputStream) {
            return (BufferedInputStream)stream;
        }
        return new BufferedInputStream(stream, Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static void transferByStream(InputStream in, OutputStream out, long bytes) {
        byte[] buffer = new byte[Defaults.NON_ZERO_BUFFER_SIZE];
        try {
            int read;
            for (long remaining = bytes; remaining > 0L; remaining -= (long)read) {
                read = in.read(buffer, 0, (int)Math.min((long)buffer.length, remaining));
                out.write(buffer, 0, read);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    public static OutputStream maybeBufferOutputStream(OutputStream os) {
        return IOUtil.maybeBufferOutputStream(os, Defaults.BUFFER_SIZE);
    }

    public static OutputStream maybeBufferOutputStream(OutputStream os, int bufferSize) {
        if (bufferSize > 0) {
            return new BufferedOutputStream(os, bufferSize);
        }
        return os;
    }

    public static SeekableStream maybeBufferedSeekableStream(SeekableStream stream, int bufferSize) {
        return bufferSize > 0 ? new SeekableBufferedStream(stream, bufferSize) : stream;
    }

    public static SeekableStream maybeBufferedSeekableStream(SeekableStream stream) {
        return IOUtil.maybeBufferedSeekableStream(stream, Defaults.BUFFER_SIZE);
    }

    public static SeekableStream maybeBufferedSeekableStream(File file) {
        try {
            return IOUtil.maybeBufferedSeekableStream(new SeekableFileStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static SeekableStream maybeBufferedSeekableStream(URL url) {
        return IOUtil.maybeBufferedSeekableStream(new SeekableHTTPStream(url));
    }

    public static InputStream maybeBufferInputStream(InputStream is) {
        return IOUtil.maybeBufferInputStream(is, Defaults.BUFFER_SIZE);
    }

    public static InputStream maybeBufferInputStream(InputStream is, int bufferSize) {
        if (bufferSize > 0) {
            return new BufferedInputStream(is, bufferSize);
        }
        return is;
    }

    public static Reader maybeBufferReader(Reader reader, int bufferSize) {
        if (bufferSize > 0) {
            reader = new BufferedReader(reader, bufferSize);
        }
        return reader;
    }

    public static Reader maybeBufferReader(Reader reader) {
        return IOUtil.maybeBufferReader(reader, Defaults.BUFFER_SIZE);
    }

    public static Writer maybeBufferWriter(Writer writer, int bufferSize) {
        if (bufferSize > 0) {
            writer = new BufferedWriter(writer, bufferSize);
        }
        return writer;
    }

    public static Writer maybeBufferWriter(Writer writer) {
        return IOUtil.maybeBufferWriter(writer, Defaults.BUFFER_SIZE);
    }

    public static void deleteFiles(File ... files) {
        for (File f : files) {
            if (f.delete()) continue;
            System.err.println("Could not delete file " + f);
        }
    }

    public static void deleteFiles(Iterable<File> files) {
        for (File f : files) {
            if (f.delete()) continue;
            System.err.println("Could not delete file " + f);
        }
    }

    public static void deletePaths(Path ... paths) {
        for (Path path : paths) {
            IOUtil.deletePath(path);
        }
    }

    public static void deletePaths(Iterable<Path> paths) {
        if (paths instanceof Path) {
            IOUtil.deletePath((Path)paths);
        }
        paths.forEach(IOUtil::deletePath);
    }

    public static void deletePath(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            System.err.println("Could not delete file " + path);
        }
    }

    public static boolean isRegularPath(File file) {
        return !file.exists() || file.isFile();
    }

    public static boolean isRegularPath(Path path) {
        return !Files.exists(path, new LinkOption[0]) || Files.isRegularFile(path, new LinkOption[0]);
    }

    public static File newTempFile(String prefix, String suffix, File[] tmpDirs, long minBytesFree) throws IOException {
        File f = null;
        for (int i = 0; i < tmpDirs.length; ++i) {
            if (i != tmpDirs.length - 1 && tmpDirs[i].getUsableSpace() <= minBytesFree) continue;
            f = File.createTempFile(prefix, suffix, tmpDirs[i]);
            f.deleteOnExit();
            break;
        }
        return f;
    }

    public static File newTempFile(String prefix, String suffix, File[] tmpDirs) throws IOException {
        return IOUtil.newTempFile(prefix, suffix, tmpDirs, 0x140000000L);
    }

    public static File getDefaultTmpDir() {
        String user = System.getProperty("user.name");
        String tmp = System.getProperty("java.io.tmpdir");
        if (tmp.endsWith(File.separatorChar + user)) {
            return new File(tmp);
        }
        return new File(tmp, user);
    }

    public static Path newTempPath(String prefix, String suffix, Path[] tmpDirs, long minBytesFree) throws IOException {
        Path p = null;
        for (int i = 0; i < tmpDirs.length; ++i) {
            if (i != tmpDirs.length - 1 && Files.getFileStore(tmpDirs[i]).getUsableSpace() <= minBytesFree) continue;
            p = Files.createTempFile(tmpDirs[i], prefix, suffix, new FileAttribute[0]);
            IOUtil.deleteOnExit(p);
            break;
        }
        return p;
    }

    public static Path newTempPath(String prefix, String suffix, Path[] tmpDirs) throws IOException {
        return IOUtil.newTempPath(prefix, suffix, tmpDirs, 0x140000000L);
    }

    public static Path getDefaultTmpDirPath() {
        try {
            String user = System.getProperty("user.name");
            String tmp = System.getProperty("java.io.tmpdir");
            Path tmpParent = IOUtil.getPath(tmp);
            if (tmpParent.endsWith(tmpParent.getFileSystem().getSeparator() + user)) {
                return tmpParent;
            }
            return tmpParent.resolve(user);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void deleteOnExit(Path path) {
        DeleteOnExitPathHook.add(path);
    }

    public static String basename(File f) {
        String full = f.getName();
        int index = full.lastIndexOf(46);
        if (index > 0 && index > full.lastIndexOf(File.separator)) {
            return full.substring(0, index);
        }
        return full;
    }

    public static void assertInputIsValid(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Cannot check validity of null input.");
        }
        if (!IOUtil.isUrl(input)) {
            IOUtil.assertFileIsReadable(new File(input));
        }
    }

    public static boolean isUrl(String input) {
        try {
            new URL(input);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static void assertFileIsReadable(File file) {
        IOUtil.assertFileIsReadable(IOUtil.toPath(file));
    }

    public static void assertFileIsReadable(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new SAMException("Cannot read non-existent file: " + path.toUri().toString());
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new SAMException("Cannot read file because it is a directory: " + path.toUri().toString());
        }
        if (!Files.isReadable(path)) {
            throw new SAMException("File exists but is not readable: " + path.toUri().toString());
        }
    }

    public static void assertFilesAreReadable(List<File> files) {
        for (File file : files) {
            IOUtil.assertFileIsReadable(file);
        }
    }

    public static void assertPathsAreReadable(List<Path> paths) {
        for (Path path : paths) {
            IOUtil.assertFileIsReadable(path);
        }
    }

    public static void assertInputsAreValid(List<String> inputs) {
        for (String input : inputs) {
            IOUtil.assertInputIsValid(input);
        }
    }

    public static void assertFileIsWritable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!file.exists()) {
            File parent = file.getAbsoluteFile().getParentFile();
            if (!parent.exists()) {
                throw new SAMException("Cannot write file: " + file.getAbsolutePath() + ". Neither file nor parent directory exist.");
            }
            if (!parent.isDirectory()) {
                throw new SAMException("Cannot write file: " + file.getAbsolutePath() + ". File does not exist and parent is not a directory.");
            }
            if (!parent.canWrite()) {
                throw new SAMException("Cannot write file: " + file.getAbsolutePath() + ". File does not exist and parent directory is not writable..");
            }
        } else {
            if (file.isDirectory()) {
                throw new SAMException("Cannot write file because it is a directory: " + file.getAbsolutePath());
            }
            if (!file.canWrite()) {
                throw new SAMException("File exists but is not writable: " + file.getAbsolutePath());
            }
        }
    }

    public static void assertFilesAreWritable(List<File> files) {
        for (File file : files) {
            IOUtil.assertFileIsWritable(file);
        }
    }

    public static void assertDirectoryIsWritable(File dir) {
        Path asPath = IOUtil.toPath(dir);
        IOUtil.assertDirectoryIsWritable(asPath);
    }

    public static void assertDirectoryIsWritable(Path dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!Files.exists(dir, new LinkOption[0])) {
            throw new SAMException("Directory does not exist: " + dir.toUri().toString());
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new SAMException("Cannot write to directory because it is not a directory: " + dir.toUri().toString());
        }
        if (!Files.isWritable(dir)) {
            throw new SAMException("Directory exists but is not writable: " + dir.toUri().toString());
        }
    }

    public static void assertDirectoryIsReadable(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!dir.exists()) {
            throw new SAMException("Directory does not exist: " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new SAMException("Cannot read from directory because it is not a directory: " + dir.getAbsolutePath());
        }
        if (!dir.canRead()) {
            throw new SAMException("Directory exists but is not readable: " + dir.getAbsolutePath());
        }
    }

    public static void assertFilesEqual(File f1, File f2) {
        if (f1.length() != f2.length()) {
            throw new SAMException("File " + f1 + " is " + f1.length() + " bytes but file " + f2 + " is " + f2.length() + " bytes.");
        }
        try (FileInputStream s1 = new FileInputStream(f1);
             FileInputStream s2 = new FileInputStream(f2);){
            int len1;
            byte[] buf1 = new byte[0x100000];
            byte[] buf2 = new byte[0x100000];
            while ((len1 = s1.read(buf1)) != -1) {
                int len2 = s2.read(buf2);
                if (len1 != len2) {
                    throw new SAMException("Unexpected EOF comparing files that are supposed to be the same length.");
                }
                if (Arrays.equals(buf1, buf2)) continue;
                throw new SAMException("Files " + f1 + " and " + f2 + " differ.");
            }
        }
        catch (IOException e) {
            throw new SAMException("Exception comparing files " + f1 + " and " + f2, e);
        }
    }

    public static void assertFileSizeNonZero(File file) {
        if (file.length() == 0L) {
            throw new SAMException(file.getAbsolutePath() + " has length 0");
        }
    }

    public static InputStream openFileForReading(File file) {
        return IOUtil.openFileForReading(IOUtil.toPath(file));
    }

    public static InputStream openFileForReading(Path path) {
        try {
            if (IOUtil.hasGzipFileExtension(path)) {
                return IOUtil.openGzipFileForReading(path);
            }
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException ioe) {
            throw new SAMException("Error opening file: " + path, ioe);
        }
    }

    public static InputStream openGzipFileForReading(File file) {
        return IOUtil.openGzipFileForReading(IOUtil.toPath(file));
    }

    public static InputStream openGzipFileForReading(Path path) {
        try {
            return new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException ioe) {
            throw new SAMException("Error opening file: " + path, ioe);
        }
    }

    public static OutputStream openFileForWriting(File file) {
        return IOUtil.openFileForWriting(IOUtil.toPath(file), new OpenOption[0]);
    }

    public static OutputStream openFileForWriting(File file, boolean append) {
        return IOUtil.openFileForWriting(IOUtil.toPath(file), IOUtil.getAppendOpenOption(append));
    }

    public static OutputStream openFileForWriting(Path path, OpenOption ... openOptions) {
        try {
            if (IOUtil.hasGzipFileExtension(path)) {
                return IOUtil.openGzipFileForWriting(path, openOptions);
            }
            return Files.newOutputStream(path, openOptions);
        }
        catch (IOException ioe) {
            throw new SAMException("Error opening file for writing: " + path.toUri().toString(), ioe);
        }
    }

    public static boolean hasGzipFileExtension(Path path) {
        List<String> gzippedEndings = Arrays.asList(".gz", ".gzip", ".bfq");
        String fileName = path.getFileName().toString();
        return gzippedEndings.stream().anyMatch(fileName::endsWith);
    }

    public static BufferedWriter openFileForBufferedWriting(File file, boolean append) {
        return new BufferedWriter(new OutputStreamWriter(IOUtil.openFileForWriting(file, append)), Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static BufferedWriter openFileForBufferedWriting(Path path, OpenOption ... openOptions) {
        return new BufferedWriter(new OutputStreamWriter(IOUtil.openFileForWriting(path, openOptions)), Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static BufferedWriter openFileForBufferedWriting(File file) {
        return IOUtil.openFileForBufferedWriting(IOUtil.toPath(file), new OpenOption[0]);
    }

    public static BufferedWriter openFileForBufferedUtf8Writing(File file) {
        return IOUtil.openFileForBufferedUtf8Writing(IOUtil.toPath(file));
    }

    public static BufferedWriter openFileForBufferedUtf8Writing(Path path) {
        return new BufferedWriter(new OutputStreamWriter(IOUtil.openFileForWriting(path, new OpenOption[0]), Charset.forName("UTF-8")), Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static BufferedReader openFileForBufferedUtf8Reading(File file) {
        return new BufferedReader(new InputStreamReader(IOUtil.openFileForReading(file), Charset.forName("UTF-8")));
    }

    public static OutputStream openGzipFileForWriting(File file, boolean append) {
        return IOUtil.openGzipFileForWriting(IOUtil.toPath(file), IOUtil.getAppendOpenOption(append));
    }

    private static OpenOption[] getAppendOpenOption(boolean append) {
        OpenOption[] openOptionArray;
        if (append) {
            OpenOption[] openOptionArray2 = new OpenOption[1];
            openOptionArray = openOptionArray2;
            openOptionArray2[0] = StandardOpenOption.APPEND;
        } else {
            openOptionArray = EMPTY_OPEN_OPTIONS;
        }
        return openOptionArray;
    }

    public static OutputStream openGzipFileForWriting(Path path, OpenOption ... openOptions) {
        try {
            OutputStream out = Files.newOutputStream(path, openOptions);
            if (Defaults.BUFFER_SIZE > 0) {
                return new CustomGzipOutputStream(out, Defaults.BUFFER_SIZE, compressionLevel);
            }
            return new CustomGzipOutputStream(out, compressionLevel);
        }
        catch (IOException ioe) {
            throw new SAMException("Error opening file for writing: " + path.toUri().toString(), ioe);
        }
    }

    public static OutputStream openFileForMd5CalculatingWriting(File file) {
        return IOUtil.openFileForMd5CalculatingWriting(IOUtil.toPath(file));
    }

    public static OutputStream openFileForMd5CalculatingWriting(Path file) {
        return new Md5CalculatingOutputStream(IOUtil.openFileForWriting(file, new OpenOption[0]), file.resolve(".md5"));
    }

    public static void copyStream(InputStream input, OutputStream output) {
        try {
            byte[] buffer = new byte[Defaults.NON_ZERO_BUFFER_SIZE];
            int bytesRead = 0;
            while ((bytesRead = input.read(buffer)) > 0) {
                output.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new SAMException("Exception copying stream", e);
        }
    }

    public static void copyFile(File input, File output) {
        try {
            FileInputStream is = new FileInputStream(input);
            FileOutputStream os = new FileOutputStream(output);
            IOUtil.copyStream(is, os);
            ((OutputStream)os).close();
            ((InputStream)is).close();
        }
        catch (IOException e) {
            throw new SAMException("Error copying " + input + " to " + output, e);
        }
    }

    public static File[] getFilesMatchingRegexp(File directory, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        return IOUtil.getFilesMatchingRegexp(directory, pattern);
    }

    public static File[] getFilesMatchingRegexp(File directory, final Pattern regexp) {
        return directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return regexp.matcher(name).matches();
            }
        });
    }

    public static boolean deleteDirectoryTree(File fileOrDirectory) {
        boolean success = true;
        if (fileOrDirectory.isDirectory()) {
            for (File child : fileOrDirectory.listFiles()) {
                success = success && IOUtil.deleteDirectoryTree(child);
            }
        }
        success = success && fileOrDirectory.delete();
        return success;
    }

    public static long sizeOfTree(File fileOrDirectory) {
        long total = fileOrDirectory.length();
        if (fileOrDirectory.isDirectory()) {
            for (File f : fileOrDirectory.listFiles()) {
                total += IOUtil.sizeOfTree(f);
            }
        }
        return total;
    }

    public static void copyDirectoryTree(File fileOrDirectory, File destination) {
        if (fileOrDirectory.isDirectory()) {
            destination.mkdir();
            for (File f : fileOrDirectory.listFiles()) {
                File destinationFileOrDirectory = new File(destination.getPath(), f.getName());
                if (f.isDirectory()) {
                    IOUtil.copyDirectoryTree(f, destinationFileOrDirectory);
                    continue;
                }
                IOUtil.copyFile(f, destinationFileOrDirectory);
            }
        }
    }

    public static File createTempDir(String prefix, String suffix) {
        try {
            File tmp = File.createTempFile(prefix, suffix);
            if (!tmp.delete()) {
                throw new SAMException("Could not delete temporary file " + tmp);
            }
            if (!tmp.mkdir()) {
                throw new SAMException("Could not create temporary directory " + tmp);
            }
            return tmp;
        }
        catch (IOException e) {
            throw new SAMException("Exception creating temporary directory.", e);
        }
    }

    public static BufferedReader openFileForBufferedReading(File file) {
        return IOUtil.openFileForBufferedReading(IOUtil.toPath(file));
    }

    public static BufferedReader openFileForBufferedReading(Path path) {
        return new BufferedReader(new InputStreamReader(IOUtil.openFileForReading(path)), Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static String makeFileNameSafe(String str) {
        return str.trim().replaceAll("[\\s!\"#$%&'()*/:;<=>?@\\[\\]\\\\^`{|}~]", "_");
    }

    public static String fileSuffix(File f) {
        String full = f.getName();
        int index = full.lastIndexOf(46);
        if (index > 0 && index > full.lastIndexOf(File.separator)) {
            return full.substring(index);
        }
        return null;
    }

    public static String getFullCanonicalPath(File file) {
        try {
            File f = file.getCanonicalFile();
            String canonicalPath = "";
            while (f != null && !f.getName().equals("")) {
                canonicalPath = "/" + f.getName() + canonicalPath;
                if ((f = f.getParentFile()) == null) continue;
                f = f.getCanonicalFile();
            }
            return canonicalPath;
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error getting full canonical path for " + file + ": " + ioe.getMessage(), ioe);
        }
    }

    public static String readFully(InputStream in) {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in), Defaults.NON_ZERO_BUFFER_SIZE);
            StringBuilder builder = new StringBuilder(512);
            String line = null;
            while ((line = r.readLine()) != null) {
                if (builder.length() > 0) {
                    builder.append('\n');
                }
                builder.append(line);
            }
            return builder.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error reading stream", ioe);
        }
    }

    public static IterableOnceIterator<String> readLines(File f) {
        try {
            final BufferedReader in = IOUtil.openFileForBufferedReading(f);
            return new IterableOnceIterator<String>(){
                private String next;
                {
                    this.next = in.readLine();
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public String next() {
                    try {
                        String tmp = this.next;
                        this.next = in.readLine();
                        if (this.next == null) {
                            in.close();
                        }
                        return tmp;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeIOException(ioe);
                    }
                }

                @Override
                public void close() throws IOException {
                    CloserUtil.close(in);
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static List<String> slurpLines(File file) throws FileNotFoundException {
        return IOUtil.slurpLines(new FileInputStream(file));
    }

    public static List<String> slurpLines(InputStream is) throws FileNotFoundException {
        return IOUtil.tokenSlurp(is, Charset.defaultCharset(), "\r\n|[\n\r\u2028\u2029\u0085]");
    }

    public static String slurp(File file) throws FileNotFoundException {
        return IOUtil.slurp(new FileInputStream(file));
    }

    public static String slurp(InputStream is) {
        return IOUtil.slurp(is, Charset.defaultCharset());
    }

    public static String slurp(InputStream is, Charset charSet) {
        List<String> tokenOrEmpty = IOUtil.tokenSlurp(is, charSet, "\\A");
        return tokenOrEmpty.isEmpty() ? "" : CollectionUtil.getSoleElement(tokenOrEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> tokenSlurp(InputStream is, Charset charSet, String delimiterPattern) {
        try {
            Scanner s2 = new Scanner(is, charSet.toString()).useDelimiter(delimiterPattern);
            LinkedList<String> tokens = new LinkedList<String>();
            while (s2.hasNext()) {
                tokens.add(s2.next());
            }
            LinkedList<String> linkedList = tokens;
            return linkedList;
        }
        finally {
            CloserUtil.close(is);
        }
    }

    public static List<File> unrollFiles(Collection<File> inputs, String ... extensions) {
        List<Path> paths = IOUtil.unrollPaths(IOUtil.filesToPaths(inputs), extensions);
        return paths.stream().map(Path::toFile).collect(Collectors.toList());
    }

    public static List<Path> unrollPaths(Collection<Path> inputs, String ... extensions) {
        if (extensions.length < 1) {
            throw new IllegalArgumentException("Must provide at least one extension.");
        }
        Stack<Path> stack = new Stack<Path>();
        ArrayList<Path> output = new ArrayList<Path>();
        stack.addAll(inputs);
        while (!stack.empty()) {
            Path p = (Path)stack.pop();
            String name = p.toString();
            boolean matched = false;
            for (String ext : extensions) {
                if (matched || !name.endsWith(ext)) continue;
                output.add(p);
                matched = true;
            }
            if (matched) continue;
            try {
                Files.lines(p).map(String::trim).filter(s2 -> !s2.isEmpty()).forEach(s2 -> {
                    try {
                        Path innerPath = IOUtil.getPath(s2);
                        stack.push(innerPath);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("cannot convert " + s2 + " to a Path.", e);
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalArgumentException("had trouble reading from " + p.toUri().toString(), e);
            }
        }
        Collections.reverse(output);
        return output;
    }

    public static boolean hasScheme(String uriString) {
        try {
            return new URI(uriString).getScheme() != null;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static Path getPath(String uriString) throws IOException {
        URI uri = URI.create(uriString);
        try {
            return uri.getScheme() == null ? Paths.get(uriString, new String[0]) : Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                throw e;
            }
            return FileSystems.newFileSystem(uri, new HashMap(), cl).provider().getPath(uri);
        }
    }

    public static List<Path> getPaths(List<String> uriStrings) throws RuntimeIOException {
        return uriStrings.stream().map(s2 -> {
            try {
                return IOUtil.getPath(s2);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }).collect(Collectors.toList());
    }

    public static Path toPath(File fileOrNull) {
        return null == fileOrNull ? null : fileOrNull.toPath();
    }

    public static List<Path> filesToPaths(Collection<File> files) {
        return files.stream().map(File::toPath).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGZIPInputStream(InputStream stream) {
        if (!stream.markSupported()) {
            throw new IllegalArgumentException("isGZIPInputStream() : Cannot test a stream that doesn't support marking.");
        }
        stream.mark(8000);
        try {
            GZIPInputStream gunzip = new GZIPInputStream(stream);
            int ch = gunzip.read();
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                stream.reset();
            }
            catch (IOException ioe) {
                throw new IllegalStateException("isGZIPInputStream(): Could not reset stream.");
            }
        }
    }

    public static Path addExtension(Path path, String extension) {
        return path.resolveSibling(path.getFileName() + extension);
    }

    public static boolean isBlockCompressed(Path path, boolean checkExtension) throws IOException {
        if (checkExtension && !IOUtil.hasBlockCompressedExtension(path)) {
            return false;
        }
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]), Math.max(Defaults.BUFFER_SIZE, 65536));){
            boolean bl = BlockCompressedInputStream.isValidFile(stream);
            return bl;
        }
    }

    public static boolean isBlockCompressed(Path path) throws IOException {
        return IOUtil.isBlockCompressed(path, false);
    }

    public static boolean hasBlockCompressedExtension(String fileName) {
        String cleanedPath = IOUtil.stripQueryStringIfPathIsAnHttpUrl(fileName);
        for (String extension : FileExtensions.BLOCK_COMPRESSED) {
            if (!cleanedPath.toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBlockCompressedExtension(Path path) {
        return IOUtil.hasBlockCompressedExtension(path.getFileName().toString());
    }

    public static boolean hasBlockCompressedExtension(File file) {
        return IOUtil.hasBlockCompressedExtension(file.getName());
    }

    public static boolean hasBlockCompressedExtension(URI uri) {
        String path = uri.getPath();
        return IOUtil.hasBlockCompressedExtension(path);
    }

    private static String stripQueryStringIfPathIsAnHttpUrl(String path) {
        int qIdx;
        if ((path.startsWith("http://") || path.startsWith("https://")) && (qIdx = path.indexOf(63)) > 0) {
            return path.substring(0, qIdx);
        }
        return path;
    }

    public static void recursiveDelete(Path directory) {
        SimpleFileVisitor<Path> simpleFileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                super.visitFile(file, attrs);
                Files.deleteIfExists(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                super.postVisitDirectory(dir, exc);
                Files.deleteIfExists(dir);
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)simpleFileVisitor);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

