/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.Iso8601Date;
import java.io.File;
import java.math.RoundingMode;
import java.security.InvalidParameterException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FormatUtil {
    public static final int DECIMAL_DIGITS_TO_PRINT = 6;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final NumberFormat integerFormat = NumberFormat.getIntegerInstance();
    private final NumberFormat floatFormat;

    public FormatUtil() {
        this.integerFormat.setGroupingUsed(false);
        this.floatFormat = NumberFormat.getNumberInstance();
        this.floatFormat.setGroupingUsed(false);
        this.floatFormat.setMaximumFractionDigits(6);
        this.floatFormat.setRoundingMode(RoundingMode.HALF_DOWN);
        if (this.floatFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)this.floatFormat;
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setNaN("?");
            decimalFormatSymbols.setInfinity("?");
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }

    public String format(short value) {
        return this.integerFormat.format(value);
    }

    public String format(int value) {
        return this.integerFormat.format(value);
    }

    public String format(long value) {
        return this.integerFormat.format(value);
    }

    public String format(float value) {
        return this.floatFormat.format(value);
    }

    public String format(double value) {
        return this.floatFormat.format(value);
    }

    public String format(char value) {
        return Character.toString(value);
    }

    public String format(Enum value) {
        return value.name();
    }

    public String format(Date value) {
        return this.dateFormat.format(value);
    }

    public String format(Iso8601Date value) {
        return value.toString();
    }

    public String format(boolean value) {
        if (value) {
            return "Y";
        }
        return "N";
    }

    public String format(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Short) {
            return this.format((Short)value);
        }
        if (value instanceof Integer) {
            return this.format((Integer)value);
        }
        if (value instanceof Long) {
            return this.format((Long)value);
        }
        if (value instanceof Float) {
            return this.format(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return this.format((Double)value);
        }
        if (value instanceof Enum) {
            return this.format((Enum)value);
        }
        if (value instanceof Iso8601Date) {
            return this.format((Iso8601Date)value);
        }
        if (value instanceof Date) {
            return this.format((Date)value);
        }
        if (value instanceof Boolean) {
            return this.format((Boolean)value);
        }
        if (value instanceof Character) {
            return this.format(((Character)value).charValue());
        }
        return value.toString();
    }

    public short parseShort(String value) {
        return Short.parseShort(value);
    }

    public int parseInt(String value) {
        return Integer.parseInt(value);
    }

    public long parseLong(String value) {
        return Long.parseLong(value);
    }

    public float parseFloat(String value) {
        if ("?".equals(value) || "-?".equals(value)) {
            return Float.NaN;
        }
        return Float.parseFloat(value);
    }

    public double parseDouble(String value) {
        if ("?".equals(value) || "-?".equals(value)) {
            return Double.NaN;
        }
        return Double.parseDouble(value);
    }

    public <E extends Enum> E parseEnum(String value, Class<E> type) {
        return Enum.valueOf(type, value);
    }

    public Date parseDate(String value) {
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException pe) {
            throw new SAMException("Could not parse value as date: " + value, pe);
        }
    }

    public Iso8601Date parseIso8601Date(String value) {
        return new Iso8601Date(value);
    }

    public boolean parseBoolean(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        char ch = Character.toUpperCase(value.charAt(0));
        return ch == 'Y';
    }

    public char parseChar(String value) {
        if (value == null) {
            throw new SAMException("Cannot parse null string into char");
        }
        if (value.length() != 1) {
            throw new SAMException("Cannot parse string into char because length != 1 : " + value);
        }
        return value.charAt(0);
    }

    public Object parseObject(String value, Class<?> returnType2) {
        if (returnType2 == Short.class || returnType2 == Short.TYPE) {
            return this.parseShort(value);
        }
        if (returnType2 == Integer.class || returnType2 == Integer.TYPE) {
            return this.parseInt(value);
        }
        if (returnType2 == Long.class || returnType2 == Long.TYPE) {
            return this.parseLong(value);
        }
        if (returnType2 == Float.class || returnType2 == Float.TYPE) {
            return Float.valueOf(this.parseFloat(value));
        }
        if (returnType2 == Double.class || returnType2 == Double.TYPE) {
            return this.parseDouble(value);
        }
        if (returnType2 == Boolean.class || returnType2 == Boolean.TYPE) {
            return this.parseBoolean(value);
        }
        if (returnType2 == Byte.class || returnType2 == Byte.TYPE) {
            return this.parseInt(value);
        }
        if (returnType2 == Character.class || returnType2 == Character.TYPE) {
            return Character.valueOf(this.parseChar(value));
        }
        if (returnType2 == Iso8601Date.class) {
            return this.parseIso8601Date(value);
        }
        if (returnType2 == Date.class) {
            return this.parseDate(value);
        }
        if (returnType2 == File.class) {
            return new File(value);
        }
        if (Enum.class.isAssignableFrom(returnType2)) {
            return this.parseEnum(value, returnType2);
        }
        if (returnType2 == String.class) {
            return value;
        }
        throw new InvalidParameterException("Don't know how to convert a String to a " + returnType2.getName());
    }
}

