/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core.huffmanUtils;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.core.huffmanUtils.HuffmanBitCode;
import htsjdk.samtools.cram.encoding.core.huffmanUtils.HuffmanLeaf;
import htsjdk.samtools.cram.encoding.core.huffmanUtils.HuffmanNode;
import htsjdk.samtools.cram.encoding.core.huffmanUtils.HuffmanParams;
import htsjdk.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

abstract class HuffmanTree<T>
implements Comparable<HuffmanTree<T>> {
    public final int frequency;

    protected HuffmanTree(int freq) {
        this.frequency = freq;
    }

    public static <T> HuffmanTree<T> buildTree(HashMap<T, MutableInt> symbolFrequencies) {
        ValidationUtils.nonNull(symbolFrequencies, "non-null symbol frequencies required");
        ValidationUtils.nonNull(Boolean.valueOf(symbolFrequencies.size() > 0), "non-zero symbol frequencies required");
        LinkedList list = new LinkedList();
        symbolFrequencies.forEach((s2, f) -> list.add(new HuffmanLeaf<Object>(s2, f.value)));
        while (list.size() > 1) {
            Collections.sort(list);
            HuffmanTree left = (HuffmanTree)list.remove();
            HuffmanTree right = (HuffmanTree)list.remove();
            list.add(new HuffmanNode(left, right));
        }
        return list.isEmpty() ? null : (HuffmanTree)list.remove();
    }

    public HuffmanParams<T> getHuffmanParams() {
        TreeMap codeWords = new TreeMap();
        this.getCodeWords(0, 0, codeWords);
        ArrayList symbols = new ArrayList();
        ArrayList<Integer> codeWordLengths = new ArrayList<Integer>();
        for (Object symbol : codeWords.keySet()) {
            HuffmanBitCode code = (HuffmanBitCode)codeWords.get(symbol);
            symbols.add(symbol);
            codeWordLengths.add(code.getCodeWordBitLength());
        }
        return new HuffmanParams(symbols, codeWordLengths);
    }

    public abstract void getCodeWords(int var1, int var2, Map<T, HuffmanBitCode<T>> var3);

    @Override
    public int compareTo(HuffmanTree tree) {
        return this.frequency - tree.frequency;
    }
}

