/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core.experimental;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.core.experimental.ExperimentalEncoding;
import htsjdk.samtools.cram.encoding.core.experimental.GolombLongCodec;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.SliceBlocksReadStreams;
import htsjdk.samtools.cram.structure.SliceBlocksWriteStreams;
import java.nio.ByteBuffer;

public final class GolombLongEncoding
extends ExperimentalEncoding<Long> {
    private final int offset;
    private final int m;

    public GolombLongEncoding(int offset, int m3) {
        super(EncodingID.GOLOMB);
        this.offset = offset;
        this.m = m3;
    }

    public static GolombLongEncoding fromSerializedEncodingParams(byte[] serializedParams) {
        ByteBuffer buffer = ByteBuffer.wrap(serializedParams);
        int offset = ITF8.readUnsignedITF8(buffer);
        int m3 = ITF8.readUnsignedITF8(buffer);
        return new GolombLongEncoding(offset, m3);
    }

    @Override
    public byte[] toSerializedEncodingParams() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(this.offset, buffer);
        ITF8.writeUnsignedITF8(this.m, buffer);
        buffer.flip();
        byte[] array = new byte[buffer.limit()];
        buffer.get(array);
        return array;
    }

    @Override
    public CRAMCodec<Long> buildCodec(SliceBlocksReadStreams sliceBlocksReadStreams, SliceBlocksWriteStreams sliceBlocksWriteStreams) {
        return new GolombLongCodec(sliceBlocksReadStreams == null ? null : sliceBlocksReadStreams.getCoreBlockInputStream(), sliceBlocksWriteStreams == null ? null : sliceBlocksWriteStreams.getCoreOutputStream(), this.offset, this.m);
    }

    public String toString() {
        return String.format("Offset: %d m: %d", this.offset, this.m);
    }
}

