/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.io.bundle;

import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.io.bundle.IOPathResource;
import htsjdk.io.HtsPath;
import htsjdk.io.IOPath;
import htsjdk.samtools.util.Log;
import htsjdk.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import mjson.Json;

public class BundleJSON {
    public static final String BUNDLE_EXTENSION = ".json";
    private static final Log LOG = Log.getInstance(BundleJSON.class);
    public static final String JSON_PROPERTY_SCHEMA_NAME = "schemaName";
    public static final String JSON_PROPERTY_SCHEMA_VERSION = "schemaVersion";
    public static final String JSON_PROPERTY_PRIMARY = "primary";
    public static final String JSON_PROPERTY_PATH = "path";
    public static final String JSON_PROPERTY_FORMAT = "format";
    public static final String JSON_SCHEMA_NAME = "htsbundle";
    public static final String JSON_SCHEMA_VERSION = "0.1.0";
    private static final Set<String> TOP_LEVEL_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(BundleJSON.JSON_PROPERTY_SCHEMA_NAME);
            this.add(BundleJSON.JSON_PROPERTY_SCHEMA_VERSION);
            this.add(BundleJSON.JSON_PROPERTY_PRIMARY);
        }
    });

    public static String toJSON(Bundle bundle) {
        Json outerJSON = Json.object().set(JSON_PROPERTY_SCHEMA_NAME, (Object)JSON_SCHEMA_NAME).set(JSON_PROPERTY_SCHEMA_VERSION, (Object)JSON_SCHEMA_VERSION).set(JSON_PROPERTY_PRIMARY, (Object)bundle.getPrimaryContentType());
        bundle.forEach(bundleResource -> {
            Optional<IOPath> resourcePath = bundleResource.getIOPath();
            if (!resourcePath.isPresent()) {
                throw new IllegalArgumentException("Bundle resource requires a valid path to be serialized");
            }
            Json resourceJSON = Json.object().set(JSON_PROPERTY_PATH, (Object)resourcePath.get().getURIString());
            if (bundleResource.getFileFormat().isPresent()) {
                resourceJSON.set(JSON_PROPERTY_FORMAT, (Object)bundleResource.getFileFormat().get());
            }
            outerJSON.set(bundleResource.getContentType(), resourceJSON);
        });
        return BundleJSON.prettyPrintJSON(outerJSON);
    }

    public static Bundle toBundle(String jsonString) {
        return BundleJSON.toBundle(ValidationUtils.nonEmpty(jsonString, "resource list"), HtsPath::new);
    }

    public static <T extends IOPath> Bundle toBundle(String jsonString, Function<String, T> ioPathConstructor) {
        String primaryContentType;
        ValidationUtils.nonEmpty(jsonString, "JSON string");
        ValidationUtils.nonNull(ioPathConstructor, "IOPath-derived class constructor");
        ArrayList<BundleResource> resources = new ArrayList<BundleResource>();
        try {
            Json jsonDocument = Json.read(jsonString);
            if (jsonDocument == null || jsonString.length() < 1) {
                throw new IllegalArgumentException(String.format("JSON file parsing failed %s", jsonString));
            }
            String schemaName = BundleJSON.getPropertyAsString(JSON_PROPERTY_SCHEMA_NAME, jsonDocument);
            if (!schemaName.equals(JSON_SCHEMA_NAME)) {
                throw new IllegalArgumentException(String.format("Expected bundle schema name %s but found %s", JSON_SCHEMA_NAME, schemaName));
            }
            String schemaVersion = BundleJSON.getPropertyAsString(JSON_PROPERTY_SCHEMA_VERSION, jsonDocument);
            if (!schemaVersion.equals(JSON_SCHEMA_VERSION)) {
                throw new IllegalArgumentException(String.format("Expected bundle schema version %s but found %s", JSON_SCHEMA_VERSION, schemaVersion));
            }
            primaryContentType = BundleJSON.getPropertyAsString(JSON_PROPERTY_PRIMARY, jsonDocument);
            jsonDocument.asJsonMap().forEach((contentType, jsonDoc) -> {
                if (!TOP_LEVEL_PROPERTIES.contains(contentType)) {
                    Json format = jsonDoc.at(JSON_PROPERTY_FORMAT);
                    IOPathResource ioPathResource = new IOPathResource((IOPath)ioPathConstructor.apply(BundleJSON.getPropertyAsString(JSON_PROPERTY_PATH, jsonDoc)), (String)contentType, format == null ? null : BundleJSON.getPropertyAsString(JSON_PROPERTY_FORMAT, jsonDoc));
                    resources.add(ioPathResource);
                }
            });
            if (resources.isEmpty()) {
                LOG.warn("Empty resource bundle found: ", jsonString);
            }
        }
        catch (UnsupportedOperationException | Json.MalformedJsonException e) {
            throw new IllegalArgumentException(e);
        }
        return new Bundle(primaryContentType, resources);
    }

    private static String prettyPrintJSON(Json jsonDocument) {
        StringBuilder sb = new StringBuilder();
        String TOP_LEVEL_PROPERTY_FORMAT = "  \"%s\":\"%s\"";
        try {
            sb.append("{\n");
            String schemaName = BundleJSON.getPropertyAsString(JSON_PROPERTY_SCHEMA_NAME, jsonDocument);
            sb.append(String.format("  \"%s\":\"%s\"", JSON_PROPERTY_SCHEMA_NAME, schemaName));
            sb.append(",\n");
            String schemaVersion = BundleJSON.getPropertyAsString(JSON_PROPERTY_SCHEMA_VERSION, jsonDocument);
            sb.append(String.format("  \"%s\":\"%s\"", JSON_PROPERTY_SCHEMA_VERSION, schemaVersion));
            sb.append(",\n");
            String primary = BundleJSON.getPropertyAsString(JSON_PROPERTY_PRIMARY, jsonDocument);
            sb.append(String.format("  \"%s\":\"%s\"", JSON_PROPERTY_PRIMARY, primary));
            sb.append(",\n");
            ArrayList formattedResources = new ArrayList();
            jsonDocument.asJsonMap().forEach((contentType, jsonDoc) -> {
                if (!TOP_LEVEL_PROPERTIES.contains(contentType)) {
                    Json format = jsonDoc.at(JSON_PROPERTY_FORMAT);
                    StringBuilder resSB = new StringBuilder();
                    if (format != null) {
                        resSB.append(String.format("{\"%s\":\"%s\",\"%s\":\"%s\"}", JSON_PROPERTY_PATH, BundleJSON.getPropertyAsString(JSON_PROPERTY_PATH, jsonDoc), JSON_PROPERTY_FORMAT, BundleJSON.getPropertyAsString(JSON_PROPERTY_FORMAT, jsonDoc)));
                    } else {
                        resSB.append(String.format("{\"%s\":\"%s\"}", JSON_PROPERTY_PATH, BundleJSON.getPropertyAsString(JSON_PROPERTY_PATH, jsonDoc)));
                    }
                    formattedResources.add(String.format("  \"%s\":%s", contentType, resSB.toString()));
                }
            });
            sb.append(formattedResources.stream().collect(Collectors.joining(",\n", "", "\n")));
            sb.append("}\n");
        }
        catch (UnsupportedOperationException | Json.MalformedJsonException e) {
            throw new IllegalArgumentException(e);
        }
        return sb.toString();
    }

    private static String getPropertyAsString(String propertyName, Json jsonDocument) {
        Json propertyValue = jsonDocument.at(propertyName);
        if (propertyValue == null) {
            throw new IllegalArgumentException(String.format("JSON bundle is missing the required property %s (%s)", propertyName, jsonDocument.toString()));
        }
        if (!propertyValue.isString()) {
            throw new IllegalArgumentException(String.format("Expected string value for bundle property %s but found %s", propertyName, propertyValue.toString()));
        }
        return propertyValue.asString();
    }
}

