/*
 * Decompiled with CFR 0.152.
 */
package com.rewrite;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.CategoryTick;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.text.TextBlock;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.category.CategoryDataset;

public class ProfileCategoryAxis
extends CategoryAxis {
    private CategoryLabelPositions categoryLabelPositions = CategoryLabelPositions.STANDARD;
    private float maximumCategoryLabelWidthRatio = 0.0f;

    @Override
    public List<Tick> refreshTicks(Graphics2D g2, AxisState state, Rectangle2D dataArea, RectangleEdge edge) {
        CategoryPlot plot = (CategoryPlot)this.getPlot();
        CategoryDataset dataset = plot.getDataset();
        int startIndex = 0;
        int endIndex = 0;
        for (int i = 0; i < dataset.getColumnCount(); ++i) {
            if (String.valueOf(dataset.getColumnKey(i)).equals("start")) {
                startIndex = i;
                continue;
            }
            if (!String.valueOf(dataset.getColumnKey(i)).equals("end")) continue;
            endIndex = i;
        }
        ArrayList<Tick> ticks = new ArrayList<Tick>();
        List categories = plot.getCategoriesForAxis(this);
        double max = 0.0;
        if (categories != null) {
            CategoryLabelPosition position = super.getCategoryLabelPositions().getLabelPosition(edge);
            int categoryIndex = 0;
            for (Object o : categories) {
                CategoryTick tick;
                Comparable category = (Comparable)o;
                g2.setFont(this.getTickLabelFont(category));
                TextBlock label = new TextBlock();
                label.addLine(category.toString(), this.getTickLabelFont(category), this.getTickLabelPaint(category));
                if (edge == RectangleEdge.TOP || edge == RectangleEdge.BOTTOM) {
                    max = Math.max(max, this.calculateTextBlockHeight(label, position, g2));
                } else if (edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT) {
                    max = Math.max(max, this.calculateTextBlockWidth(label, position, g2));
                }
                if (categoryIndex == 0 || categoryIndex == startIndex || categoryIndex == endIndex || categoryIndex == categories.size() - 1) {
                    tick = new CategoryTick(category, label, position.getLabelAnchor(), position.getRotationAnchor(), position.getAngle());
                    ticks.add(tick);
                } else {
                    tick = new CategoryTick(category, new TextBlock(), position.getLabelAnchor(), position.getRotationAnchor(), position.getAngle());
                    ticks.add(tick);
                }
                ++categoryIndex;
            }
        }
        state.setMax(max);
        return ticks;
    }
}

