/*
 * Decompiled with CFR 0.152.
 */
package com.rewrite;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import org.jfree.chart.LegendItem;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.text.TextUtils;
import org.jfree.data.xy.XYDataset;

public class CustomXYLineAndShapeRenderer
extends XYLineAndShapeRenderer {
    @Override
    public LegendItem getLegendItem(int datasetIndex, int series) {
        LegendItem legendItem = new LegendItem("");
        Shape shape = this.getDefaultLegendShape();
        if (series == 0) {
            String label = " Methylated,+ strand  ";
            Color paint = Color.BLACK;
            Stroke lineStroke = this.lookupSeriesStroke(series);
            Color linePaint = Color.BLACK;
            legendItem = new LegendItem(label, label, "", "", shape, (Paint)paint, lineStroke, (Paint)linePaint);
            return legendItem;
        }
        if (series == 1) {
            String label = " Methylated,- strand  ";
            Color paint = Color.BLUE;
            Stroke lineStroke = this.lookupSeriesStroke(series);
            Color linePaint = Color.BLUE;
            legendItem = new LegendItem(label, label, "", "", shape, (Paint)paint, lineStroke, (Paint)linePaint);
            return legendItem;
        }
        if (series == 2) {
            String label = " Unmethylated,+ strand  ";
            Color paint = Color.WHITE;
            Stroke lineStroke = this.lookupSeriesStroke(series);
            Color linePaint = Color.BLACK;
            legendItem = new LegendItem(label, label, "", "", shape, (Paint)paint, lineStroke, (Paint)linePaint);
            return legendItem;
        }
        if (series == 3) {
            String label = " Unmethylated,- strand  ";
            Color paint = Color.WHITE;
            Stroke lineStroke = this.lookupSeriesStroke(series);
            Color linePaint = Color.BLUE;
            legendItem = new LegendItem(label, label, "", "", shape, (Paint)paint, lineStroke, (Paint)linePaint);
            return legendItem;
        }
        return null;
    }

    @Override
    protected void drawItemLabel(Graphics2D g2, PlotOrientation orientation, XYDataset dataset, int series, int item, double x, double y, boolean negative) {
        XYItemLabelGenerator generator = this.getItemLabelGenerator(series, item);
        if (generator != null) {
            String seriesString;
            String cpg;
            if (series == dataset.getSeriesCount() - 1) {
                Font labelFont = this.getItemLabelFont(series, item);
                Paint paint = this.getItemLabelPaint(series, item);
                g2.setFont(labelFont);
                g2.setPaint(paint);
                String label = generator.generateLabel(dataset, series, item);
                ItemLabelPosition position = !negative ? this.getPositiveItemLabelPosition(series, item) : this.getNegativeItemLabelPosition(series, item);
                Point2D anchorPoint = this.calculateLabelAnchorPoint(position.getItemLabelAnchor(), x, y += (double)(label.length() * 2), orientation);
                TextUtils.drawRotatedString(label, g2, (float)anchorPoint.getX(), (float)anchorPoint.getY(), position.getTextAnchor(), position.getAngle(), position.getRotationAnchor());
            } else if (series % 3 == 0 && item == (cpg = (seriesString = String.valueOf(dataset.getSeriesKey(series))).substring(seriesString.indexOf("_") + 1, seriesString.indexOf("*"))).length() - 1) {
                String label = seriesString.substring(seriesString.indexOf("*") + 1);
                ItemLabelPosition position = !negative ? this.getPositiveItemLabelPosition(series, item) : this.getNegativeItemLabelPosition(series, item);
                Point2D anchorPoint = this.calculateLabelAnchorPoint(position.getItemLabelAnchor(), x + 30.0, y, orientation);
                TextUtils.drawRotatedString(label, g2, (float)anchorPoint.getX(), (float)anchorPoint.getY(), position.getTextAnchor(), position.getAngle(), position.getRotationAnchor());
            }
        }
    }
}

