/*
 * Decompiled with CFR 0.152.
 */
package com.rewrite;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.util.Args;
import org.jfree.data.xy.XYDataset;

public class CustomXYBlockRenderer2
extends XYBlockRenderer {
    private double blockWidth = 1.0;
    private double blockHeight = 1.0;
    private RectangleAnchor blockAnchor;
    private double xOffset;
    private double yOffset;
    private PaintScale paintScale;
    private Integer xBlockNum;
    private Integer yBlockNum;

    @Override
    public PaintScale getPaintScale() {
        return this.paintScale;
    }

    @Override
    public void setPaintScale(PaintScale scale) {
        Args.nullNotPermitted(scale, "scale");
        this.paintScale = scale;
        this.fireChangeEvent();
    }

    public Integer getxBlockNum() {
        return this.xBlockNum;
    }

    public void setxBlockNum(Integer xBlockNum) {
        this.xBlockNum = xBlockNum;
    }

    public Integer getyBlockNum() {
        return this.yBlockNum;
    }

    public void setyBlockNum(Integer yBlockNum) {
        this.yBlockNum = yBlockNum;
    }

    @Override
    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        double x = dataset.getXValue(series, item);
        double y = dataset.getYValue(series, item);
        if (x != 0.0 || y != 0.0) {
            int xa = (int)(dataArea.getX() + dataArea.getWidth() / (double)this.xBlockNum.intValue() * x);
            int xb = (int)(dataArea.getX() + dataArea.getWidth() / (double)this.xBlockNum.intValue() * (x + 1.0));
            int xc = (int)(dataArea.getX() + dataArea.getWidth() / (double)this.xBlockNum.intValue() * (x + 1.0));
            int xd = (int)(dataArea.getX() + dataArea.getWidth() / (double)this.xBlockNum.intValue() * x);
            int ya = (int)(dataArea.getY() + dataArea.getHeight() / (double)this.yBlockNum.intValue() * ((double)this.yBlockNum.intValue() - y));
            int yb = (int)(dataArea.getY() + dataArea.getHeight() / (double)this.yBlockNum.intValue() * ((double)this.yBlockNum.intValue() - y));
            int yc = (int)(dataArea.getY() + dataArea.getHeight() / (double)this.yBlockNum.intValue() * ((double)this.yBlockNum.intValue() - y + 1.0));
            int yd = (int)(dataArea.getY() + dataArea.getHeight() / (double)this.yBlockNum.intValue() * ((double)this.yBlockNum.intValue() - y + 1.0));
            int[] xPos = new int[]{xa, xb, xc, xd};
            int[] yPos = new int[]{ya, yb, yc, yd};
            g2.drawPolygon(xPos, yPos, 4);
            g2.setPaint(new Color(0, 135, 100));
            g2.fillPolygon(xPos, yPos, 4);
        }
    }
}

