/*
 * Decompiled with CFR 0.152.
 */
package com.common.bigwigTool;

import com.common.bigwigTool.ParsingUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLocator {
    public static final Logger log = LoggerFactory.getLogger(ResourceLocator.class);
    public static String ucscSNP = "snp[0-9][0-9][0-9]";
    String name;
    String path;
    String dbURL;
    String indexPath;
    String coverage;
    public String format;
    private HashMap attributes = new HashMap();
    private boolean indexed;
    private boolean dataURL;
    private boolean htsget;
    static Set<String> knownFormats = new HashSet<String>(Arrays.asList("gff", "bed", "gtf", "gff3", "seg", "bb", "bigbed", "bigwig", "bam", "cram", "vcf"));

    public ResourceLocator(String path) {
        this.setPath(path);
    }

    public void setFormat(String formatOrExt) {
        this.format = formatOrExt == null ? null : (formatOrExt.startsWith(".") ? formatOrExt.substring(1) : formatOrExt);
    }

    public String toString() {
        return this.path + (this.dbURL == null ? "" : " " + this.dbURL);
    }

    public String getPath() {
        return this.path;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPath(String path) {
        if (path != null && path.startsWith("file://")) {
            this.path = path.substring("file://".length());
        } else if (path != null && path.startsWith("s3://")) {
            this.path = path;
            String s3UrlIndexPath = this.detectIndexPath(path);
            this.setIndexPath(s3UrlIndexPath);
        } else {
            this.dataURL = ParsingUtils.isDataURL(path);
            this.path = path;
        }
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    public String detectIndexPath(String inputPath) {
        log.debug("detectIndexPath() input S3 path is: " + inputPath);
        String indexPath = "";
        if (inputPath.contains(".bam")) {
            indexPath = inputPath + ".bai";
        } else if (inputPath.endsWith(".gz")) {
            indexPath = inputPath + ".tbi";
        } else {
            log.debug("S3 index object filetype could not be determined from S3 url");
        }
        return indexPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceLocator that = (ResourceLocator)o;
        if (this.dbURL != null ? !this.dbURL.equals(that.dbURL) : that.dbURL != null) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(that.path) : that.path != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.dbURL != null ? this.dbURL.hashCode() : 0);
        return result;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    public boolean isIndexed() {
        return this.indexed;
    }
}

