/*
 * Decompiled with CFR 0.152.
 */
package com.common.bigwigTool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPChromosomeRegion {
    public static final Logger log = LoggerFactory.getLogger(RPChromosomeRegion.class);
    private int startChromID;
    private int startBase;
    private int endChromID;
    private int endBase;

    public RPChromosomeRegion(int startChromID, int startBase, int endChromID, int endBase) {
        this.startChromID = startChromID;
        this.startBase = startBase;
        this.endChromID = endChromID;
        this.endBase = endBase;
    }

    public RPChromosomeRegion(RPChromosomeRegion region) {
        this.startChromID = region.startChromID;
        this.startBase = region.startBase;
        this.endChromID = region.endChromID;
        this.endBase = region.endBase;
    }

    public int getStartChromID() {
        return this.startChromID;
    }

    public int getStartBase() {
        return this.startBase;
    }

    public int getEndChromID() {
        return this.endChromID;
    }

    public int getEndBase() {
        return this.endBase;
    }

    public void print() {
        log.debug("Chromosome bounds:");
        log.debug("StartChromID = " + this.startChromID);
        log.debug("StartBase = " + this.startBase);
        log.debug("EndChromID = " + this.endChromID);
        log.debug("EndBase = " + this.endBase);
    }

    public int compareRegions(RPChromosomeRegion testRegion) {
        return this.compareRegions(testRegion.startChromID, testRegion.startBase, testRegion.endChromID, testRegion.endBase);
    }

    public int compareRegions(int testRegionStartChromID, int testRegionStartBase, int testRegionEndChromID, int testRegionEndBase) {
        if (this.containedIn(testRegionStartChromID, testRegionStartBase, testRegionEndChromID, testRegionEndBase)) {
            return 0;
        }
        if (this.disjointBelow(testRegionStartChromID, testRegionStartBase)) {
            return -2;
        }
        if (this.disjointAbove(testRegionEndChromID, testRegionEndBase)) {
            return 2;
        }
        if (this.intersectsBelow(testRegionStartChromID, testRegionStartBase)) {
            return -1;
        }
        if (this.intersectsAbove(testRegionEndChromID, testRegionEndBase)) {
            return 1;
        }
        return 3;
    }

    private boolean containedIn(int testRegionStartChromID, int testRegionStartBase, int testRegionEndChromID, int testRegionEndBase) {
        if (this.startChromID > testRegionStartChromID || this.startChromID == testRegionStartChromID && this.startBase >= testRegionStartBase) {
            return this.endChromID < testRegionEndChromID || this.endChromID == testRegionEndChromID && this.endBase <= testRegionEndBase;
        }
        return false;
    }

    private boolean intersectsBelow(int testRegionStartChromID, int testRegionStartBase) {
        if (this.startChromID < testRegionStartChromID || this.startChromID == testRegionStartChromID && this.startBase < testRegionStartBase) {
            return this.endChromID > testRegionStartChromID || this.endChromID == testRegionStartChromID && this.endBase > testRegionStartBase;
        }
        return false;
    }

    private boolean intersectsAbove(int testRegionEndChromID, int testRegionEndBase) {
        if (this.endChromID > testRegionEndChromID || this.endChromID == testRegionEndChromID && this.endBase > testRegionEndBase) {
            return this.startChromID < testRegionEndChromID || this.startChromID == testRegionEndChromID && this.startBase < testRegionEndBase;
        }
        return false;
    }

    private boolean disjointBelow(int testRegionStartChromID, int testRegionStartBase) {
        return this.endChromID < testRegionStartChromID || this.endChromID == testRegionStartChromID && this.endBase <= testRegionStartBase;
    }

    private boolean disjointAbove(int testRegionEndChromID, int testRegionEndBase) {
        return this.startChromID > testRegionEndChromID || this.startChromID == testRegionEndChromID && this.startBase >= testRegionEndBase;
    }

    public RPChromosomeRegion getExtremes(RPChromosomeRegion testRegion) {
        RPChromosomeRegion newRegion = new RPChromosomeRegion(this);
        if (testRegion.startChromID < newRegion.startChromID || testRegion.startChromID == newRegion.startChromID && testRegion.startBase < newRegion.startBase) {
            newRegion.startChromID = testRegion.startChromID;
            newRegion.startBase = testRegion.startBase;
        }
        if (testRegion.endChromID > newRegion.endChromID || testRegion.endChromID == newRegion.endChromID && testRegion.endBase > newRegion.endBase) {
            newRegion.endChromID = testRegion.endChromID;
            newRegion.endBase = testRegion.endBase;
        }
        return newRegion;
    }
}

