/*
 * Decompiled with CFR 0.152.
 */
package com.common.bigwigTool;

import com.common.bigwigTool.ResourceLocator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsingUtils {
    public static final Logger log = LoggerFactory.getLogger(ParsingUtils.class);

    public static InputStream openInputStream(String path) throws IOException {
        return ParsingUtils.openInputStreamGZ(new ResourceLocator(path));
    }

    public static InputStream openInputStreamGZ(ResourceLocator locator) throws IOException {
        FileInputStream inputStream = null;
        if (ParsingUtils.isDataURL(locator.getPath())) {
            String dataURL = locator.getPath();
            int commaIndex = dataURL.indexOf(44);
            if (commaIndex < 0) {
                throw new Error("dataURL missing commas");
            }
            String contents = URLDecoder.decode(dataURL.substring(commaIndex + 1), String.valueOf(StandardCharsets.UTF_8));
            return new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
        }
        String path = locator.getPath();
        if (path.startsWith("file://")) {
            path = path.substring(7);
        }
        File file = new File(path);
        inputStream = new FileInputStream(file);
        if (locator.getPath().endsWith("gz")) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static boolean isDataURL(String url) {
        return url != null && url.startsWith("data:") && !new File(url).exists();
    }
}

