/*
 * Decompiled with CFR 0.152.
 */
package com.common.bigwigTool;

import com.common.bigwigTool.IGVSeekableBufferedStream;
import com.common.bigwigTool.SeekableSplitStream;
import htsjdk.samtools.seekablestream.ISeekableStreamFactory;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class IGVSeekableStreamFactory
implements ISeekableStreamFactory {
    private static IGVSeekableStreamFactory instance = new IGVSeekableStreamFactory();

    private IGVSeekableStreamFactory() {
    }

    public static IGVSeekableStreamFactory getInstance() {
        return instance;
    }

    @Override
    public SeekableStream getStreamFor(URL url) throws IOException {
        return this.getStreamFor(url.toExternalForm());
    }

    @Override
    public SeekableStream getStreamFor(String path) throws IOException {
        if (path.endsWith(".list")) {
            return new SeekableSplitStream(path);
        }
        path = this.mapPath(path);
        SeekableFileStream is = new SeekableFileStream(new File(path));
        return is;
    }

    @Override
    public SeekableStream getBufferedStream(SeekableStream stream) {
        return this.getBufferedStream(stream, 512000);
    }

    @Override
    public SeekableStream getBufferedStream(SeekableStream stream, int bufferSize) {
        return new IGVSeekableBufferedStream(stream, bufferSize);
    }

    private String mapPath(String path) {
        if (path.startsWith("ftp://ftp.ncbi.nlm.nih.gov/geo")) {
            return path.replace("ftp://ftp.ncbi.nlm.nih.gov/geo", "https://ftp.ncbi.nlm.nih.gov/geo");
        }
        return path;
    }
}

