/*
 * Decompiled with CFR 0.152.
 */
package com.common.bigwigTool;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionUtils {
    public static final Logger log = LoggerFactory.getLogger(CompressionUtils.class);
    private Deflater deflater;
    private Inflater decompressor = new Inflater();

    public CompressionUtils() {
        this.deflater = new Deflater();
        this.deflater.setLevel(-1);
    }

    public synchronized byte[] decompress(byte[] data, int uncompressedChunkSize) {
        int rem = data.length;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(uncompressedChunkSize);
        byte[] outbuf = new byte[uncompressedChunkSize];
        this.decompressor.reset();
        this.decompressor.setInput(data);
        while (rem > 0) {
            if (this.decompressor.finished()) {
                this.decompressor = new Inflater();
                int offset = data.length - rem;
                this.decompressor.setInput(data, offset, rem);
            }
            try {
                int count = this.decompressor.inflate(outbuf, 0, outbuf.length);
                rem = this.decompressor.getRemaining();
                bos.write(outbuf, 0, count);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }
}

