/*
 * Decompiled with CFR 0.152.
 */
package com.common.bigwigTool;

import com.common.bigwigTool.BPTree;
import com.common.bigwigTool.BigWigDataBlock;
import com.common.bigwigTool.RPChromosomeRegion;
import com.common.bigwigTool.RPTree;
import com.common.bigwigTool.RPTreeLeafNodeItem;
import com.common.bigwigTool.WigItem;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigWigIterator {
    public static final Logger log = LoggerFactory.getLogger(BigWigIterator.class);
    boolean empty = false;
    private RPChromosomeRegion selectionRegion;
    private boolean isContained;
    private SeekableStream fis;
    private BPTree chromIDTree;
    private RPTree chromDataTree;
    private ArrayList<RPTreeLeafNodeItem> leafHitList;
    private Map<Integer, String> chromosomeMap;
    private int leafItemIndex;
    RPTreeLeafNodeItem leafHitItem;
    private RPChromosomeRegion hitRegion;
    private BigWigDataBlock wigDataBlock;
    private boolean dataBlockRead;
    private ArrayList<WigItem> wigItemList;
    private int wigItemIndex;

    public BigWigIterator(SeekableStream fis, BPTree chromIDTree, RPTree chromDataTree, RPChromosomeRegion selectionRegion, boolean contained) {
        if (selectionRegion == null) {
            throw new RuntimeException("Error: BigWigIterator selection region is null\n");
        }
        this.fis = fis;
        this.chromIDTree = chromIDTree;
        this.chromDataTree = chromDataTree;
        this.selectionRegion = new RPChromosomeRegion(selectionRegion);
        this.isContained = contained;
        int hitCount = this.getHitRegion(selectionRegion, contained);
        if (hitCount == 0) {
            this.empty = true;
        }
    }

    public BigWigIterator() {
        this.empty = true;
    }

    public boolean hasNext() {
        if (this.empty) {
            return false;
        }
        if (this.wigItemIndex < this.wigItemList.size()) {
            return true;
        }
        return this.leafItemIndex < this.leafHitList.size();
    }

    public WigItem next() {
        if (this.wigItemIndex < this.wigItemList.size()) {
            return this.wigItemList.get(this.wigItemIndex++);
        }
        int nHits = this.getHitRegion(this.selectionRegion, this.isContained);
        if (nHits > 0) {
            return this.wigItemList.get(this.wigItemIndex++);
        }
        String result = String.format("Failed to find data for wig region (%d,%d,%d,%d)\n", this.hitRegion.getStartChromID(), this.hitRegion.getStartBase(), this.hitRegion.getEndChromID(), this.hitRegion.getEndBase());
        log.error(result);
        return null;
    }

    private int getHitRegion(RPChromosomeRegion hitRegion, boolean contained) {
        int hitCount = 0;
        if (this.leafHitList == null ? (hitCount = this.getHitList(hitRegion, contained)) == 0 : (hitCount = this.leafHitList.size() - this.leafItemIndex) == 0) {
            return 0;
        }
        this.dataBlockRead = this.getDataBlock(this.leafItemIndex++);
        if (!this.dataBlockRead) {
            hitCount = this.getHitRegion(hitRegion, contained);
        }
        return hitCount;
    }

    private int getHitList(RPChromosomeRegion hitRegion, boolean contained) {
        this.leafHitList = this.chromDataTree.getChromosomeDataHits(hitRegion, contained);
        int nHits = this.leafHitList.size();
        if (nHits == 0) {
            return 0;
        }
        this.leafItemIndex = 0;
        int startChromID = this.leafHitList.get(0).getChromosomeBounds().getStartChromID();
        int startBase = this.leafHitList.get(0).getChromosomeBounds().getStartBase();
        int endChromID = this.leafHitList.get(nHits - 1).getChromosomeBounds().getEndChromID();
        int endBase = this.leafHitList.get(nHits - 1).getChromosomeBounds().getEndBase();
        this.hitRegion = new RPChromosomeRegion(startChromID, startBase, endChromID, endBase);
        return nHits;
    }

    private boolean getDataBlock(int leafItemIndex) {
        if (leafItemIndex >= this.leafHitList.size()) {
            return false;
        }
        this.leafHitItem = this.leafHitList.get(leafItemIndex);
        int startChromID = this.leafHitItem.getChromosomeBounds().getStartChromID();
        int endChromID = this.leafHitItem.getChromosomeBounds().getEndChromID();
        this.chromosomeMap = this.chromIDTree.getChromosomeIDMap(startChromID, endChromID);
        boolean isLowToHigh = this.chromDataTree.isIsLowToHigh();
        int uncompressBufSize = this.chromDataTree.getUncompressBuffSize();
        this.wigDataBlock = new BigWigDataBlock(this.fis, this.leafHitItem, this.chromosomeMap, isLowToHigh, uncompressBufSize);
        this.wigItemList = this.wigDataBlock.getWigData(this.selectionRegion, this.isContained);
        this.wigItemIndex = 0;
        return this.wigItemList.size() > 0;
    }
}

