/*
 * Decompiled with CFR 0.152.
 */
package com.common.bigwigTool;

import com.common.bigwigTool.BPTreeLeafNodeItem;
import com.common.bigwigTool.BPTreeNode;
import com.common.bigwigTool.BPTreeNodeItem;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPTreeLeafNode
implements BPTreeNode {
    public static final Logger log = LoggerFactory.getLogger(BPTreeLeafNode.class);
    private final boolean isLeafNode = true;
    private long nodeIndex;
    String lowestChromKey;
    String highestChromKey;
    int lowestChromID;
    int highestChromID;
    private ArrayList<BPTreeLeafNodeItem> leafItems;

    public BPTreeLeafNode(long nodeIndex) {
        this.nodeIndex = nodeIndex;
        this.leafItems = new ArrayList();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean insertItem(BPTreeNodeItem item) {
        this.leafItems.add((BPTreeLeafNodeItem)item);
        if (this.leafItems.size() == 1) {
            this.lowestChromKey = item.getChromKey();
            this.lowestChromID = ((BPTreeLeafNodeItem)item).getChromID();
        } else {
            this.highestChromKey = item.getChromKey();
            this.highestChromID = ((BPTreeLeafNodeItem)item).getChromID();
        }
        return true;
    }

    @Override
    public int getItemCount() {
        return this.leafItems.size();
    }

    @Override
    public String getLowestChromKey() {
        if (this.leafItems.size() > 0) {
            return this.lowestChromKey;
        }
        return null;
    }

    @Override
    public String getHighestChromKey() {
        if (this.leafItems.size() > 0) {
            return this.highestChromKey;
        }
        return null;
    }

    @Override
    public int getLowestChromID() {
        if (this.leafItems.size() > 0) {
            return this.lowestChromID;
        }
        return -1;
    }

    @Override
    public int getHighestChromID() {
        if (this.leafItems.size() > 0) {
            return this.highestChromID;
        }
        return -1;
    }

    @Override
    public void printItems() {
        int itemCount = this.getItemCount();
        log.debug("Leaf node " + this.nodeIndex + "contains " + itemCount + " leaf items:");
        for (int item = 0; item < itemCount; ++item) {
            this.leafItems.get(item).print();
        }
    }
}

