/*
 * Decompiled with CFR 0.152.
 */
package com.common.bigwigTool;

import com.common.bigwigTool.BPTreeChildNodeItem;
import com.common.bigwigTool.BPTreeNode;
import com.common.bigwigTool.BPTreeNodeItem;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPTreeChildNode
implements BPTreeNode {
    public static final Logger log = LoggerFactory.getLogger(BPTreeChildNode.class);
    private final boolean isLeafNode = false;
    private long nodeIndex;
    String lowestChromKey;
    String highestChromKey;
    int lowestChromID;
    int highestChromID;
    private ArrayList<BPTreeChildNodeItem> childItems;

    public BPTreeChildNode(long nodeIndex) {
        this.nodeIndex = nodeIndex;
        this.childItems = new ArrayList();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean insertItem(BPTreeNodeItem item) {
        this.childItems.add((BPTreeChildNodeItem)item);
        BPTreeNode childNode = ((BPTreeChildNodeItem)item).getChildNode();
        if (this.childItems.size() == 1) {
            this.lowestChromKey = childNode.getLowestChromKey();
            this.lowestChromID = childNode.getLowestChromID();
        } else {
            this.highestChromKey = childNode.getHighestChromKey();
            this.highestChromID = childNode.getHighestChromID();
        }
        return true;
    }

    @Override
    public int getItemCount() {
        return this.childItems.size();
    }

    @Override
    public String getLowestChromKey() {
        if (this.childItems.size() > 0) {
            return this.lowestChromKey;
        }
        return null;
    }

    @Override
    public String getHighestChromKey() {
        if (this.childItems.size() > 0) {
            return this.highestChromKey;
        }
        return null;
    }

    @Override
    public int getLowestChromID() {
        if (this.childItems.size() > 0) {
            return this.lowestChromID;
        }
        return -1;
    }

    @Override
    public int getHighestChromID() {
        if (this.childItems.size() > 0) {
            return this.highestChromID;
        }
        return -1;
    }

    @Override
    public void printItems() {
        int itemCount = this.getItemCount();
        log.debug("Child node " + this.nodeIndex + " contains " + itemCount + " child items:");
        for (int item = 0; item < itemCount; ++item) {
            this.childItems.get(item).print();
        }
    }

    public ArrayList<BPTreeChildNodeItem> getChildItems() {
        return this.childItems;
    }
}

