/*
 * Decompiled with CFR 0.152.
 */
package com.common.bigwigTool;

import com.common.bigwigTool.BBZoomLevelFormat;
import com.common.bigwigTool.BBZoomLevelHeader;
import com.common.bigwigTool.IGVSeekableBufferedStream;
import com.common.bigwigTool.RPTree;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BBZoomLevels {
    public static final Logger log = LoggerFactory.getLogger(BBZoomLevels.class);
    private long zoomHeadersOffset;
    private int zoomLevelsCount;
    private ArrayList<BBZoomLevelHeader> zoomLevelHeaders;
    private ArrayList<BBZoomLevelFormat> zoomLevelFormatList;
    private ArrayList<RPTree> zoomLevelRPTree;

    public BBZoomLevels(SeekableStream is, long fileOffset, int zoomLevels, boolean isLowToHigh, int uncompressBufSize) {
        this.zoomHeadersOffset = fileOffset;
        this.zoomLevelsCount = zoomLevels;
        IGVSeekableBufferedStream fis = new IGVSeekableBufferedStream(is, 512000);
        int zoomHeadersRead = this.readZoomHeaders(fis, this.zoomHeadersOffset, zoomLevels, isLowToHigh);
        if (zoomHeadersRead > 0) {
            int index;
            this.zoomLevelFormatList = new ArrayList();
            for (index = 0; index < zoomHeadersRead; ++index) {
                int zoomLevel = index + 1;
                long zoomDataOffset = this.zoomLevelHeaders.get(index).getDataOffset();
                long dataSize = this.zoomLevelHeaders.get(index).getIndexOffset() - zoomDataOffset - 4L;
                BBZoomLevelFormat zoomLevelData = new BBZoomLevelFormat(zoomLevel, fis, zoomDataOffset, dataSize, isLowToHigh, uncompressBufSize);
                this.zoomLevelFormatList.add(zoomLevelData);
            }
            this.zoomLevelRPTree = new ArrayList();
            for (index = 0; index < zoomHeadersRead; ++index) {
                long zoomIndexOffset = this.zoomLevelHeaders.get(index).getIndexOffset();
                RPTree zoomRPTree = new RPTree(fis, zoomIndexOffset, isLowToHigh, uncompressBufSize);
                this.zoomLevelRPTree.add(zoomRPTree);
            }
        }
    }

    private int readZoomHeaders(SeekableStream fis, long fileOffset, int zoomLevels, boolean isLowToHigh) {
        int level = 0;
        if (zoomLevels < 1) {
            return 0;
        }
        this.zoomLevelHeaders = new ArrayList();
        for (int index = 0; index < zoomLevels; ++index) {
            level = index + 1;
            BBZoomLevelHeader zoomLevelHeader = new BBZoomLevelHeader(fis, fileOffset, level, isLowToHigh);
            this.zoomLevelHeaders.add(zoomLevelHeader);
            fileOffset += 24L;
        }
        return level;
    }
}

