/*
 * Decompiled with CFR 0.152.
 */
package com.common.bigwigTool;

import com.common.bigwigTool.LittleEndianInputStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BBZoomLevelHeader {
    public static final Logger log = LoggerFactory.getLogger(BBZoomLevelHeader.class);
    public static final int ZOOM_LEVEL_HEADER_SIZE = 24;
    private SeekableStream fis;
    private long zoomLevelHeaderOffset;
    int zoomLevel;
    private int reductionLevel;
    private int reserved;
    private long dataOffset;
    private long indexOffset;

    public BBZoomLevelHeader(SeekableStream fis, long fileOffset, int zoomLevel, boolean isLowToHigh) {
        this.fis = fis;
        this.zoomLevelHeaderOffset = fileOffset;
        this.zoomLevel = zoomLevel;
        this.readZoomLevelHeader(this.zoomLevelHeaderOffset, this.zoomLevel, isLowToHigh);
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public long getIndexOffset() {
        return this.indexOffset;
    }

    public void print() {
        System.out.println("Zoom level " + this.zoomLevel + " header Table D: ");
        System.out.println("Number of zoom level bases = " + this.reductionLevel);
        System.out.println("Reserved = " + this.reserved);
        System.out.println("Zoom data offset = " + this.dataOffset);
        System.out.println("Zoom index offset = " + this.indexOffset);
    }

    private void readZoomLevelHeader(long fileOffset, int zoomLevel, boolean isLowToHigh) {
        LittleEndianInputStream lbdis = null;
        DataInputStream bdis = null;
        byte[] buffer = new byte[24];
        try {
            this.fis.seek(fileOffset);
            this.fis.readFully(buffer);
            if (isLowToHigh) {
                lbdis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
            } else {
                bdis = new DataInputStream(new ByteArrayInputStream(buffer));
            }
            if (isLowToHigh) {
                this.reductionLevel = lbdis.readInt();
                this.reserved = lbdis.readInt();
                this.dataOffset = lbdis.readLong();
                this.indexOffset = lbdis.readLong();
            } else {
                this.reductionLevel = bdis.readInt();
                this.reserved = bdis.readInt();
                this.dataOffset = bdis.readLong();
                this.indexOffset = bdis.readLong();
            }
        }
        catch (IOException ex) {
            log.error("Error reading zoom level header: " + zoomLevel, ex);
            throw new RuntimeException("Error reading zoom header " + zoomLevel, ex);
        }
    }
}

