/*
 * Decompiled with CFR 0.152.
 */
package com.common.bigwigTool;

import com.common.bigwigTool.LittleEndianInputStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BBZoomLevelFormat {
    public static final Logger log = LoggerFactory.getLogger(BBZoomLevelFormat.class);
    public static final int ZOOM_FORMAT_HEADER_SIZE = 4;
    public static final int MAX_ZOOM_DATA_RECORDS = 100000000;
    private int zoomLevel;
    private SeekableStream fis;
    private long zoomFormatOffset;
    private long zoomDataOffset;
    private long zoomIndexOffset;
    private boolean isLowToHigh;
    private int zoomRecordCount;
    private long zoomDataSize;

    public BBZoomLevelFormat(int zoomLevel, SeekableStream fis, long fileOffset, long dataSize, boolean isLowToHigh, int uncompressBufSize) {
        this.zoomLevel = zoomLevel;
        this.fis = fis;
        this.zoomFormatOffset = fileOffset;
        this.zoomDataSize = dataSize;
        this.isLowToHigh = isLowToHigh;
        byte[] buffer = new byte[4];
        try {
            fis.seek(this.zoomFormatOffset);
            fis.readFully(buffer);
            if (this.isLowToHigh) {
                LittleEndianInputStream lbdis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
                this.zoomRecordCount = lbdis.readInt();
            } else {
                DataInputStream bdis = new DataInputStream(new ByteArrayInputStream(buffer));
                this.zoomRecordCount = bdis.readInt();
            }
        }
        catch (IOException ex) {
            log.error("Error reading zoom level data records (Table O) ", ex);
            throw new RuntimeException("Error reading zoom level data records (Table O)", ex);
        }
        if (this.zoomRecordCount < 0 || this.zoomRecordCount > 100000000) {
            return;
        }
        this.zoomDataOffset = this.zoomFormatOffset + 4L;
        this.zoomIndexOffset = this.zoomDataOffset + this.zoomDataSize;
    }

    public void print() {
        log.debug("Zoom level " + this.zoomLevel + " format Table O found at " + this.zoomFormatOffset);
        log.debug("Zoom record count is " + this.zoomRecordCount);
        log.debug("Zoom data location is " + this.zoomDataOffset);
        log.debug("Zoom data size is " + this.zoomDataOffset);
        log.debug("Zoom index tree location is " + this.zoomIndexOffset);
    }
}

