/*
 * Decompiled with CFR 0.152.
 */
package com.common.bigwigTool;

import com.common.bigwigTool.LittleEndianInputStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BBTotalSummaryBlock {
    public static final Logger log = LoggerFactory.getLogger(BBTotalSummaryBlock.class);
    public static final int TOTAL_SUMMARY_BLOCK_SIZE = 40;
    private SeekableStream fis;
    private long summaryBlockOffset;
    private long basesCovered;
    private float minVal;
    private float maxVal;
    private float sumData;
    private float sumSquares;

    public BBTotalSummaryBlock(SeekableStream fis, long fileOffset, boolean isLowToHigh) {
        LittleEndianInputStream lbdis = null;
        DataInputStream bdis = null;
        byte[] buffer = new byte[40];
        this.fis = fis;
        this.summaryBlockOffset = fileOffset;
        try {
            fis.seek(fileOffset);
            fis.readFully(buffer);
            if (isLowToHigh) {
                lbdis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
            } else {
                bdis = new DataInputStream(new ByteArrayInputStream(buffer));
            }
            if (isLowToHigh) {
                this.basesCovered = lbdis.readLong();
                this.minVal = lbdis.readFloat();
                this.maxVal = lbdis.readFloat();
                this.sumData = lbdis.readFloat();
                this.sumSquares = lbdis.readFloat();
            } else {
                this.basesCovered = bdis.readLong();
                this.minVal = bdis.readFloat();
                this.maxVal = bdis.readFloat();
                this.sumData = bdis.readFloat();
                this.sumSquares = bdis.readFloat();
            }
        }
        catch (IOException ex) {
            log.error("Error reading Total Summary Block ", ex);
            throw new RuntimeException("Error reading Total Summary Block", ex);
        }
    }
}

