/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.args.TanghuluArgs;
import com.bean.MHapInfo;
import com.bean.Region;
import com.common.Util;
import com.rewrite.CustomXYLineAndShapeRenderer;
import com.rewrite.CustomXYLineAndShapeRenderer2;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tanghulu {
    public static final Logger log = LoggerFactory.getLogger(Tanghulu.class);
    TanghuluArgs args = new TanghuluArgs();
    Util util = new Util();

    public void tanghulu(TanghuluArgs tanghuluArgs) throws Exception {
        boolean checkResult;
        log.info("Tanghulu start!");
        this.args = tanghuluArgs;
        Region region = this.util.parseRegion(this.args.getRegion());
        if (region.getEnd() - region.getStart() > this.args.getMaxLength()) {
            log.info("The region is larger than " + this.args.getMaxLength() + ", it's not recommand to do tanghulu plotting and we will cut the superfluous region.");
            region.setEnd(region.getStart() + this.args.getMaxLength());
        }
        if (!(checkResult = this.checkArgs())) {
            log.error("Checkargs fail, please check the command.");
            return;
        }
        List<Integer> cpgPosList = this.util.parseCpgFileWithShift(this.args.getCpgPath(), region, 500);
        List<MHapInfo> mHapInfoList = this.util.parseMhapFile(this.args.getMhapPath(), region, this.args.getStrand(), this.args.getMerge());
        if (mHapInfoList.size() > this.args.getMaxReads()) {
            log.info("The reads is larger than " + this.args.getMaxReads() + ", it's not recommand to do tanghulu plotting and we will cut the superfluous reads.");
            mHapInfoList = mHapInfoList.subList(0, this.args.getMaxReads());
        }
        if (this.args.getSimulation().booleanValue()) {
            boolean simulationResult = this.simulation(mHapInfoList, cpgPosList, region);
            if (!simulationResult) {
                log.error("simulation fail, please check the command.");
                return;
            }
        } else {
            boolean tanghuluResult;
            if (this.args.getCutReads().booleanValue()) {
                ArrayList<MHapInfo> mHapInfoListCutReadsMerged = new ArrayList<MHapInfo>();
                for (MHapInfo mHapInfo : mHapInfoList) {
                    List<Integer> cpgPosListInRegion = this.util.getCpgPosListInRegion(cpgPosList, region);
                    String cpg = this.util.cutReads(mHapInfo, cpgPosList, cpgPosListInRegion);
                    mHapInfo.setCpg(cpg);
                    if (mHapInfo.getStart() < cpgPosListInRegion.get(0)) {
                        mHapInfo.setStart(cpgPosListInRegion.get(0));
                    }
                    if (mHapInfo.getEnd() <= cpgPosListInRegion.get(cpgPosListInRegion.size() - 1)) continue;
                    mHapInfo.setEnd(cpgPosListInRegion.get(cpgPosListInRegion.size() - 1));
                }
                mHapInfoList.parallelStream().collect(Collectors.groupingBy(o -> o.index(), Collectors.toList())).forEach((id, transfer) -> transfer.stream().reduce((a, b) -> new MHapInfo(a.getChrom(), a.getStart(), a.getEnd(), a.getCpg(), a.getCnt() + b.getCnt(), a.getStrand())).ifPresent(mHapInfoListCutReadsMerged::add));
                mHapInfoListCutReadsMerged.sort(Comparator.comparing(MHapInfo::getStart));
                mHapInfoList = mHapInfoListCutReadsMerged;
            }
            if (!(tanghuluResult = this.paintTanghulu(mHapInfoList, cpgPosList, region))) {
                log.error("tanghulu fail, please check the command.");
                return;
            }
        }
        log.info("Tanghulu end!");
    }

    private boolean checkArgs() {
        if (this.args.getMhapPath().equals("")) {
            log.error("mhapPath can not be null.");
            return false;
        }
        if (this.args.getCpgPath().equals("")) {
            log.error("cpgPath can not be null.");
            return false;
        }
        if (this.args.getRegion().equals("")) {
            log.error("region can not be null.");
            return false;
        }
        if (!this.args.getOutFormat().equals("png") && !this.args.getOutFormat().equals("pdf")) {
            log.error("The output format must be pdf or png");
            return false;
        }
        if (!(this.args.getStrand().equals("plus") || this.args.getStrand().equals("minus") || this.args.getStrand().equals("both"))) {
            log.error("The strand must be one of plus, minus or both");
            return false;
        }
        if (this.args.getSimulation().booleanValue() && this.args.getMerge().booleanValue()) {
            log.error("Can not enter both simulation and merge");
            return false;
        }
        if (this.args.getSimulation().booleanValue() && this.args.getCutReads().booleanValue()) {
            log.info("The cutReads parameter is invalid when input simulation command");
        }
        if (this.args.getMaxReads() > 50) {
            log.error("The reads is larger than 50, it's not recommand to do tanghulu plotting, please re-enter the maxReads");
            return false;
        }
        if (this.args.getMaxLength() > 2000) {
            log.error("The region is larger than 2000, it's not recommand to do tanghulu plotting, please re-enter the maxLength");
            return false;
        }
        return true;
    }

    private boolean paintTanghulu(List<MHapInfo> mHapInfoList, List<Integer> cpgPosList, Region region) throws Exception {
        Integer startCpgPos;
        Object cpg;
        XYSeriesCollection dataset = new XYSeriesCollection();
        Integer startPos = Integer.MAX_VALUE;
        Integer endPos = 0;
        for (int i = 0; i < mHapInfoList.size(); ++i) {
            MHapInfo mHapInfo = mHapInfoList.get(i);
            cpg = mHapInfo.getCpg();
            startCpgPos = mHapInfo.getStart();
            if (mHapInfo.getStart() < startPos) {
                startPos = mHapInfo.getStart();
            }
            if (mHapInfo.getEnd() > endPos) {
                endPos = mHapInfo.getEnd();
            }
            XYSeries allSeries = new XYSeries((Comparable)((Object)(i + mHapInfo.indexByPos() + "_" + (String)cpg + "*" + mHapInfo.getCnt())));
            XYSeries cpgSeries = new XYSeries((Comparable)((Object)("cpg" + i + mHapInfo.indexByRead())));
            XYSeries unCpgSeries = new XYSeries((Comparable)((Object)("unCpg" + i + mHapInfo.indexByRead())));
            Integer pos = cpgPosList.indexOf(startCpgPos);
            for (int j = 0; j < ((String)cpg).length(); ++j) {
                allSeries.add(cpgPosList.get(pos + j), (Number)(i + 1));
                if (((String)cpg).charAt(j) == '1') {
                    cpgSeries.add(cpgPosList.get(pos + j), (Number)(i + 1));
                    continue;
                }
                unCpgSeries.add(cpgPosList.get(pos + j), (Number)(i + 1));
            }
            dataset.addSeries(allSeries);
            dataset.addSeries(cpgSeries);
            dataset.addSeries(unCpgSeries);
        }
        XYSeries alignSeries = new XYSeries((Comparable)((Object)"Align series"));
        Integer i = cpgPosList.indexOf(startPos);
        while (i < cpgPosList.indexOf(endPos) + 1) {
            alignSeries.add(cpgPosList.get(i), (Number)0);
            cpg = i;
            startCpgPos = i = Integer.valueOf(i + 1);
        }
        dataset.addSeries(alignSeries);
        File tempFile = new File(this.args.getMhapPath());
        String title = this.args.getRegion() + "(" + tempFile.getName() + ")";
        JFreeChart jfreechart = ChartFactory.createXYLineChart(title, "Genomic position", "", dataset, PlotOrientation.VERTICAL, true, false, false);
        XYPlot xyPlot = jfreechart.getXYPlot();
        xyPlot.setBackgroundPaint(Color.WHITE);
        xyPlot.setDomainGridlinesVisible(false);
        xyPlot.setRangeGridlinesVisible(false);
        xyPlot.setOutlineVisible(false);
        Integer width = (region.getEnd() - region.getStart()) * 15;
        width = width > 14400 ? 14400 : width;
        Integer height = dataset.getSeriesCount() * 25;
        height = height > 14400 ? 14400 : height;
        TextTitle textTitle = new TextTitle(title, new Font("", 0, width / 50));
        jfreechart.setTitle(textTitle);
        CustomXYLineAndShapeRenderer xyLineAndShapeRenderer = new CustomXYLineAndShapeRenderer();
        xyLineAndShapeRenderer.setDefaultItemLabelsVisible(this.args.getMerge() != false);
        Double circleSize = 25.0;
        Ellipse2D.Double circle = new Ellipse2D.Double(-circleSize.doubleValue() / 2.0, -circleSize.doubleValue() / 2.0, circleSize, circleSize);
        for (int i2 = 0; i2 < dataset.getSeriesCount() - 1; ++i2) {
            MHapInfo mHapInfo;
            if (i2 % 3 == 0) {
                xyLineAndShapeRenderer.setSeriesShape(i2, circle);
                xyLineAndShapeRenderer.setSeriesShapesFilled(i2, false);
                mHapInfo = mHapInfoList.get(i2 / 3);
                if (mHapInfo.getStrand().equals("+")) {
                    xyLineAndShapeRenderer.setSeriesPaint(i2, Color.BLACK);
                } else {
                    xyLineAndShapeRenderer.setSeriesPaint(i2, Color.BLUE);
                }
                ItemLabelPosition itemLabelPosition1 = new ItemLabelPosition(ItemLabelAnchor.INSIDE6, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
                xyLineAndShapeRenderer.setSeriesPositiveItemLabelPosition(i2, itemLabelPosition1);
                continue;
            }
            if (i2 % 3 == 1) {
                xyLineAndShapeRenderer.setSeriesShape(i2, circle);
                xyLineAndShapeRenderer.setSeriesShapesFilled(i2, true);
                xyLineAndShapeRenderer.setSeriesLinesVisible(i2, false);
                mHapInfo = mHapInfoList.get(i2 / 3);
                if (mHapInfo.getStrand().equals("+")) {
                    xyLineAndShapeRenderer.setSeriesPaint(i2, Color.BLACK);
                    continue;
                }
                xyLineAndShapeRenderer.setSeriesPaint(i2, Color.BLUE);
                continue;
            }
            Ellipse2D.Double circle1 = new Ellipse2D.Double(-circleSize.doubleValue() / 2.0, -circleSize.doubleValue() / 2.0, circleSize - 2.0, circleSize - 2.0);
            xyLineAndShapeRenderer.setSeriesShape(i2, circle1);
            xyLineAndShapeRenderer.setSeriesShapesFilled(i2, true);
            xyLineAndShapeRenderer.setSeriesLinesVisible(i2, false);
            xyLineAndShapeRenderer.setSeriesPaint(i2, Color.WHITE);
        }
        xyLineAndShapeRenderer.setSeriesShape(dataset.getSeriesCount() - 1, circle);
        xyLineAndShapeRenderer.setSeriesShapesFilled(dataset.getSeriesCount() - 1, true);
        xyLineAndShapeRenderer.setSeriesLinesVisible(dataset.getSeriesCount() - 1, true);
        xyLineAndShapeRenderer.setSeriesPaint(dataset.getSeriesCount() - 1, Color.GRAY);
        xyLineAndShapeRenderer.setSeriesItemLabelsVisible(dataset.getSeriesCount() - 1, true);
        xyLineAndShapeRenderer.setDefaultLegendShape(circle);
        xyPlot.setRenderer(xyLineAndShapeRenderer);
        XYItemRenderer xyItemRenderer = xyPlot.getRenderer();
        DecimalFormat decimalformat = new DecimalFormat("############");
        xyItemRenderer.setDefaultItemLabelGenerator(new StandardXYItemLabelGenerator("{1}", (NumberFormat)decimalformat, (NumberFormat)decimalformat));
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER, TextAnchor.CENTER, -0.5);
        xyItemRenderer.setSeriesPositiveItemLabelPosition(dataset.getSeriesCount() - 1, itemLabelPosition);
        xyItemRenderer.setSeriesItemLabelPaint(dataset.getSeriesCount() - 1, Color.GRAY);
        Double fontSize = 25.0;
        xyItemRenderer.setSeriesItemLabelFont(dataset.getSeriesCount() - 1, new Font("", 0, fontSize.intValue()));
        xyPlot.setRenderer(xyItemRenderer);
        ValueAxis domainAxis = xyPlot.getDomainAxis();
        domainAxis.setVisible(false);
        NumberAxis rangeAxis = (NumberAxis)xyPlot.getRangeAxis();
        NumberTickUnit numberTickUnit = new NumberTickUnit(1.0);
        rangeAxis.setTickUnit(numberTickUnit);
        rangeAxis.setTickLabelFont(new Font("", 0, 25));
        Range range = new Range(-2.0, mHapInfoList.size() + 2);
        rangeAxis.setRange(range);
        String Tag = "";
        if (this.args.getOutFormat().equals("png")) {
            Tag = this.args.getTag() + "_" + region.toFileString() + ".tanghulu.png";
            this.util.saveAsPng(jfreechart, Tag, width, height);
        } else {
            Tag = this.args.getTag() + "_" + region.toFileString() + ".tanghulu.pdf";
            this.util.saveAsPdf(jfreechart, Tag, width, height);
        }
        return true;
    }

    private boolean simulation(List<MHapInfo> mHapInfoList, List<Integer> cpgPosList, Region region) throws Exception {
        Serializable unCpgSeries;
        Double toRight_1_1;
        Double toRight1Not0;
        Double toLeft11;
        Double toLeft1_1;
        int i;
        int i2;
        List<Integer> cpgPosListInRegion = this.util.getCpgPosListInRegion(cpgPosList, region);
        if (cpgPosListInRegion.size() > 20) {
            log.error("nums of cpg are larger than 20 " + cpgPosListInRegion.size());
            return false;
        }
        Integer[][] cpgHpMatInRegion = new Integer[mHapInfoList.size()][cpgPosListInRegion.size()];
        for (i2 = 0; i2 < mHapInfoList.size(); ++i2) {
            for (int j = 0; j < cpgPosListInRegion.size(); ++j) {
                cpgHpMatInRegion[i2][j] = 0;
            }
        }
        for (i2 = 0; i2 < mHapInfoList.size(); ++i2) {
            int k;
            MHapInfo mHapInfo = mHapInfoList.get(i2);
            Integer pos = cpgPosList.indexOf(cpgPosListInRegion.get(0)) - cpgPosList.indexOf(mHapInfo.getStart());
            int n = k = pos > 0 ? pos : 0;
            while (k < mHapInfo.getCpg().length()) {
                if (k - pos < cpgPosListInRegion.size()) {
                    cpgHpMatInRegion[i2][k - pos.intValue()] = mHapInfo.getCpg().charAt(k) == '0' ? Integer.valueOf(-1) : Integer.valueOf(1);
                }
                ++k;
            }
        }
        ArrayList<Double> cpgRateList = new ArrayList<Double>();
        for (int i3 = 0; i3 < cpgPosListInRegion.size(); ++i3) {
            Double cpgRate = 0.0;
            Double cpgCnt = 0.0;
            Double allCnt = 0.0;
            for (int j = 0; j < mHapInfoList.size(); ++j) {
                Double d;
                Double d2;
                if (cpgHpMatInRegion[j][i3] == 0) continue;
                if (cpgHpMatInRegion[j][i3] == 1) {
                    d2 = cpgCnt;
                    d = cpgCnt = Double.valueOf(cpgCnt + 1.0);
                }
                d2 = allCnt;
                d = allCnt = Double.valueOf(allCnt + 1.0);
            }
            cpgRate = cpgCnt / allCnt;
            cpgRateList.add(cpgRate);
        }
        Double sumCpgRate = 0.0;
        Double sumCpgCnt = 0.0;
        Double sumAllCnt = 0.0;
        for (int i4 = 0; i4 < mHapInfoList.size(); ++i4) {
            MHapInfo mHapInfo = mHapInfoList.get(i4);
            for (int j = 0; j < mHapInfo.getCpg().length(); ++j) {
                String cpg = mHapInfo.getCpg();
                if (cpg.charAt(j) == '1') {
                    sumCpgCnt = sumCpgCnt + (double)mHapInfo.getCnt().intValue();
                }
                sumAllCnt = sumAllCnt + (double)mHapInfo.getCnt().intValue();
            }
        }
        sumCpgRate = sumCpgCnt / sumAllCnt;
        ArrayList<Double[][]> toLeftList = new ArrayList<Double[][]>();
        ArrayList<Double[][]> toRightList = new ArrayList<Double[][]>();
        for (i = 0; i < cpgPosListInRegion.size(); ++i) {
            Double[][] toLeft = new Double[2][2];
            Double toLeft_1Not0 = 0.0;
            Double toLeft1Not0 = 0.0;
            Double toLeft_1_1 = 0.0;
            Double toLeft_11 = 0.0;
            toLeft1_1 = 0.0;
            toLeft11 = 0.0;
            if (i == 0) {
                toLeft = new Double[][]{{0.0, 0.0}, {0.0, 0.0}};
            } else {
                for (int j = 0; j < mHapInfoList.size(); ++j) {
                    Double d;
                    Double d3;
                    if (cpgHpMatInRegion[j][i] == 0 || cpgHpMatInRegion[j][i - 1] == 0) continue;
                    if (cpgHpMatInRegion[j][i] == -1) {
                        if (cpgHpMatInRegion[j][i - 1] == -1) {
                            d3 = toLeft_1_1;
                            d = toLeft_1_1 = Double.valueOf(toLeft_1_1 + 1.0);
                        } else if (cpgHpMatInRegion[j][i - 1] == 1) {
                            d3 = toLeft_11;
                            d = toLeft_11 = Double.valueOf(toLeft_11 + 1.0);
                        }
                        d3 = toLeft_1Not0;
                        d = toLeft_1Not0 = Double.valueOf(toLeft_1Not0 + 1.0);
                        continue;
                    }
                    if (cpgHpMatInRegion[j][i] != 1) continue;
                    if (cpgHpMatInRegion[j][i - 1] == -1) {
                        d3 = toLeft1_1;
                        d = toLeft1_1 = Double.valueOf(toLeft1_1 + 1.0);
                    } else if (cpgHpMatInRegion[j][i - 1] == 1) {
                        d3 = toLeft11;
                        d = toLeft11 = Double.valueOf(toLeft11 + 1.0);
                    }
                    d3 = toLeft1Not0;
                    d = toLeft1Not0 = Double.valueOf(toLeft1Not0 + 1.0);
                }
                toLeft[0][0] = toLeft_1Not0 == 0.0 ? 0.0 : toLeft_1_1 / toLeft_1Not0;
                toLeft[0][1] = toLeft_1Not0 == 0.0 ? 0.0 : toLeft_11 / toLeft_1Not0;
                toLeft[1][0] = toLeft1Not0 == 0.0 ? 0.0 : toLeft1_1 / toLeft1Not0;
                toLeft[1][1] = toLeft1Not0 == 0.0 ? 0.0 : toLeft11 / toLeft1Not0;
            }
            toLeftList.add(toLeft);
            Double[][] toRight = new Double[2][2];
            Double toRight_1Not0 = 0.0;
            toRight1Not0 = 0.0;
            toRight_1_1 = 0.0;
            Double toRight_11 = 0.0;
            Double toRight1_1 = 0.0;
            Double toRight11 = 0.0;
            if (i == cpgPosListInRegion.size() - 1) {
                toRight = new Double[][]{{0.0, 0.0}, {0.0, 0.0}};
            } else {
                for (int j = 0; j < mHapInfoList.size(); ++j) {
                    Double d;
                    Double d4;
                    if (cpgHpMatInRegion[j][i] == 0 || cpgHpMatInRegion[j][i + 1] == 0) continue;
                    if (cpgHpMatInRegion[j][i] == -1) {
                        if (cpgHpMatInRegion[j][i + 1] == -1) {
                            d4 = toRight_1_1;
                            d = toRight_1_1 = Double.valueOf(toRight_1_1 + 1.0);
                        } else if (cpgHpMatInRegion[j][i + 1] == 1) {
                            d4 = toRight_11;
                            d = toRight_11 = Double.valueOf(toRight_11 + 1.0);
                        }
                        d4 = toRight_1Not0;
                        d = toRight_1Not0 = Double.valueOf(toRight_1Not0 + 1.0);
                        continue;
                    }
                    if (cpgHpMatInRegion[j][i] != 1) continue;
                    if (cpgHpMatInRegion[j][i + 1] == -1) {
                        d4 = toRight1_1;
                        d = toRight1_1 = Double.valueOf(toRight1_1 + 1.0);
                    } else if (cpgHpMatInRegion[j][i + 1] == 1) {
                        d4 = toRight11;
                        d = toRight11 = Double.valueOf(toRight11 + 1.0);
                    }
                    d4 = toRight1Not0;
                    d = toRight1Not0 = Double.valueOf(toRight1Not0 + 1.0);
                }
                toRight[0][0] = toRight_1Not0 == 0.0 ? 0.0 : toRight_1_1 / toRight_1Not0;
                toRight[0][1] = toRight_1Not0 == 0.0 ? 0.0 : toRight_11 / toRight_1Not0;
                toRight[1][0] = toRight1Not0 == 0.0 ? 0.0 : toRight1_1 / toRight1Not0;
                toRight[1][1] = toRight1Not0 == 0.0 ? 0.0 : toRight11 / toRight1Not0;
            }
            toRightList.add(toRight);
        }
        for (i = 0; i < mHapInfoList.size(); ++i) {
            for (int j = 0; j < cpgPosListInRegion.size(); ++j) {
                this.dfs(i, j, cpgHpMatInRegion, toLeftList, toRightList, cpgPosListInRegion);
            }
        }
        for (i = 0; i < mHapInfoList.size(); ++i) {
            for (int j = 0; j < cpgPosListInRegion.size(); ++j) {
                cpgHpMatInRegion[i][j] = cpgHpMatInRegion[i][j] == -1 ? 0 : 1;
            }
        }
        Random random = new Random();
        Integer[][] cpgHpMatSample = new Integer[10][cpgPosList.size()];
        for (int i5 = 0; i5 < 10; ++i5) {
            Integer randomNum = random.nextInt(mHapInfoList.size());
            cpgHpMatSample[i5] = cpgHpMatInRegion[randomNum];
        }
        ArrayList<Double> cpgRateListInSample = new ArrayList<Double>();
        for (int j = 0; j < cpgPosListInRegion.size(); ++j) {
            Double cpgNum = 0.0;
            for (int i6 = 0; i6 < cpgHpMatSample.length; ++i6) {
                if (cpgHpMatSample[i6][j] != 1) continue;
                toLeft1_1 = cpgNum;
                toLeft11 = cpgNum = Double.valueOf(cpgNum + 1.0);
            }
            cpgRateListInSample.add(cpgNum / (double)cpgHpMatSample.length);
        }
        Double loss = 0.0;
        for (int i7 = 0; i7 < cpgPosListInRegion.size(); ++i7) {
            loss = loss + Math.pow((Double)cpgRateList.get(i7) - (Double)cpgRateListInSample.get(i7), 2.0);
        }
        while (cpgHpMatSample.length < 20) {
            Integer randomNum = random.nextInt(mHapInfoList.size());
            Integer[][] newCpgHpMatSample = new Integer[cpgHpMatSample.length + 1][cpgPosList.size()];
            for (int i8 = 0; i8 < cpgHpMatSample.length; ++i8) {
                newCpgHpMatSample[i8] = cpgHpMatSample[i8];
            }
            newCpgHpMatSample[cpgHpMatSample.length] = cpgHpMatInRegion[randomNum];
            ArrayList<Double> newCpgRateListInSample = new ArrayList<Double>();
            for (int j = 0; j < cpgPosListInRegion.size(); ++j) {
                Double cpgNum = 0.0;
                for (int i9 = 0; i9 < newCpgHpMatSample.length; ++i9) {
                    if (newCpgHpMatSample[i9][j] != 1) continue;
                    toRight1Not0 = cpgNum;
                    toRight_1_1 = cpgNum = Double.valueOf(cpgNum + 1.0);
                }
                newCpgRateListInSample.add(cpgNum / (double)newCpgHpMatSample.length);
            }
            Double newLoss = 0.0;
            for (int i10 = 0; i10 < cpgPosListInRegion.size(); ++i10) {
                newLoss = newLoss + Math.pow((Double)cpgRateList.get(i10) - (Double)newCpgRateListInSample.get(i10), 2.0);
            }
            if (newLoss <= loss) {
                cpgHpMatSample = newCpgHpMatSample;
                loss = newLoss;
                continue;
            }
            if (!(Math.random() < 0.1)) continue;
            cpgHpMatSample = newCpgHpMatSample;
        }
        Arrays.sort(cpgHpMatSample, new Comparator<Integer[]>(){

            @Override
            public int compare(Integer[] a, Integer[] b) {
                Integer n;
                Integer cpgNumA = 0;
                for (int i = 0; i < a.length; ++i) {
                    if (a[i] != 1) continue;
                    Integer n2 = cpgNumA;
                    n = cpgNumA = Integer.valueOf(cpgNumA + 1);
                }
                Integer cpgNumB = 0;
                for (int i = 0; i < b.length; ++i) {
                    if (b[i] != 1) continue;
                    n = cpgNumB;
                    Integer n3 = cpgNumB = Integer.valueOf(cpgNumB + 1);
                }
                return cpgNumA - cpgNumB;
            }
        });
        Integer width = cpgPosListInRegion.size() * 100;
        Integer height = width / (2 * cpgPosListInRegion.size() + 1) * 40;
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (int i11 = 0; i11 < cpgHpMatSample.length; ++i11) {
            XYSeries allSeries = new XYSeries((Comparable)((Object)(i11 + String.valueOf(cpgHpMatSample))));
            XYSeries cpgSeries = new XYSeries((Comparable)((Object)("cpg" + i11 + String.valueOf(cpgHpMatSample))));
            unCpgSeries = new XYSeries((Comparable)((Object)("unCpg" + i11 + String.valueOf(cpgHpMatSample))));
            for (int j = 0; j < cpgHpMatSample[i11].length; ++j) {
                Integer xPos = width / (cpgPosListInRegion.size() + 1) * (j + 1);
                allSeries.add(xPos, (Number)(cpgHpMatSample.length - i11));
                if (cpgHpMatSample[i11][j] == 1) {
                    cpgSeries.add(xPos, (Number)(cpgHpMatSample.length - i11));
                    continue;
                }
                ((XYSeries)unCpgSeries).add(xPos, cpgHpMatSample.length - i11);
            }
            dataset.addSeries(allSeries);
            dataset.addSeries(cpgSeries);
            dataset.addSeries((XYSeries)unCpgSeries);
        }
        XYSeries alignSeries = new XYSeries((Comparable)((Object)"Align series"));
        Integer i12 = 0;
        while (i12 < cpgPosListInRegion.size()) {
            Integer xPos = width / (cpgPosListInRegion.size() + 1) * (i12 + 1);
            alignSeries.add(xPos, (Number)0);
            xPos = i12;
            i12 = i12 + 1;
            unCpgSeries = i12;
        }
        dataset.addSeries(alignSeries);
        String title = "Average methylation:" + String.format("%1.8f", sumCpgRate);
        JFreeChart jfreechart = ChartFactory.createXYLineChart(title, "Genomic position", "", dataset, PlotOrientation.VERTICAL, false, false, false);
        jfreechart.setTitle(new TextTitle(title, new Font("", 0, width / (2 * cpgPosListInRegion.size() + 1))));
        XYPlot xyPlot = jfreechart.getXYPlot();
        xyPlot.setBackgroundPaint(Color.WHITE);
        xyPlot.setDomainGridlinesVisible(false);
        xyPlot.setRangeGridlinesVisible(false);
        xyPlot.setOutlineVisible(true);
        CustomXYLineAndShapeRenderer2 xyLineAndShapeRenderer = new CustomXYLineAndShapeRenderer2();
        xyLineAndShapeRenderer.setLabelList(cpgPosListInRegion);
        Double circleSize = (double)width.intValue() / (double)(2 * cpgPosListInRegion.size() + 1);
        Ellipse2D.Double circle = new Ellipse2D.Double(-circleSize.doubleValue() / 2.0, -circleSize.doubleValue() / 2.0, circleSize, circleSize);
        for (int i13 = 0; i13 < dataset.getSeriesCount() - 1; ++i13) {
            if (i13 % 3 == 0) {
                xyLineAndShapeRenderer.setSeriesShape(i13, circle);
                xyLineAndShapeRenderer.setSeriesShapesFilled(i13, false);
                xyLineAndShapeRenderer.setSeriesPaint(i13, Color.BLACK);
                continue;
            }
            if (i13 % 3 == 1) {
                xyLineAndShapeRenderer.setSeriesShape(i13, circle);
                xyLineAndShapeRenderer.setSeriesShapesFilled(i13, true);
                xyLineAndShapeRenderer.setSeriesLinesVisible(i13, false);
                xyLineAndShapeRenderer.setSeriesPaint(i13, Color.BLACK);
                continue;
            }
            Ellipse2D.Double circle1 = new Ellipse2D.Double(-circleSize.doubleValue() / 2.0, -circleSize.doubleValue() / 2.0, circleSize - 2.0, circleSize - 2.0);
            xyLineAndShapeRenderer.setSeriesShape(i13, circle1);
            xyLineAndShapeRenderer.setSeriesShapesFilled(i13, true);
            xyLineAndShapeRenderer.setSeriesLinesVisible(i13, false);
            xyLineAndShapeRenderer.setSeriesPaint(i13, Color.WHITE);
        }
        xyLineAndShapeRenderer.setSeriesLinesVisible(dataset.getSeriesCount() - 1, false);
        xyLineAndShapeRenderer.setSeriesShapesVisible(dataset.getSeriesCount() - 1, false);
        xyLineAndShapeRenderer.setSeriesItemLabelsVisible(dataset.getSeriesCount() - 1, true);
        xyPlot.setRenderer(xyLineAndShapeRenderer);
        XYItemRenderer xyItemRenderer = xyPlot.getRenderer();
        DecimalFormat decimalformat = new DecimalFormat("############");
        xyItemRenderer.setDefaultItemLabelGenerator(new StandardXYItemLabelGenerator("{1}", (NumberFormat)decimalformat, (NumberFormat)decimalformat));
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER, TextAnchor.CENTER, -0.8);
        xyItemRenderer.setSeriesPositiveItemLabelPosition(dataset.getSeriesCount() - 1, itemLabelPosition);
        xyItemRenderer.setSeriesItemLabelPaint(dataset.getSeriesCount() - 1, Color.GRAY);
        xyItemRenderer.setSeriesItemLabelFont(dataset.getSeriesCount() - 1, new Font("", 0, circleSize.intValue() / 2));
        xyPlot.setRenderer(xyItemRenderer);
        ValueAxis domainAxis = xyPlot.getDomainAxis();
        domainAxis.setLowerMargin(0.1);
        domainAxis.setUpperMargin(0.1);
        domainAxis.setVisible(false);
        NumberAxis rangeAxis = (NumberAxis)xyPlot.getRangeAxis();
        Range range = new Range(0.0, 20.0);
        rangeAxis.setRangeWithMargins(range);
        rangeAxis.setVisible(false);
        String Tag = "";
        if (this.args.getOutFormat().equals("png")) {
            Tag = this.args.getTag() + ".simulation.png";
            this.util.saveAsPng(jfreechart, Tag, width, height);
        } else {
            Tag = this.args.getTag() + ".simulation.pdf";
            this.util.saveAsPdf(jfreechart, Tag, width, height);
        }
        return true;
    }

    private void dfs(Integer x, Integer y, Integer[][] cpgHpMatInRegion, List<Double[][]> toLeftList, List<Double[][]> toRightList, List<Integer> cpgPosListInRegion) {
        Integer check;
        if (y < 0 || y >= cpgPosListInRegion.size()) {
            return;
        }
        if (cpgHpMatInRegion[x][y] != 0) {
            return;
        }
        if (y - 1 >= 0 && cpgHpMatInRegion[x][y - 1] != 0) {
            check = cpgHpMatInRegion[x][y - 1] == -1 ? 0 : 1;
            cpgHpMatInRegion[x.intValue()][y.intValue()] = toRightList.get(y - 1)[check][0] > Math.random() ? Integer.valueOf(-1) : Integer.valueOf(1);
            this.dfs(x, y + 1, cpgHpMatInRegion, toLeftList, toRightList, cpgPosListInRegion);
        }
        if (y + 1 < cpgPosListInRegion.size() && cpgHpMatInRegion[x][y + 1] != 0) {
            check = cpgHpMatInRegion[x][y + 1] == -1 ? 0 : 1;
            cpgHpMatInRegion[x.intValue()][y.intValue()] = toLeftList.get(y + 1)[check][0] > Math.random() ? Integer.valueOf(-1) : Integer.valueOf(1);
            this.dfs(x, y - 1, cpgHpMatInRegion, toLeftList, toRightList, cpgPosListInRegion);
        }
    }
}

