/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.args.StatArgs;
import com.bean.MHapInfo;
import com.bean.R2Info;
import com.bean.Region;
import com.bean.StatInfo;
import com.common.Util;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stat {
    public static final Logger log = LoggerFactory.getLogger(Stat.class);
    StatArgs args = new StatArgs();
    Util util = new Util();

    public void stat(StatArgs statArgs) throws Exception {
        log.info("Stat start!");
        this.args = statArgs;
        boolean checkResult = this.checkArgs();
        if (!checkResult) {
            log.error("Checkargs fail, please check the command.");
            return;
        }
        List<Object> regionList = new ArrayList();
        if (this.args.getRegion() != null && !this.args.getRegion().equals("")) {
            Region region = this.util.parseRegion(this.args.getRegion());
            regionList.add(region);
        } else {
            regionList = this.util.getBedRegionList(this.args.getBedPath());
        }
        BufferedWriter bufferedWriter = this.util.createOutputFile("", this.args.getOutputFile());
        String[] metrics = this.args.getMetrics().split(" ");
        ArrayList<String> metricsList = new ArrayList<String>();
        for (String metric : metrics) {
            metricsList.add(metric);
        }
        bufferedWriter.write(this.printHead(metricsList));
        for (Region region : regionList) {
            List<Integer> cpgPosList;
            List<MHapInfo> mHapInfoListMerged = this.util.parseMhapFile(this.args.getMhapPath(), region, this.args.getStrand(), true);
            if (mHapInfoListMerged.size() < 1 || (cpgPosList = this.util.parseCpgFileWithShift(this.args.getCpgPath(), region, 500)).size() < 1) continue;
            boolean getStatResult = this.getStat(mHapInfoListMerged, cpgPosList, region, metricsList, bufferedWriter);
            if (!getStatResult) {
                log.error("getStat fail, please check the command.");
                return;
            }
            log.info("Region: " + region.toHeadString() + " calculate end!");
        }
        bufferedWriter.close();
        log.info("Stat end!");
    }

    private boolean checkArgs() {
        if (this.args.getMhapPath().equals("")) {
            log.error("mhapPath can not be null.");
            return false;
        }
        if (this.args.getCpgPath().equals("")) {
            log.error("cpgPath can not be null.");
            return false;
        }
        if (!this.args.getRegion().equals("") && !this.args.getBedPath().equals("")) {
            log.error("Can not input region and bedPath at the same time.");
            return false;
        }
        if (!(this.args.getStrand().equals("plus") || this.args.getStrand().equals("minus") || this.args.getStrand().equals("both"))) {
            log.error("The strand must be one of plus, minus or both");
            return false;
        }
        return true;
    }

    public String printHead(List<String> metricsList) {
        String line = "chr\tstart\tend\tnReads\tmBase\tcBase\ttBase\tK4plus\tnDR\tnMR\tnCPG\tnPairs";
        for (int i = 0; i < metricsList.size(); ++i) {
            if (metricsList.get(i).equals("MM")) {
                line = line + "\tMM";
                continue;
            }
            if (metricsList.get(i).equals("CHALM")) {
                line = line + "\tCHALM";
                continue;
            }
            if (metricsList.get(i).equals("PDR")) {
                line = line + "\tPDR";
                continue;
            }
            if (metricsList.get(i).equals("MHL")) {
                line = line + "\tMHL";
                continue;
            }
            if (metricsList.get(i).equals("MBS")) {
                line = line + "\tMBS";
                continue;
            }
            if (metricsList.get(i).equals("MCR")) {
                line = line + "\tMCR";
                continue;
            }
            if (metricsList.get(i).equals("Entropy")) {
                line = line + "\tEntropy";
                continue;
            }
            if (!metricsList.get(i).equals("R2")) continue;
            line = line + "\tR2";
        }
        line = line + "\n";
        return line;
    }

    private boolean getStat(List<MHapInfo> mHapInfoListMerged, List<Integer> cpgPosList, Region region, List<String> metricsList, BufferedWriter bufferedWriter) throws Exception {
        List<Integer> cpgPosListInRegion = this.util.getCpgPosListInRegion(cpgPosList, region);
        if (this.args.getCutReads().booleanValue()) {
            for (int i = 0; i < mHapInfoListMerged.size(); ++i) {
                MHapInfo mHapInfo = mHapInfoListMerged.get(i);
                String cpg = this.util.cutReads(mHapInfo, cpgPosList, cpgPosListInRegion);
                mHapInfo.setCpg(cpg);
            }
        }
        Integer nReads = 0;
        Integer mBase = 0;
        Integer cBase = 0;
        Integer tBase = 0;
        Integer K4plus = 0;
        Integer nDR = 0;
        Integer nMR = 0;
        for (int i = 0; i < mHapInfoListMerged.size(); ++i) {
            int j;
            MHapInfo mHapInfo = mHapInfoListMerged.get(i);
            String cpg = mHapInfo.getCpg();
            Integer cnt = mHapInfo.getCnt();
            nReads = nReads + cnt;
            tBase = tBase + cpg.length() * cnt;
            for (j = 0; j < cpg.length(); ++j) {
                if (cpg.charAt(j) != '1') continue;
                mBase = mBase + cnt;
            }
            if (cpg.contains("1")) {
                for (j = 0; j < cpg.length(); ++j) {
                    if (cpg.charAt(j) != '0') continue;
                    cBase = cBase + cnt;
                }
            }
            if (cpg.length() < this.args.getK()) continue;
            K4plus = K4plus + cnt;
            if (!cpg.contains("1")) continue;
            nMR = nMR + cnt;
            if (!cpg.contains("0")) continue;
            nDR = nDR + cnt;
        }
        StatInfo statInfo = new StatInfo();
        statInfo.setChr(region.getChrom());
        statInfo.setStart(region.getStart());
        statInfo.setEnd(region.getEnd());
        statInfo.setnReads(nReads);
        statInfo.setmBase(mBase);
        statInfo.setcBase(cBase);
        statInfo.settBase(tBase);
        statInfo.setK4plus(K4plus);
        statInfo.setnDR(nDR);
        statInfo.setnMR(nMR);
        statInfo.setnCPG(cpgPosListInRegion.size());
        Double[] nPairsAndR2 = this.calculateNPairsAndR2(mHapInfoListMerged, cpgPosList, cpgPosListInRegion, this.args.getR2Cov());
        statInfo.setnPairs(nPairsAndR2[0].intValue());
        for (int i = 0; i < metricsList.size(); ++i) {
            if (metricsList.get(i).equals("MM")) {
                if (nReads < this.args.getCpgCov()) {
                    statInfo.setMM(Double.NaN);
                    continue;
                }
                statInfo.setMM(mBase.doubleValue() / tBase.doubleValue());
                continue;
            }
            if (metricsList.get(i).equals("CHALM")) {
                if (K4plus < this.args.getK4Plus()) {
                    statInfo.setCHALM(Double.NaN);
                    continue;
                }
                statInfo.setCHALM(nMR.doubleValue() / K4plus.doubleValue());
                continue;
            }
            if (metricsList.get(i).equals("PDR")) {
                if (K4plus < this.args.getK4Plus()) {
                    statInfo.setPDR(Double.NaN);
                    continue;
                }
                statInfo.setPDR(nDR.doubleValue() / K4plus.doubleValue());
                continue;
            }
            if (metricsList.get(i).equals("MHL")) {
                if (K4plus < this.args.getK4Plus()) {
                    statInfo.setMHL(Double.NaN);
                    continue;
                }
                statInfo.setMHL(this.util.calculateMHL(mHapInfoListMerged, this.args.getMinK(), this.args.getMaxK()));
                continue;
            }
            if (metricsList.get(i).equals("MBS")) {
                if (K4plus < this.args.getK4Plus()) {
                    statInfo.setMBS(Double.NaN);
                    continue;
                }
                statInfo.setMBS(this.util.calculateMBS(mHapInfoListMerged, this.args.getK()));
                continue;
            }
            if (metricsList.get(i).equals("MCR")) {
                if (nReads < this.args.getCpgCov()) {
                    statInfo.setMCR(Double.NaN);
                    continue;
                }
                statInfo.setMCR(cBase.doubleValue() / tBase.doubleValue());
                continue;
            }
            if (metricsList.get(i).equals("Entropy")) {
                if (K4plus < this.args.getK4Plus()) {
                    statInfo.setEntropy(Double.NaN);
                    continue;
                }
                statInfo.setEntropy(this.util.calculateEntropy(mHapInfoListMerged, this.args.getK()));
                continue;
            }
            if (!metricsList.get(i).equals("R2")) continue;
            statInfo.setR2(nPairsAndR2[1]);
        }
        bufferedWriter.write(statInfo.print(metricsList));
        return true;
    }

    public Double[] calculateNPairsAndR2(List<MHapInfo> mHapInfoList, List<Integer> cpgPosList, List<Integer> cpgPosListInRegion, Integer r2Cov) {
        Double[] nPairsAndR2 = new Double[2];
        Double nPairs = 0.0;
        Double R2 = 0.0;
        Integer R2Cnt = 0;
        for (int i = 0; i < cpgPosListInRegion.size(); ++i) {
            for (int j = i + 1; j < cpgPosListInRegion.size(); ++j) {
                R2Info r2Info = this.util.getR2FromList(mHapInfoList, cpgPosList, cpgPosListInRegion.get(i), cpgPosListInRegion.get(j), r2Cov);
                if (r2Info == null) continue;
                Number number = nPairs;
                Number number2 = nPairs = Double.valueOf(nPairs + 1.0);
                if (r2Info.getR2().isNaN()) continue;
                number = R2Cnt;
                R2Cnt = R2Cnt + 1;
                number2 = R2Cnt;
                R2 = R2 + r2Info.getR2();
            }
        }
        nPairsAndR2[0] = nPairs;
        nPairsAndR2[1] = R2 / (double)R2Cnt.intValue();
        return nPairsAndR2;
    }
}

