/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.args.ScatterPlotArgs;
import com.bean.Region;
import com.common.Util;
import com.common.bigwigTool.BBFileReader;
import com.common.bigwigTool.BigWigIterator;
import com.common.bigwigTool.WigItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultXYDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScatterPlot {
    public static final Logger log = LoggerFactory.getLogger(ScatterPlot.class);
    ScatterPlotArgs args = new ScatterPlotArgs();
    Util util = new Util();
    public static final Integer MAXSIZE = 10000;

    public void scatterPlot(ScatterPlotArgs scatterPlotArgs) throws Exception {
        Integer width;
        log.info("ScatterPlot start!");
        this.args = scatterPlotArgs;
        boolean checkResult = this.checkArgs();
        if (!checkResult) {
            log.error("Checkargs fail, please check the command.");
            return;
        }
        List<Region> regionList = this.util.getBedRegionList(this.args.getBedPath());
        if (regionList.size() < 1) {
            log.error("The bed file is null, please check.");
            return;
        }
        DefaultXYDataset dataset = new DefaultXYDataset();
        double[][] xyData = new double[2][regionList.size()];
        int index = 0;
        for (Region region : regionList) {
            String startChr = region.getChrom();
            Integer startBase = region.getStart();
            String endChr = region.getChrom();
            Integer endBase = region.getEnd();
            double[] xValue = new double[MAXSIZE.intValue()];
            double[] yValue = new double[MAXSIZE.intValue()];
            Integer realIndex = 0;
            BBFileReader reader1 = new BBFileReader(this.args.getBigwig1());
            BigWigIterator iter1 = reader1.getBigWigIterator(startChr, startBase, endChr, endBase, true);
            BBFileReader reader2 = new BBFileReader(this.args.getBigwig2());
            BigWigIterator iter2 = reader2.getBigWigIterator(startChr, startBase, endChr, endBase, true);
            while (iter1.hasNext() && iter2.hasNext()) {
                WigItem wigItem1 = iter1.next();
                WigItem wigItem2 = iter2.next();
                if (wigItem1.getStartBase() > wigItem2.getStartBase()) {
                    iter2.next();
                    continue;
                }
                if (wigItem1.getStartBase() < wigItem2.getStartBase()) {
                    iter1.next();
                    continue;
                }
                xValue[realIndex.intValue()] = wigItem1.getWigValue();
                yValue[realIndex.intValue()] = wigItem2.getWigValue();
                Integer n = realIndex;
                Integer n2 = realIndex = Integer.valueOf(realIndex + 1);
            }
            reader1.close();
            reader2.close();
            double[] xValueWithoutZero = Arrays.stream(xValue).filter(value -> value != 0.0).toArray();
            double[] yValueWithoutZero = Arrays.stream(yValue).filter(value -> value != 0.0).toArray();
            double xValueOfThisRegion = Arrays.stream(xValueWithoutZero).sum() / (double)xValueWithoutZero.length;
            double yValueOfThisRegion = Arrays.stream(yValueWithoutZero).sum() / (double)yValueWithoutZero.length;
            xyData[0][index] = xValueOfThisRegion;
            xyData[1][index] = yValueOfThisRegion;
            ++index;
        }
        dataset.addSeries((Comparable)((Object)"xyData"), xyData);
        Integer height = width = Integer.valueOf(1000);
        String bedName = new File(this.args.getBedPath()).getName();
        String title = bedName.substring(0, bedName.lastIndexOf("."));
        String bigwig1Name = new File(this.args.getBigwig1()).getName();
        String bigwig2Name = new File(this.args.getBigwig2()).getName();
        String xAxisLabel = bigwig1Name.substring(0, bigwig1Name.lastIndexOf("."));
        String yAxisLabel = bigwig2Name.substring(0, bigwig2Name.lastIndexOf("."));
        JFreeChart jfreechart = ChartFactory.createScatterPlot(title, xAxisLabel, yAxisLabel, dataset, PlotOrientation.VERTICAL, false, false, false);
        TextTitle textTitle = new TextTitle(title, new Font("", 0, width / 25));
        jfreechart.setTitle(textTitle);
        XYPlot xyPlot = jfreechart.getXYPlot();
        xyPlot.setBackgroundPaint(Color.WHITE);
        xyPlot.setDomainGridlinesVisible(false);
        xyPlot.setRangeGridlinesVisible(false);
        xyPlot.setOutlineVisible(true);
        XYItemRenderer renderer = xyPlot.getRenderer();
        renderer.setSeriesShape(0, new Ellipse2D.Double(0.0, 0.0, 2.0, 2.0));
        renderer.setSeriesPaint(0, Color.red);
        NumberAxis xAxis = new NumberAxis();
        xAxis.setLabel(xAxisLabel);
        xAxis.setLabelFont(new Font("", 0, width / 30));
        xAxis.setRange(new Range(0.0, 1.0));
        xAxis.setVisible(true);
        xAxis.setTickUnit(new NumberTickUnit(0.1));
        xAxis.setTickLabelFont(new Font("", 0, width / 40));
        xAxis.setTickMarksVisible(false);
        xAxis.setAxisLineVisible(false);
        xyPlot.setDomainAxis(xAxis);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setLabel(yAxisLabel);
        yAxis.setLabelFont(new Font("", 0, width / 30));
        yAxis.setRange(new Range(0.0, 1.0));
        yAxis.setVisible(true);
        yAxis.setTickUnit(new NumberTickUnit(0.1));
        yAxis.setTickLabelFont(new Font("", 0, width / 40));
        yAxis.setTickMarksVisible(false);
        yAxis.setAxisLineVisible(false);
        xyPlot.setRangeAxis(yAxis);
        String outputFilename = "";
        if (this.args.getOutFormat().equals("png")) {
            outputFilename = this.args.getTag() + ".scatterPlot.png";
            this.util.saveAsPng(jfreechart, outputFilename, width, height);
        } else {
            outputFilename = this.args.getTag() + ".scatterPlot.pdf";
            this.util.saveAsPdf(jfreechart, outputFilename, width, height);
        }
        log.info("ScatterPlot end!");
    }

    private boolean checkArgs() {
        if (this.args.getBigwig1() == null || this.args.getBigwig1().equals("")) {
            log.error("The first bigwig file can not be null.");
            return false;
        }
        if (this.args.getBigwig2() == null || this.args.getBigwig2().equals("")) {
            log.error("The second bigwig file can not be null.");
            return false;
        }
        if (this.args.getTag() == null || this.args.getTag().equals("")) {
            log.error("The tag can not be null.");
            return false;
        }
        if (!this.args.getOutFormat().equals("png") && !this.args.getOutFormat().equals("pdf")) {
            log.error("The output format must be pdf or png");
            return false;
        }
        return true;
    }
}

