/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.args.ProfilePlotArgs;
import com.bean.Region;
import com.common.Util;
import com.common.bigwigTool.BBFileReader;
import com.common.bigwigTool.BigWigIterator;
import com.common.bigwigTool.WigItem;
import com.rewrite.ProfileCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.File;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilePlot {
    public static final Logger log = LoggerFactory.getLogger(ProfilePlot.class);
    ProfilePlotArgs args = new ProfilePlotArgs();
    Util util = new Util();
    public static final Integer MAXSIZE = 10000;

    public void profilePlot(ProfilePlotArgs profilePlotArgs) throws Exception {
        log.info("ProfilePlot start!");
        this.args = profilePlotArgs;
        boolean checkResult = this.checkArgs();
        if (!checkResult) {
            log.error("Checkargs fail, please check the command.");
            return;
        }
        Integer coreWindowNum = this.args.getWindowNum();
        Integer upWindowNum = coreWindowNum / 2;
        Integer upWindowLength = this.args.getUpLength() / upWindowNum;
        Integer downWindowNum = coreWindowNum / 2;
        Integer downWindowLength = this.args.getDownLength() / downWindowNum;
        String[] bedPaths = this.args.getBedPaths().split(" ");
        BBFileReader reader = new BBFileReader(this.args.getBigwig());
        DefaultCategoryDataset lineDataset = new DefaultCategoryDataset();
        for (String bedPath : bedPaths) {
            String bedFileName = new File(bedPath).getName();
            String bedFileLabel = bedFileName.substring(0, bedFileName.lastIndexOf("."));
            List<Region> regionList = this.util.getBedRegionList(bedPath);
            if (regionList.size() < 1) {
                log.info("The bed file:" + bedPath + " is null, please check.");
                continue;
            }
            Double[][] matrix = new Double[regionList.size()][upWindowNum + coreWindowNum + downWindowNum + 1];
            for (int i = 0; i < upWindowNum + coreWindowNum + downWindowNum + 1; ++i) {
                Double kbPos;
                Double sumAverageOfWindow = 0.0;
                Integer notNaNAverageNumOfWindow = 0;
                String xAxisPos = "";
                for (int j = 0; j < regionList.size(); ++j) {
                    Double averageOfWindowOfRegion;
                    Integer n;
                    Integer n2;
                    Region region = regionList.get(j);
                    Integer regionLength = region.getEnd() - region.getStart() + 1;
                    Integer coreWindowLength = regionLength / coreWindowNum;
                    Integer startSiteOfWindow = 0;
                    Integer endSiteOfWindow = 0;
                    if (i < upWindowNum) {
                        startSiteOfWindow = region.getStart() - this.args.getUpLength() + upWindowLength * i;
                        endSiteOfWindow = startSiteOfWindow + upWindowLength;
                    } else if (i >= upWindowNum && i < upWindowNum + coreWindowNum) {
                        startSiteOfWindow = region.getStart() + coreWindowLength * (i - upWindowNum);
                        endSiteOfWindow = startSiteOfWindow + coreWindowLength;
                    } else if (i >= upWindowNum + coreWindowNum) {
                        startSiteOfWindow = region.getEnd() + downWindowLength * (i - upWindowNum - coreWindowNum);
                        endSiteOfWindow = startSiteOfWindow + downWindowLength;
                    }
                    BigWigIterator iter = reader.getBigWigIterator(region.getChrom(), startSiteOfWindow, region.getChrom(), endSiteOfWindow, true);
                    Double sumOfWindowOfRegion = 0.0;
                    Integer numOfWindowOfRegion = 0;
                    while (iter.hasNext()) {
                        WigItem wigItem = iter.next();
                        sumOfWindowOfRegion = sumOfWindowOfRegion + (double)wigItem.getWigValue();
                        n2 = numOfWindowOfRegion;
                        n = numOfWindowOfRegion = Integer.valueOf(numOfWindowOfRegion + 1);
                    }
                    matrix[j][i] = averageOfWindowOfRegion = Double.valueOf(numOfWindowOfRegion > 0 ? sumOfWindowOfRegion / (double)numOfWindowOfRegion.intValue() : Double.NaN);
                    if (averageOfWindowOfRegion.isNaN()) continue;
                    sumAverageOfWindow = sumAverageOfWindow + averageOfWindowOfRegion;
                    n2 = notNaNAverageNumOfWindow;
                    n = notNaNAverageNumOfWindow = Integer.valueOf(notNaNAverageNumOfWindow + 1);
                }
                Double average = sumAverageOfWindow > 0.0 ? sumAverageOfWindow / (double)notNaNAverageNumOfWindow.intValue() : 0.0;
                String xAisLabel = "";
                if (i < upWindowNum) {
                    xAxisPos = String.valueOf(-this.args.getUpLength().intValue() + upWindowLength * i);
                    kbPos = Double.valueOf(xAxisPos) / 1000.0;
                    xAisLabel = String.valueOf(kbPos).endsWith(".0") ? kbPos.intValue() + "Kb" : kbPos + "Kb";
                } else if (i == upWindowNum) {
                    xAisLabel = "start";
                } else if (i > upWindowNum && i < upWindowNum + coreWindowNum) {
                    xAisLabel = String.valueOf(i - upWindowNum);
                } else if (i == upWindowNum + coreWindowNum) {
                    xAisLabel = "end";
                } else if (i > upWindowNum + coreWindowNum) {
                    xAxisPos = String.valueOf(downWindowLength * (i - upWindowNum - coreWindowNum));
                    kbPos = Double.valueOf(xAxisPos) / 1000.0;
                    xAisLabel = Math.abs(kbPos - (double)Math.round(kbPos)) < Double.MIN_VALUE ? kbPos.intValue() + "Kb" : kbPos + "Kb";
                }
                lineDataset.addValue(average, (Comparable)((Object)bedFileLabel), (Comparable)((Object)xAisLabel));
            }
            log.info("Read " + bedPath + " end!");
            if (!this.args.isMatrixFlag()) continue;
            BufferedWriter bufferedWriter = this.util.createOutputFile("", bedFileLabel + ".profilePlot_matrix.txt");
            for (int i = 0; i < matrix.length; ++i) {
                String matrixLine = regionList.get(i).toHeadString();
                for (int j = 0; j < matrix[0].length; ++j) {
                    matrixLine = matrixLine + "\t" + matrix[i][j];
                }
                bufferedWriter.write(matrixLine + "\n");
            }
            bufferedWriter.close();
        }
        Integer width = coreWindowNum * 100 < 500 ? 500 : coreWindowNum * 100;
        JFreeChart jfreechart = this.generateLinePlot(lineDataset, width);
        Integer height = width / 2;
        String outputFilename = "";
        if (this.args.getOutFormat().equals("png")) {
            outputFilename = this.args.getTag() + ".profilePlot.png";
            this.util.saveAsPng(jfreechart, outputFilename, width, height);
        } else {
            outputFilename = this.args.getTag() + ".profilePlot.pdf";
            this.util.saveAsPdf(jfreechart, outputFilename, width, height);
        }
        log.info("ProfilePlot end!");
    }

    private boolean checkArgs() {
        if (this.args.getBigwig() == null || this.args.getBigwig().equals("")) {
            log.error("The bigwig file can not be null.");
            return false;
        }
        if (this.args.getBedPaths() == null || this.args.getBedPaths().equals("")) {
            log.error("The bed file can not be null.");
            return false;
        }
        if (this.args.getTag() == null || this.args.getTag().equals("")) {
            log.error("The tag can not be null.");
            return false;
        }
        if (!this.args.getOutFormat().equals("png") && !this.args.getOutFormat().equals("pdf")) {
            log.error("The output format must be pdf or png");
            return false;
        }
        return true;
    }

    private JFreeChart generateLinePlot(CategoryDataset dataset, Integer width) {
        String bigwigName = new File(this.args.getBigwig()).getName();
        String title = bigwigName.substring(0, bigwigName.lastIndexOf("."));
        JFreeChart jFreeChart = ChartFactory.createLineChart(title, "", "", dataset, PlotOrientation.VERTICAL, true, true, false);
        LegendTitle legendTitle = jFreeChart.getLegend();
        legendTitle.setMargin(0.0, 0.0, 0.0, width / 50);
        legendTitle.setBorder(0.0, 0.0, 0.0, 0.0);
        legendTitle.setItemFont(new Font("", 0, width / 50));
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setBackgroundPaint(Color.WHITE);
        categoryPlot.setRangeGridlinesVisible(false);
        categoryPlot.setOutlinePaint(Color.BLACK);
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        renderer.setDefaultShapesVisible(false);
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            renderer.setSeriesStroke(i, new BasicStroke(width / 300));
        }
        categoryPlot.setRenderer(renderer);
        ProfileCategoryAxis xAxis = new ProfileCategoryAxis();
        xAxis.setMinorTickMarkInsideLength(3.0f);
        xAxis.setLabelFont(new Font("", 0, width / 50));
        xAxis.setTickLabelFont(new Font("", 0, width / 50));
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        xAxis.setTickMarksVisible(false);
        xAxis.setAxisLineVisible(false);
        categoryPlot.setDomainAxis(xAxis);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setTickUnit(new NumberTickUnit(0.2));
        yAxis.setTickLabelFont(new Font("", 0, width / 50));
        yAxis.setLabelFont(new Font("", 0, width / 50));
        yAxis.setRange(new Range(0.0, 1.0));
        yAxis.setTickMarksVisible(false);
        yAxis.setAxisLineVisible(false);
        categoryPlot.setRangeAxis(yAxis);
        return jFreeChart;
    }
}

